/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.oss;

import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSBlockOutputStream;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSCopyFileContext;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSCopyFileTask;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystemStore;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSInputStream;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSUtils;
import org.apache.hadoop.fs.aliyun.oss.BlockingThreadPoolExecutorService;
import org.apache.hadoop.fs.aliyun.oss.FileStatusAcceptor;
import org.apache.hadoop.fs.aliyun.oss.OSSFileStatus;
import org.apache.hadoop.fs.aliyun.oss.SemaphoredDelegatingExecutor;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunOSSFileSystem
extends FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(AliyunOSSFileSystem.class);
    private URI uri;
    private String bucket;
    private String username;
    private Path workingDir;
    private int blockOutputActiveBlocks;
    private AliyunOSSFileSystemStore store;
    private int maxKeys;
    private int maxReadAheadPartNumber;
    private int maxConcurrentCopyTasksPerDir;
    private ListeningExecutorService boundedThreadPool;
    private ListeningExecutorService boundedCopyThreadPool;
    private static final PathFilter DEFAULT_FILTER = new PathFilter(){

        public boolean accept(Path file) {
            return true;
        }
    };

    public FSDataOutputStream append(Path path, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Append is not supported!");
    }

    public void close() throws IOException {
        try {
            this.store.close();
            this.boundedThreadPool.shutdown();
            this.boundedCopyThreadPool.shutdown();
        }
        finally {
            super.close();
        }
    }

    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        String key = this.pathToKey(path);
        FileStatus status = null;
        try {
            status = this.getFileStatus(path);
            if (status.isDirectory()) {
                throw new FileAlreadyExistsException(path + " is a directory");
            }
            if (!overwrite) {
                throw new FileAlreadyExistsException(path + " already exists");
            }
            LOG.debug("Overwriting file {}", (Object)path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        long uploadPartSize = AliyunOSSUtils.getMultipartSizeProperty(this.getConf(), "fs.oss.multipart.upload.size", 0x6400000L);
        return new FSDataOutputStream((OutputStream)new AliyunOSSBlockOutputStream(this.getConf(), this.store, key, uploadPartSize, (ExecutorService)((Object)new SemaphoredDelegatingExecutor(this.boundedThreadPool, this.blockOutputActiveBlocks, true))), this.statistics);
    }

    public FSDataOutputStream createNonRecursive(Path path, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path parent = path.getParent();
        if (parent != null && !this.getFileStatus(parent).isDirectory()) {
            throw new FileAlreadyExistsException("Not a directory: " + parent);
        }
        return this.create(path, permission, flags.contains(CreateFlag.OVERWRITE), bufferSize, replication, blockSize, progress);
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        try {
            return this.innerDelete(this.getFileStatus(path), recursive);
        }
        catch (FileNotFoundException e) {
            LOG.debug("Couldn't delete {} - does not exist", (Object)path);
            return false;
        }
    }

    private boolean innerDelete(FileStatus status, boolean recursive) throws IOException {
        Path f = status.getPath();
        String p = f.toUri().getPath();
        if (p.equals("/")) {
            FileStatus[] statuses = this.listStatus(status.getPath());
            boolean isEmptyDir = statuses.length <= 0;
            return this.rejectRootDirectoryDelete(isEmptyDir, recursive);
        }
        String key = this.pathToKey(f);
        if (status.isDirectory()) {
            if (!recursive) {
                FileStatus[] statuses = this.listStatus(status.getPath());
                if (statuses.length > 0) {
                    throw new IOException("Cannot remove directory " + f + ": It is not empty!");
                }
                key = AliyunOSSUtils.maybeAddTrailingSlash(key);
                this.store.deleteObject(key);
            } else {
                this.store.deleteDirs(key);
            }
        } else {
            this.store.deleteObject(key);
        }
        this.createFakeDirectoryIfNecessary(f);
        return true;
    }

    private boolean rejectRootDirectoryDelete(boolean isEmptyDir, boolean recursive) throws IOException {
        LOG.info("oss delete the {} root directory of {}", (Object)this.bucket, (Object)recursive);
        if (isEmptyDir) {
            return true;
        }
        if (recursive) {
            return false;
        }
        throw new PathIOException(this.bucket, "Cannot delete root path");
    }

    private void createFakeDirectoryIfNecessary(Path f) throws IOException {
        String key = this.pathToKey(f);
        if (StringUtils.isNotEmpty((String)key) && !this.exists(f)) {
            LOG.debug("Creating new fake directory at {}", (Object)f);
            this.mkdir(this.pathToKey(f.getParent()));
        }
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        Path qualifiedPath = path.makeQualified(this.uri, this.workingDir);
        String key = this.pathToKey(qualifiedPath);
        if (key.length() == 0) {
            return new OSSFileStatus(0L, true, 1, 0L, 0L, qualifiedPath, this.username);
        }
        ObjectMetadata meta = this.store.getObjectMetadata(key);
        if (meta == null && !key.endsWith("/")) {
            key = key + "/";
            meta = this.store.getObjectMetadata(key);
        }
        if (meta == null) {
            ObjectListing listing = this.store.listObjects(key, 1, null, false);
            while (true) {
                if (CollectionUtils.isNotEmpty(listing.getObjectSummaries()) || CollectionUtils.isNotEmpty(listing.getCommonPrefixes())) {
                    return new OSSFileStatus(0L, true, 1, 0L, 0L, qualifiedPath, this.username);
                }
                if (!listing.isTruncated()) break;
                listing = this.store.listObjects(key, 1000, listing.getNextMarker(), false);
            }
            throw new FileNotFoundException(path + ": No such file or directory!");
        }
        if (AliyunOSSUtils.objectRepresentsDirectory(key, meta.getContentLength())) {
            return new OSSFileStatus(0L, true, 1, 0L, meta.getLastModified().getTime(), qualifiedPath, this.username);
        }
        return new OSSFileStatus(meta.getContentLength(), false, 1, this.getDefaultBlockSize(path), meta.getLastModified().getTime(), qualifiedPath, this.username);
    }

    public String getScheme() {
        return "oss";
    }

    public URI getUri() {
        return this.uri;
    }

    public int getDefaultPort() {
        return -1;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Deprecated
    public long getDefaultBlockSize() {
        return this.getConf().getLong("fs.oss.block.size", 0x4000000L);
    }

    public String getCanonicalServiceName() {
        return null;
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.bucket = name.getHost();
        this.uri = URI.create(name.getScheme() + "://" + name.getAuthority());
        this.username = UserGroupInformation.getCurrentUser().getShortUserName();
        this.workingDir = new Path("/user", this.username).makeQualified(this.uri, null);
        long keepAliveTime = AliyunOSSUtils.longOption(conf, "fs.oss.threads.keepalivetime", 60L, 0L);
        this.blockOutputActiveBlocks = AliyunOSSUtils.intOption(conf, "fs.oss.upload.active.blocks", 4, 1);
        this.store = new AliyunOSSFileSystemStore();
        this.store.initialize(name, conf, this.username, this.statistics);
        this.maxKeys = conf.getInt("fs.oss.paging.maximum", 1000);
        int threadNum = AliyunOSSUtils.intPositiveOption(conf, "fs.oss.multipart.download.threads", 10);
        int totalTasks = AliyunOSSUtils.intPositiveOption(conf, "fs.oss.max.total.tasks", 128);
        this.maxReadAheadPartNumber = AliyunOSSUtils.intPositiveOption(conf, "fs.oss.multipart.download.ahead.part.max.number", 4);
        this.boundedThreadPool = BlockingThreadPoolExecutorService.newInstance(threadNum, totalTasks, keepAliveTime, TimeUnit.SECONDS, "oss-transfer-shared");
        this.maxConcurrentCopyTasksPerDir = AliyunOSSUtils.intPositiveOption(conf, "fs.oss.max.copy.tasks.per.dir", 5);
        int maxCopyThreads = AliyunOSSUtils.intPositiveOption(conf, "fs.oss.max.copy.threads", 25);
        int maxCopyTasks = AliyunOSSUtils.intPositiveOption(conf, "fs.oss.max.copy.tasks", 0xA00000);
        this.boundedCopyThreadPool = BlockingThreadPoolExecutorService.newInstance(maxCopyThreads, maxCopyTasks, 60L, TimeUnit.SECONDS, "oss-copy-unbounded");
        this.setConf(conf);
    }

    private String pathToKey(Path path) {
        if (!path.isAbsolute()) {
            path = new Path(this.workingDir, path);
        }
        return path.toUri().getPath().substring(1);
    }

    private Path keyToPath(String key) {
        return new Path("/" + key);
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        String key = this.pathToKey(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug("List status for path: " + path);
        }
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        FileStatus fileStatus = this.getFileStatus(path);
        if (fileStatus.isDirectory()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("listStatus: doing listObjects for directory " + key);
            }
            ObjectListing objects = this.store.listObjects(key, this.maxKeys, null, false);
            while (true) {
                for (OSSObjectSummary objectSummary : objects.getObjectSummaries()) {
                    String objKey = objectSummary.getKey();
                    if (objKey.equals(key + "/")) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Ignoring: " + objKey);
                        continue;
                    }
                    Path keyPath = this.keyToPath(objectSummary.getKey()).makeQualified(this.uri, this.workingDir);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding: fi: " + keyPath);
                    }
                    result.add(new OSSFileStatus(objectSummary.getSize(), false, 1, this.getDefaultBlockSize(keyPath), objectSummary.getLastModified().getTime(), keyPath, this.username));
                }
                for (String prefix : objects.getCommonPrefixes()) {
                    if (prefix.equals(key + "/")) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Ignoring: " + prefix);
                        continue;
                    }
                    Path keyPath = this.keyToPath(prefix).makeQualified(this.uri, this.workingDir);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding: rd: " + keyPath);
                    }
                    result.add(this.getFileStatus(keyPath));
                }
                if (objects.isTruncated()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("listStatus: list truncated - getting next batch");
                    }
                    String nextMarker = objects.getNextMarker();
                    objects = this.store.listObjects(key, this.maxKeys, nextMarker, false);
                    continue;
                }
                break;
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding: rd (not a dir): " + path);
            }
            result.add(fileStatus);
        }
        return result.toArray(new FileStatus[result.size()]);
    }

    public RemoteIterator<LocatedFileStatus> listFiles(final Path f, boolean recursive) throws IOException {
        Path qualifiedPath = f.makeQualified(this.uri, this.workingDir);
        final FileStatus status = this.getFileStatus(qualifiedPath);
        PathFilter filter = new PathFilter(){

            public boolean accept(Path path) {
                return status.isFile() || !path.equals((Object)f);
            }
        };
        FileStatusAcceptor.AcceptFilesOnly acceptor = new FileStatusAcceptor.AcceptFilesOnly(qualifiedPath);
        return this.innerList(f, status, filter, acceptor, recursive);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws IOException {
        return this.listLocatedStatus(f, DEFAULT_FILTER);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f, PathFilter filter) throws IOException {
        Path qualifiedPath = f.makeQualified(this.uri, this.workingDir);
        FileStatus status = this.getFileStatus(qualifiedPath);
        FileStatusAcceptor.AcceptAllButSelf acceptor = new FileStatusAcceptor.AcceptAllButSelf(qualifiedPath);
        return this.innerList(f, status, filter, acceptor, false);
    }

    private RemoteIterator<LocatedFileStatus> innerList(Path f, FileStatus status, PathFilter filter, FileStatusAcceptor acceptor, boolean recursive) throws IOException {
        Path qualifiedPath = f.makeQualified(this.uri, this.workingDir);
        String key = this.pathToKey(qualifiedPath);
        if (status.isFile()) {
            LOG.debug("{} is a File", (Object)qualifiedPath);
            BlockLocation[] locations = this.getFileBlockLocations(status, 0L, status.getLen());
            return this.store.singleStatusRemoteIterator((FileStatus)(filter.accept(f) ? status : null), locations);
        }
        return this.store.createLocatedFileStatusIterator(key, this.maxKeys, this, filter, acceptor, recursive ? null : "/");
    }

    private boolean mkdir(String key) throws IOException {
        String dirName = key;
        if (StringUtils.isNotEmpty((String)key)) {
            if (!key.endsWith("/")) {
                dirName = dirName + "/";
            }
            this.store.storeEmptyFile(dirName);
        }
        return true;
    }

    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        try {
            FileStatus fileStatus = this.getFileStatus(path);
            if (fileStatus.isDirectory()) {
                return true;
            }
            throw new FileAlreadyExistsException("Path is a file: " + path);
        }
        catch (FileNotFoundException e) {
            this.validatePath(path);
            String key = this.pathToKey(path);
            return this.mkdir(key);
        }
    }

    private void validatePath(Path path) throws IOException {
        Path fPart = path.getParent();
        while (true) {
            try {
                FileStatus fileStatus = this.getFileStatus(fPart);
                if (!fileStatus.isDirectory()) {
                    throw new FileAlreadyExistsException(String.format("Can't make directory for path '%s', it is a file.", fPart));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if ((fPart = fPart.getParent()) != null) continue;
            }
            break;
        }
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        FileStatus fileStatus = this.getFileStatus(path);
        if (fileStatus.isDirectory()) {
            throw new FileNotFoundException("Can't open " + path + " because it is a directory");
        }
        return new FSDataInputStream((InputStream)((Object)new AliyunOSSInputStream(this.getConf(), (ExecutorService)((Object)new SemaphoredDelegatingExecutor(this.boundedThreadPool, this.maxReadAheadPartNumber, true)), this.maxReadAheadPartNumber, this.store, this.pathToKey(path), fileStatus.getLen(), this.statistics)));
    }

    public boolean rename(Path srcPath, Path dstPath) throws IOException {
        FileStatus dstStatus;
        Path parent;
        if (srcPath.isRoot()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot rename the root of a filesystem");
            }
            return false;
        }
        for (parent = dstPath.getParent(); parent != null && !srcPath.equals((Object)parent); parent = parent.getParent()) {
        }
        if (parent != null) {
            return false;
        }
        FileStatus srcStatus = this.getFileStatus(srcPath);
        try {
            dstStatus = this.getFileStatus(dstPath);
        }
        catch (FileNotFoundException fnde) {
            dstStatus = null;
        }
        if (dstStatus == null) {
            dstStatus = this.getFileStatus(dstPath.getParent());
            if (!dstStatus.isDirectory()) {
                throw new IOException(String.format("Failed to rename %s to %s, %s is a file", srcPath, dstPath, dstPath.getParent()));
            }
        } else {
            if (srcStatus.getPath().equals((Object)dstStatus.getPath())) {
                return !srcStatus.isDirectory();
            }
            if (dstStatus.isDirectory()) {
                FileStatus[] statuses;
                dstPath = new Path(dstPath, srcPath.getName());
                try {
                    statuses = this.listStatus(dstPath);
                }
                catch (FileNotFoundException fnde) {
                    statuses = null;
                }
                if (statuses != null && statuses.length > 0) {
                    throw new FileAlreadyExistsException(String.format("Failed to rename %s to %s, file already exists or not empty!", srcPath, dstPath));
                }
            } else {
                throw new FileAlreadyExistsException(String.format("Failed to rename %s to %s, file already exists!", srcPath, dstPath));
            }
        }
        boolean succeed = srcStatus.isDirectory() ? this.copyDirectory(srcPath, dstPath) : this.copyFile(srcPath, srcStatus.getLen(), dstPath);
        return srcPath.equals((Object)dstPath) || succeed && this.delete(srcPath, true);
    }

    private boolean copyFile(Path srcPath, long srcLen, Path dstPath) {
        String srcKey = this.pathToKey(srcPath);
        String dstKey = this.pathToKey(dstPath);
        return this.store.copyFile(srcKey, srcLen, dstKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyDirectory(Path srcPath, Path dstPath) throws IOException {
        String srcKey = AliyunOSSUtils.maybeAddTrailingSlash(this.pathToKey(srcPath));
        String dstKey = AliyunOSSUtils.maybeAddTrailingSlash(this.pathToKey(dstPath));
        if (dstKey.startsWith(srcKey)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot rename a directory to a subdirectory of self");
            }
            return false;
        }
        this.store.storeEmptyFile(dstKey);
        AliyunOSSCopyFileContext copyFileContext = new AliyunOSSCopyFileContext();
        ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)((Object)new SemaphoredDelegatingExecutor(this.boundedCopyThreadPool, this.maxConcurrentCopyTasksPerDir, true)));
        ObjectListing objects = this.store.listObjects(srcKey, this.maxKeys, null, true);
        int copiesToFinish = 0;
        while (true) {
            for (OSSObjectSummary objectSummary : objects.getObjectSummaries()) {
                String newKey = dstKey.concat(objectSummary.getKey().substring(srcKey.length()));
                executorService.execute(new AliyunOSSCopyFileTask(this.store, objectSummary.getKey(), objectSummary.getSize(), newKey, copyFileContext));
                ++copiesToFinish;
                if (!copyFileContext.isCopyFailure()) continue;
                break;
            }
            if (!objects.isTruncated()) break;
            String nextMarker = objects.getNextMarker();
            objects = this.store.listObjects(srcKey, this.maxKeys, nextMarker, true);
        }
        copyFileContext.lock();
        try {
            copyFileContext.awaitAllFinish(copiesToFinish);
        }
        catch (InterruptedException e) {
            LOG.warn("interrupted when wait copies to finish");
        }
        finally {
            copyFileContext.unlock();
        }
        return !copyFileContext.isCopyFailure();
    }

    public void setWorkingDirectory(Path dir) {
        this.workingDir = dir;
    }

    public AliyunOSSFileSystemStore getStore() {
        return this.store;
    }
}

