/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.queryserver.client;

import com.aliyun.phoenix.shaded.org.apache.calcite.avatica.BuiltInConnectionProperty;
import com.aliyun.phoenix.shaded.org.apache.calcite.avatica.ConnectStringParser;
import com.aliyun.phoenix.shaded.org.apache.calcite.avatica.DriverVersion;
import com.aliyun.phoenix.shaded.org.apache.calcite.avatica.remote.HADriver;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;

public class Driver
extends HADriver {
    public static final String CONNECT_STRING_PREFIX = "jdbc:phoenix:thin:";
    public static final String JDBC_PROTOCOL_TERMINATOR = ";";
    public static final String PROPERTY_SEPARATOR = "=";

    @Override
    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(Driver.class, "org-apache-phoenix-remote-jdbc.properties", "Phoenix Remote JDBC Driver", "unknown version", "Apache Phoenix", "unknown version");
    }

    @Override
    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        String prefix = this.getConnectStringPrefix();
        String urlSuffix = url.substring(prefix.length());
        this.setConnectionInfo(ConnectStringParser.parse(urlSuffix, info));
        info.putAll((Map<?, ?>)this.readExtraConfigFromUrl(url));
        Connection conn = super.connect(url, info);
        String schemaName = info.getProperty(BuiltInConnectionProperty.SCHEMA.camelName());
        if (schemaName != null) {
            conn.setSchema(schemaName);
        }
        return conn;
    }

    private Properties readExtraConfigFromUrl(String url) {
        String[] kvs;
        Properties info = new Properties();
        for (String kv : kvs = url.split(JDBC_PROTOCOL_TERMINATOR)) {
            String[] fields = kv.split(PROPERTY_SEPARATOR);
            if (fields.length != 2) continue;
            info.put(fields[0].trim(), fields[1].trim());
        }
        return info;
    }

    static {
        new Driver().register();
    }
}

