/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.internal.ClassLogger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

final class MBeanServerDelegateImpl
extends MBeanServerDelegate
implements DynamicMBean,
MBeanRegistration {
    private static final String dbgTag = "MBeanServerDelegateImpl";
    private static final String[] attributeNames = new String[]{"MBeanServerId", "SpecificationName", "SpecificationVersion", "SpecificationVendor", "ImplementationName", "ImplementationVersion", "ImplementationVendor"};
    private static final MBeanAttributeInfo[] attributeInfos = new MBeanAttributeInfo[]{new MBeanAttributeInfo("MBeanServerId", "java.lang.String", "The MBean server agent identification", true, false, false), new MBeanAttributeInfo("SpecificationName", "java.lang.String", "The full name of the JMX specification implemented by this product.", true, false, false), new MBeanAttributeInfo("SpecificationVersion", "java.lang.String", "The version of the JMX specification implemented by this product.", true, false, false), new MBeanAttributeInfo("SpecificationVendor", "java.lang.String", "The vendor of the JMX specification implemented by this product.", true, false, false), new MBeanAttributeInfo("ImplementationName", "java.lang.String", "The JMX implementation name (the name of this product)", true, false, false), new MBeanAttributeInfo("ImplementationVersion", "java.lang.String", "The JMX implementation version (the version of this product).", true, false, false), new MBeanAttributeInfo("ImplementationVendor", "java.lang.String", "the JMX implementation vendor (the vendor of this product).", true, false, false)};
    private final MBeanInfo delegateInfo;
    private final MBeanServerDelegate delegateImpl;
    private final ClassLogger logger = new ClassLogger("com.sun.jdmk.mbeanserver", "MBeanServerDelegateImpl");

    public MBeanServerDelegateImpl(MBeanServerDelegate delegateImpl) {
        if (delegateImpl == null) {
            delegateImpl = new MBeanServerDelegate();
        }
        this.delegateImpl = delegateImpl;
        this.delegateInfo = new MBeanInfo("javax.management.MBeanServerDelegate", "Represents  the MBean server from the management point of view.", attributeInfos, null, null, delegateImpl.getNotificationInfo());
    }

    @Override
    public final ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (name == null) {
            return new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        return name;
    }

    @Override
    public final void postRegister(Boolean registrationDone) {
    }

    @Override
    public final void preDeregister() throws Exception {
        throw new IllegalArgumentException("The MBeanServerDelegate MBean cannot be unregistered");
    }

    @Override
    public final void postDeregister() {
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            if (attribute == null) {
                throw new AttributeNotFoundException("null");
            }
            if (attribute.equals("MBeanServerId")) {
                return this.delegateImpl.getMBeanServerId();
            }
            if (attribute.equals("SpecificationName")) {
                return this.delegateImpl.getSpecificationName();
            }
            if (attribute.equals("SpecificationVersion")) {
                return this.delegateImpl.getSpecificationVersion();
            }
            if (attribute.equals("SpecificationVendor")) {
                return this.delegateImpl.getSpecificationVendor();
            }
            if (attribute.equals("ImplementationName")) {
                return this.getImplementationName();
            }
            if (attribute.equals("ImplementationVersion")) {
                return this.getImplementationVersion();
            }
            if (attribute.equals("ImplementationVendor")) {
                return this.getImplementationVendor();
            }
            throw new AttributeNotFoundException("null");
        }
        catch (AttributeNotFoundException x) {
            throw x;
        }
        catch (JMRuntimeException j) {
            throw j;
        }
        catch (Exception x) {
            throw new MBeanException(x, "Failed to get " + attribute);
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String attname;
        String string = attname = attribute == null ? null : attribute.getName();
        if (attname == null) {
            IllegalArgumentException r = new IllegalArgumentException("Attribute name cannot be null");
            throw new RuntimeOperationsException(r, "Exception occurred trying to invoke the setter on the MBean");
        }
        Object val = this.getAttribute(attname);
        throw new AttributeNotFoundException(attname + " not accessible");
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        String[] attn = attributes == null ? attributeNames : attributes;
        int len = attn.length;
        AttributeList list = new AttributeList(len);
        boolean dbg = this.logger.finerOn();
        for (int i = 0; i < len; ++i) {
            try {
                Attribute a = new Attribute(attn[i], this.getAttribute(attn[i]));
                list.add(a);
                continue;
            }
            catch (Exception x) {
                if (!dbg) continue;
                this.logger.finer("getAttributes", "Attribute " + attn[i] + " not found: " + x);
                this.logger.finest("getAttributes", x);
            }
        }
        return list;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return new AttributeList(0);
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null) {
            IllegalArgumentException r = new IllegalArgumentException("Operation name  cannot be null");
            throw new RuntimeOperationsException(r, "Exception occurred trying to invoke the operation on the MBean");
        }
        throw new ReflectionException(new NoSuchMethodException(actionName), "The operation with name " + actionName + " could not be found");
    }

    @Override
    public final String getImplementationName() {
        return "Project OpenDMK";
    }

    @Override
    public final String getImplementationVersion() {
        return "opendmk-1.0-b02";
    }

    @Override
    public final String getImplementationVendor() {
        return "Sun Microsystems";
    }

    @Override
    public final void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.delegateImpl.addNotificationListener(listener, filter, handback);
    }

    @Override
    public final void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.delegateImpl.removeNotificationListener(listener);
    }

    @Override
    public final void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.delegateImpl.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public final void sendNotification(Notification notification) {
        this.delegateImpl.sendNotification(notification);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.delegateInfo;
    }
}

