/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.NamedObject;
import com.sun.jdmk.Repository;
import com.sun.jdmk.internal.ClassLogger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.RuntimeOperationsException;

public class RepositorySupport
implements Repository {
    private static final ObjectName _WholeWordQueryObjectName;
    private static int _slen;
    private static int _plen;
    private final Hashtable domainTb;
    private int nbElements = 0;
    private String domain = "DefaultDomain";
    private static final String dbgTag = "Repository";
    private final ClassLogger logger = new ClassLogger("com.sun.jdmk.mbeanserver", "RepositorySupport");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addAllMatching(Hashtable moiTb, Set result, ObjectNamePattern pattern) {
        Hashtable hashtable = moiTb;
        synchronized (hashtable) {
            Enumeration e = moiTb.elements();
            while (e.hasMoreElements()) {
                NamedObject no = (NamedObject)e.nextElement();
                ObjectName on = no.getName();
                if (!pattern.matchKeys(on)) continue;
                result.add(no);
            }
        }
    }

    private final void addNewDomMoi(Object object, String dom, ObjectName name) {
        Hashtable<String, NamedObject> moiTb = new Hashtable<String, NamedObject>();
        this.domainTb.put(dom, moiTb);
        moiTb.put(name.getCanonicalKeyPropertyListString(), new NamedObject(name, object));
        ++this.nbElements;
    }

    public static boolean wildmatch(char[] str, char[] pat) {
        int strlen = str.length;
        int patlen = pat.length;
        int pati = 0;
        int stri = 0;
        int starpati = -1;
        int starstri = -1;
        block4: while (true) {
            if (pati < patlen) {
                char patc = pat[pati];
                switch (patc) {
                    case '?': {
                        if (stri == strlen) break;
                        ++stri;
                        ++pati;
                        continue block4;
                    }
                    case '*': {
                        starpati = ++pati;
                        starstri = stri;
                        continue block4;
                    }
                    default: {
                        if (stri < strlen && str[stri] == patc) {
                            ++stri;
                            ++pati;
                            continue block4;
                        } else {
                            break;
                        }
                    }
                }
            } else if (stri == strlen) {
                return true;
            }
            if (starpati < 0 || starstri == strlen) {
                return false;
            }
            pati = starpati;
            stri = ++starstri;
        }
    }

    private NamedObject retrieveNamedObject(ObjectName name) {
        Object tmp_object;
        if (name.isPattern()) {
            return null;
        }
        String dom = name.getDomain().intern();
        if (dom.length() == 0) {
            dom = this.domain;
        }
        if ((tmp_object = this.domainTb.get(dom)) == null) {
            return null;
        }
        Hashtable moiTb = (Hashtable)tmp_object;
        Object o = moiTb.get(name.getCanonicalKeyPropertyListString());
        if (o != null) {
            return (NamedObject)o;
        }
        return null;
    }

    public RepositorySupport() {
        this.domainTb = new Hashtable(5);
        this.domainTb.put(this.domain.intern(), new Hashtable());
    }

    @Override
    public void setConfigParameters(ArrayList configParameters) {
    }

    @Override
    public boolean isFiltering() {
        return false;
    }

    @Override
    public void addMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException {
        String dom;
        boolean to_default_domain;
        if (this.logger.traceOn()) {
            this.logger.trace("addMBean", "name=" + name);
        }
        boolean bl = to_default_domain = (dom = name.getDomain().intern()).length() == 0 || dom == this.domain;
        if (to_default_domain) {
            dom = this.domain;
        }
        if (name.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Repository: cannot add mbean for pattern name " + name.toString()));
        }
        if (!to_default_domain && dom.equals("JMImplementation") && this.domainTb.containsKey("JMImplementation")) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Repository: domain name cannot be JMImplementation"));
        }
        Hashtable moiTb = (Hashtable)this.domainTb.get(dom);
        if (moiTb == null) {
            this.addNewDomMoi(object, dom, name);
            return;
        }
        String cstr = name.getCanonicalKeyPropertyListString();
        Object elmt = moiTb.get(cstr);
        if (elmt != null) {
            throw new InstanceAlreadyExistsException(name.toString());
        }
        ++this.nbElements;
        moiTb.put(cstr, new NamedObject(name, object));
    }

    @Override
    public boolean contains(ObjectName name) {
        if (this.logger.traceOn()) {
            this.logger.trace("contains", "name=" + name);
        }
        return this.retrieveNamedObject(name) != null;
    }

    @Override
    public Object retrieve(ObjectName name) {
        NamedObject no;
        if (this.logger.traceOn()) {
            this.logger.trace("retrieve", "name=" + name);
        }
        if ((no = this.retrieveNamedObject(name)) == null) {
            return null;
        }
        return no.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set query(ObjectName pattern, QueryExp query) {
        ObjectNamePattern on_pattern = null;
        HashSet<NamedObject> result = new HashSet<NamedObject>();
        ObjectName name = null;
        name = pattern == null || pattern.getCanonicalName().length() == 0 || pattern.equals(_WholeWordQueryObjectName) ? _WholeWordQueryObjectName : pattern;
        if (!name.isPattern()) {
            try {
                NamedObject no = this.retrieveNamedObject(name);
                if (no != null) {
                    result.add(no);
                }
            }
            catch (RuntimeOperationsException e) {
                // empty catch block
            }
            return result;
        }
        if (name == _WholeWordQueryObjectName) {
            Hashtable e = this.domainTb;
            synchronized (e) {
                Enumeration e2 = this.domainTb.elements();
                while (e2.hasMoreElements()) {
                    Hashtable moiTb = (Hashtable)e2.nextElement();
                    result.addAll(moiTb.values());
                }
            }
            return result;
        }
        String canonical_key_property_list_string = name.getCanonicalKeyPropertyListString();
        if (name.getDomain().length() == 0) {
            Hashtable moiTb = (Hashtable)this.domainTb.get(this.domain);
            if (canonical_key_property_list_string.length() == 0) {
                result.addAll(moiTb.values());
            } else {
                if (on_pattern == null) {
                    on_pattern = new ObjectNamePattern(name);
                }
                this.addAllMatching(moiTb, result, on_pattern);
            }
            return result;
        }
        Hashtable hashtable = this.domainTb;
        synchronized (hashtable) {
            char[] dom2Match = name.getDomain().toCharArray();
            Enumeration enumi = this.domainTb.keys();
            while (enumi.hasMoreElements()) {
                String nextDomain = (String)enumi.nextElement();
                char[] theDom = nextDomain.toCharArray();
                if (!RepositorySupport.wildmatch(theDom, dom2Match)) continue;
                Hashtable moiTb = (Hashtable)this.domainTb.get(nextDomain);
                if (canonical_key_property_list_string.length() == 0) {
                    result.addAll(moiTb.values());
                    continue;
                }
                if (on_pattern == null) {
                    on_pattern = new ObjectNamePattern(name);
                }
                this.addAllMatching(moiTb, result, on_pattern);
            }
        }
        return result;
    }

    @Override
    public void remove(ObjectName name) throws InstanceNotFoundException {
        Object tmp_object;
        String dom;
        if (this.logger.traceOn()) {
            this.logger.trace("remove", "name=" + name);
        }
        if ((dom = name.getDomain().intern()).length() == 0) {
            dom = this.domain;
        }
        if ((tmp_object = this.domainTb.get(dom)) == null) {
            throw new InstanceNotFoundException(name.toString());
        }
        Hashtable moiTb = (Hashtable)tmp_object;
        if (moiTb.remove(name.getCanonicalKeyPropertyListString()) == null) {
            throw new InstanceNotFoundException(name.toString());
        }
        --this.nbElements;
        if (moiTb.isEmpty()) {
            this.domainTb.remove(dom);
            if (dom == this.domain) {
                this.domainTb.put(this.domain, new Hashtable());
            }
        }
    }

    @Override
    public Integer getCount() {
        return new Integer(this.nbElements);
    }

    @Override
    public String getDefaultDomain() {
        return this.domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultDomain(String domain) {
        Hashtable hashtable = this.domainTb;
        synchronized (hashtable) {
            if (domain != null && !this.domain.equals(domain)) {
                this.domain = domain.intern();
                if (this.domainTb.get(this.domain) == null) {
                    this.domainTb.put(domain, new Hashtable());
                }
            }
        }
    }

    static {
        try {
            _WholeWordQueryObjectName = new ObjectName("*:*");
        }
        catch (MalformedObjectNameException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
    }

    private static final class ObjectNamePattern {
        private final char[] domain;
        private final String[] keys;
        private final String[] values;
        private final String properties;
        private final boolean isPropertyPattern;
        public final ObjectName pattern;

        public ObjectNamePattern(ObjectName pattern) {
            this(pattern.isPattern(), pattern.getDomain(), pattern.isPropertyPattern(), pattern.getCanonicalKeyPropertyListString(), pattern.getKeyPropertyList(), pattern);
        }

        ObjectNamePattern(boolean domainPattern, String domain, boolean propertyPattern, String canonicalProps, Hashtable keyPropertyList, ObjectName pattern) {
            int len = keyPropertyList == null ? 0 : keyPropertyList.size();
            Enumeration e = keyPropertyList == null ? null : keyPropertyList.keys();
            this.domain = domain == null ? null : domain.toCharArray();
            this.keys = new String[len];
            this.values = new String[len];
            for (int i = 0; i < len; ++i) {
                String k;
                this.keys[i] = k = (String)e.nextElement();
                this.values[i] = (String)keyPropertyList.get(k);
            }
            this.properties = canonicalProps;
            this.isPropertyPattern = propertyPattern;
            this.pattern = pattern;
        }

        public boolean matchKeys(ObjectName name) {
            if (this.isPropertyPattern) {
                for (int i = this.keys.length - 1; i >= 0; --i) {
                    String v = name.getKeyProperty(this.keys[i]);
                    if (v == null) {
                        return false;
                    }
                    if (v.equals(this.values[i])) continue;
                    return false;
                }
                return true;
            }
            if (this.keys.length != name.getKeyPropertyList().size()) {
                return false;
            }
            String p1 = name.getCanonicalKeyPropertyListString();
            String p2 = this.properties;
            return p1.equals(p2);
        }
    }
}

