/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.MBeanServerForwarder;
import com.sun.jdmk.comm.ClientHandler;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServerMBean;
import com.sun.jdmk.internal.ClassLogger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.AttributeChangeNotification;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public abstract class CommunicatorServer
implements Runnable,
MBeanRegistration,
NotificationBroadcaster,
CommunicatorServerMBean {
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;
    public static final int STOPPING = 2;
    public static final int STARTING = 3;
    public static final int RMI_TYPE = 1;
    public static final int HTTP_TYPE = 2;
    public static final int HTML_TYPE = 3;
    public static final int SNMP_TYPE = 4;
    public static final int HTTPS_TYPE = 5;
    volatile transient int state = 1;
    ObjectName objectName;
    MBeanServer topMBS;
    MBeanServer bottomMBS;
    transient String dbgTag = null;
    int maxActiveClientCount = 1;
    transient int servedClientCount = 0;
    String host = null;
    int port = -1;
    private transient Object stateLock = new Object();
    private transient Vector clientHandlerVector = new Vector();
    private transient Thread fatherThread = Thread.currentThread();
    private transient Thread mainThread = null;
    private volatile boolean stopRequested = false;
    private boolean interrupted = false;
    private transient long notifCount = 0L;
    private transient NotificationBroadcasterSupport notifBroadcaster = new NotificationBroadcasterSupport();
    private transient MBeanNotificationInfo[] notifInfos = null;
    transient ClassLogger logger;
    int infoType;

    public CommunicatorServer(int connectorType) throws IllegalArgumentException {
        switch (connectorType) {
            case 1: {
                this.infoType = 1;
                break;
            }
            case 2: {
                this.infoType = 2;
                break;
            }
            case 3: {
                this.infoType = 3;
                break;
            }
            case 4: {
                this.infoType = 4;
                break;
            }
            case 5: {
                this.infoType = 5;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid connector Type");
            }
        }
        this.dbgTag = this.makeDebugTag();
        this.logger = this.makeLogger(this.dbgTag);
    }

    ClassLogger makeLogger(String dbgTag) throws IllegalArgumentException {
        switch (this.infoType) {
            case 1: {
                return new ClassLogger("com.sun.jdmk.comm.legacy.connector.rmi", dbgTag);
            }
            case 2: {
                return new ClassLogger("com.sun.jdmk.comm.legacy.connector.http", dbgTag);
            }
            case 3: {
                return new ClassLogger("com.sun.jdmk.html.adaptor", dbgTag);
            }
            case 4: {
                return new ClassLogger("com.sun.jdmk.snmp.adaptor", dbgTag);
            }
            case 5: {
                return new ClassLogger("com.sun.jdmk.comm.legacy.connector.https", dbgTag);
            }
        }
        throw new IllegalArgumentException("Invalid connector Type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        boolean start;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                this.waitState(1, 60000L);
            }
            boolean bl = start = this.state == 1;
            if (start) {
                this.changeState(3);
                this.stopRequested = false;
                this.interrupted = false;
            }
        }
        if (!start) {
            if (this.logger.finerOn()) {
                this.logger.finer("start", "Connector is not OFFLINE");
            }
            return;
        }
        if (this.logger.finerOn()) {
            this.logger.finer("start", "--> Start connector ");
        }
        this.mainThread = new Thread((Runnable)this, this.makeThreadName());
        if (Thread.currentThread().getPriority() < 10) {
            this.mainThread.setPriority(Thread.currentThread().getPriority() + 1);
        }
        this.mainThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 1 || this.state == 2) {
                if (this.logger.finerOn()) {
                    this.logger.finer("stop", "Connector is not ONLINE");
                }
                return;
            }
            this.changeState(2);
            if (this.logger.finerOn()) {
                this.logger.finer("stop", "Interrupt main thread");
            }
            this.stopRequested = true;
            if (!this.interrupted) {
                this.interrupted = true;
                this.mainThread.interrupt();
            }
        }
        if (this.logger.finerOn()) {
            this.logger.finer("stop", "terminateAllClient");
        }
        this.terminateAllClient();
        if (this.state == 3) {
            this.changeState(1);
        }
    }

    @Override
    public boolean isActive() {
        return this.state == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean waitState(int wantedState, long timeout) {
        if (this.logger.finerOn()) {
            this.logger.finer("waitState", wantedState + "(0on,1off,2st) TO=" + timeout + " ; current state = " + this.getStateString());
        }
        long endTime = 0L;
        if (timeout > 0L) {
            endTime = System.currentTimeMillis() + timeout;
        }
        Object object = this.stateLock;
        synchronized (object) {
            while (this.state != wantedState) {
                if (timeout < 0L) {
                    if (!this.logger.finerOn()) return false;
                    this.logger.finer("waitState", "timeout < 0, return without wait");
                    return false;
                }
                try {
                    if (timeout > 0L) {
                        long toWait = endTime - System.currentTimeMillis();
                        if (toWait <= 0L) {
                            if (!this.logger.finerOn()) return false;
                            this.logger.finer("waitState", "timed out");
                            return false;
                        }
                        this.stateLock.wait(toWait);
                        continue;
                    }
                    this.stateLock.wait();
                }
                catch (InterruptedException e) {
                    if (this.logger.finerOn()) {
                        this.logger.finer("waitState", "wait interrupted");
                    }
                    if (this.state != wantedState) return false;
                    return true;
                }
            }
            if (!this.logger.finerOn()) return true;
            this.logger.finer("waitState", "returning in desired state");
            return true;
        }
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public String getStateString() {
        return CommunicatorServer.getStringForState(this.state);
    }

    @Override
    public String getHost() {
        try {
            this.host = System.getProperty("jdmk.hostname");
            if (this.host == null) {
                this.host = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (Exception e) {
            this.host = "Unknown host";
        }
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPort(int port) throws IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 0 || this.state == 3) {
                throw new IllegalStateException("Stop server before carrying out this operation");
            }
            this.port = port;
            this.dbgTag = this.makeDebugTag();
        }
    }

    @Override
    public abstract String getProtocol();

    int getServedClientCount() {
        return this.servedClientCount;
    }

    int getActiveClientCount() {
        int result = this.clientHandlerVector.size();
        return result;
    }

    int getMaxActiveClientCount() {
        return this.maxActiveClientCount;
    }

    void setMaxActiveClientCount(int c) throws IllegalStateException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException("Stop server before carrying out this operation");
        }
        this.maxActiveClientCount = c;
    }

    void notifyClientHandlerCreated(ClientHandler h) {
        this.clientHandlerVector.addElement(h);
    }

    synchronized void notifyClientHandlerDeleted(ClientHandler h) {
        this.clientHandlerVector.removeElement(h);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block52: {
            int i = 0;
            boolean success = false;
            try {
                while (i < 50 && !success) {
                    try {
                        this.doBind();
                        success = true;
                    }
                    catch (CommunicationException ce) {
                        ++i;
                        Thread.sleep(100L);
                    }
                }
                if (!success) {
                    this.doBind();
                }
            }
            catch (Exception x) {
                if (this.logger.finestOn()) {
                    this.logger.finest("run", "Unexpected exception = " + x);
                }
                this.changeState(1);
                if (this.logger.finerOn()) {
                    this.logger.finer("run", "State is OFFLINE");
                }
                this.doError(x);
                return;
            }
            ThreadDeath threadDeath = null;
            try {
                this.changeState(0);
                if (this.logger.finerOn()) {
                    this.logger.finer("run", "State is ONLINE");
                }
                while (!this.stopRequested) {
                    ++this.servedClientCount;
                    this.doReceive();
                    this.waitIfTooManyClients();
                    this.doProcess();
                }
                if (this.logger.finerOn()) {
                    this.logger.finer("run", "Stop has been requested");
                }
            }
            catch (InterruptedException x) {
                if (this.logger.finerOn()) {
                    this.logger.finer("run", "Interrupt caught");
                }
                this.changeState(2);
            }
            catch (Exception x) {
                if (this.logger.finestOn()) {
                    this.logger.finest("run", "Unexpected exception = " + x);
                }
                this.changeState(2);
            }
            catch (ThreadDeath x) {
                if (this.logger.finestOn()) {
                    this.logger.finest("run", "ThreadDeath caught");
                }
                threadDeath = x;
                this.changeState(2);
            }
            finally {
                Object x = this.stateLock;
                synchronized (x) {
                    this.interrupted = true;
                    Thread.currentThread();
                    Thread.interrupted();
                }
                try {
                    this.doUnbind();
                    this.waitClientTermination();
                    this.changeState(1);
                    if (this.logger.finerOn()) {
                        this.logger.finer("run", "State is OFFLINE");
                    }
                }
                catch (Exception x2) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("run", "Unexpected exception = " + x2);
                    }
                    this.changeState(1);
                }
                if (threadDeath == null) break block52;
                throw threadDeath;
            }
        }
    }

    protected abstract void doError(Exception var1) throws CommunicationException;

    protected abstract void doBind() throws CommunicationException, InterruptedException;

    protected abstract void doReceive() throws CommunicationException, InterruptedException;

    protected abstract void doProcess() throws CommunicationException, InterruptedException;

    protected abstract void doUnbind() throws CommunicationException, InterruptedException;

    public synchronized MBeanServer getMBeanServer() {
        return this.topMBS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMBeanServer(MBeanServer newMBS) throws IllegalArgumentException, IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 0 || this.state == 3) {
                throw new IllegalStateException("Stop server before carrying out this operation");
            }
        }
        String error = "MBeanServer argument must be MBean server where this server is registered, or an MBeanServerForwarder leading to that server";
        Vector<MBeanServer> seenMBS = new Vector<MBeanServer>();
        MBeanServer mbs = newMBS;
        while (mbs != this.bottomMBS) {
            if (!(mbs instanceof MBeanServerForwarder)) {
                throw new IllegalArgumentException("MBeanServer argument must be MBean server where this server is registered, or an MBeanServerForwarder leading to that server");
            }
            if (seenMBS.contains(mbs)) {
                throw new IllegalArgumentException("MBeanServerForwarder loop");
            }
            seenMBS.addElement(mbs);
            mbs = ((MBeanServerForwarder)mbs).getMBeanServer();
        }
        this.topMBS = newMBS;
    }

    ObjectName getObjectName() {
        return this.objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeState(int newState) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == newState) {
                return;
            }
            int oldState = this.state;
            this.state = newState;
            this.stateLock.notifyAll();
            this.sendStateChangeNotification(oldState, newState);
        }
    }

    String makeDebugTag() {
        return "CommunicatorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }

    String makeThreadName() {
        String result = this.objectName == null ? "CommunicatorServer" : this.objectName.toString();
        return result;
    }

    private synchronized void waitIfTooManyClients() throws InterruptedException {
        while (this.getActiveClientCount() >= this.maxActiveClientCount) {
            if (this.logger.finerOn()) {
                this.logger.finer("waitIfTooManyClients", "Waiting for a client to terminate");
            }
            this.wait();
        }
    }

    private void waitClientTermination() {
        int s = this.clientHandlerVector.size();
        if (this.logger.finerOn() && s >= 1) {
            this.logger.finer("waitClientTermination", "waiting for " + s + " clients to terminate");
        }
        Enumeration e = this.clientHandlerVector.elements();
        while (e.hasMoreElements()) {
            ClientHandler h = (ClientHandler)e.nextElement();
            h.join();
        }
        if (this.logger.finerOn() && s >= 1) {
            this.logger.finer("waitClientTermination", "Ok, let's go...");
        }
    }

    private void terminateAllClient() {
        int s = this.clientHandlerVector.size();
        if (this.logger.finerOn() && s >= 1) {
            this.logger.finer("terminateAllClient", "Interrupting " + s + " clients");
        }
        Enumeration e = this.clientHandlerVector.elements();
        while (e.hasMoreElements()) {
            ClientHandler h = (ClientHandler)e.nextElement();
            h.interrupt();
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.stateLock = new Object();
        this.state = 1;
        this.stopRequested = false;
        this.servedClientCount = 0;
        this.clientHandlerVector = new Vector();
        this.fatherThread = Thread.currentThread();
        this.mainThread = null;
        this.notifCount = 0L;
        this.notifInfos = null;
        this.notifBroadcaster = new NotificationBroadcasterSupport();
        this.dbgTag = this.makeDebugTag();
        this.logger = this.makeLogger(this.dbgTag);
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        if (this.logger.finestOn()) {
            this.logger.finest("addNotificationListener", "Adding listener " + listener + " with filter " + filter + " and handback " + handback);
        }
        this.notifBroadcaster.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (this.logger.finestOn()) {
            this.logger.finest("removeNotificationListener", "Removing listener " + listener);
        }
        this.notifBroadcaster.removeNotificationListener(listener);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.notifInfos == null) {
            this.notifInfos = new MBeanNotificationInfo[1];
            String[] notifTypes = new String[]{"jmx.attribute.change"};
            this.notifInfos[0] = new MBeanNotificationInfo(notifTypes, AttributeChangeNotification.class.getName(), "Sent to notify that the value of the State attribute of this CommunicatorServer instance has changed.");
        }
        return this.notifInfos;
    }

    private void sendStateChangeNotification(int oldState, int newState) {
        String oldStateString = CommunicatorServer.getStringForState(oldState);
        String newStateString = CommunicatorServer.getStringForState(newState);
        String message = new StringBuffer().append(this.dbgTag).append(" The value of attribute State has changed from ").append(oldState).append(" (").append(oldStateString).append(") to ").append(newState).append(" (").append(newStateString).append(").").toString();
        ++this.notifCount;
        AttributeChangeNotification notif = new AttributeChangeNotification(this, this.notifCount, System.currentTimeMillis(), message, "State", "int", new Integer(oldState), new Integer(newState));
        if (this.logger.finestOn()) {
            this.logger.finest("sendStateChangeNotification", "Sending AttributeChangeNotification #" + this.notifCount + " with message: " + message);
        }
        this.notifBroadcaster.sendNotification(notif);
    }

    private static String getStringForState(int s) {
        switch (s) {
            case 0: {
                return "ONLINE";
            }
            case 3: {
                return "STARTING";
            }
            case 1: {
                return "OFFLINE";
            }
            case 2: {
                return "STOPPING";
            }
        }
        return "UNDEFINED";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.objectName = name;
        CommunicatorServer communicatorServer = this;
        synchronized (communicatorServer) {
            if (this.bottomMBS != null) {
                throw new IllegalArgumentException("connector already registered in an MBean server");
            }
            this.topMBS = this.bottomMBS = server;
        }
        this.dbgTag = this.makeDebugTag();
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            CommunicatorServer communicatorServer = this;
            synchronized (communicatorServer) {
                this.bottomMBS = null;
                this.topMBS = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preDeregister() throws Exception {
        CommunicatorServer communicatorServer = this;
        synchronized (communicatorServer) {
            this.bottomMBS = null;
            this.topMBS = null;
        }
        this.objectName = null;
        if (this.state == 0 || this.state == 3) {
            this.stop();
        }
    }

    @Override
    public void postDeregister() {
    }
}

