/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServer;
import com.sun.jdmk.comm.HtmlParser;
import com.sun.jdmk.comm.HtmlRequestHandler;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.ServiceNotFoundException;

public class HtmlAdaptorServer
extends CommunicatorServer
implements MBeanRegistration,
DynamicMBean {
    private String dclassName = this.getClass().getName();
    private String ddescription = "HtmlAdaptorServer class: Provides a management interface of an agent to Web browser clients.";
    private MBeanAttributeInfo[] dattributes = new MBeanAttributeInfo[12];
    private MBeanConstructorInfo[] dconstructors = new MBeanConstructorInfo[3];
    private MBeanOperationInfo[] doperations = new MBeanOperationInfo[5];
    private MBeanInfo dmbeaninfo = null;
    private InetAddress addrLastClient = null;
    private Vector authInfo = new Vector();
    private ObjectName userParser = null;
    private transient ServerSocket sockListen = null;
    private transient Socket sock = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";

    public HtmlAdaptorServer() {
        this(8082);
    }

    public HtmlAdaptorServer(int port) {
        super(3);
        this.port = port;
        this.maxActiveClientCount = 10;
        this.dbgTag = this.makeDebugTag();
        this.buildInfo();
    }

    public HtmlAdaptorServer(int port, AuthInfo[] authInfoList) {
        this(port);
        if (authInfoList != null) {
            for (int i = 0; i < authInfoList.length; ++i) {
                this.addUserAuthenticationInfo(authInfoList[i]);
            }
        }
    }

    public void setParser(ObjectName parser) throws InstanceNotFoundException, ServiceNotFoundException {
        if (parser == null) {
            this.resetParser();
            return;
        }
        boolean isParser = this.topMBS.isInstanceOf(parser, HtmlParser.class.getName());
        if (!isParser) {
            throw new ServiceNotFoundException("The HtmlParser interface is not implemented by the MBean = " + parser);
        }
        this.userParser = parser;
    }

    public ObjectName getParser() {
        return this.userParser;
    }

    public void resetParser() {
        this.userParser = null;
    }

    public void createParser(String className, String parserName, String loaderName) throws MalformedObjectNameException, ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        Object theParser = null;
        if (loaderName != null && loaderName.length() > 0) {
            ObjectName loaderObN = new ObjectName(loaderName);
            theParser = this.topMBS.instantiate(className, loaderObN);
        } else {
            theParser = this.topMBS.instantiate(className);
        }
        if (!HtmlParser.class.isAssignableFrom(theParser.getClass())) {
            theParser = null;
            throw new MBeanException(new ServiceNotFoundException("The HtmlParser interface is not implemented by the MBbean = " + className));
        }
        ObjectName parserObN = new ObjectName(parserName);
        this.topMBS.registerMBean(theParser, parserObN);
        try {
            this.setParser(parserObN);
        }
        catch (ServiceNotFoundException snfe) {
            if (this.logger.finestOn()) {
                this.logger.finest("setParser", " Service not found. [Exception=" + snfe + "]");
            }
            throw new MBeanException(snfe);
        }
    }

    public String getLastConnectedClient() {
        if (this.addrLastClient == null) {
            return "unknown";
        }
        return this.addrLastClient.getHostAddress();
    }

    @Override
    public String getProtocol() {
        return "html";
    }

    @Override
    public int getServedClientCount() {
        return super.getServedClientCount();
    }

    @Override
    public int getActiveClientCount() {
        return super.getActiveClientCount();
    }

    @Override
    public int getMaxActiveClientCount() {
        return super.getMaxActiveClientCount();
    }

    @Override
    public void setMaxActiveClientCount(int c) throws IllegalStateException {
        super.setMaxActiveClientCount(c);
    }

    public synchronized void addUserAuthenticationInfo(AuthInfo authinfo) {
        if (authinfo != null) {
            String username = authinfo.getLogin();
            Enumeration e = this.authInfo.elements();
            while (e.hasMoreElements()) {
                AuthInfo ai = (AuthInfo)e.nextElement();
                if (!ai.getLogin().equals(username)) continue;
                this.authInfo.removeElement(ai);
                break;
            }
            this.authInfo.addElement(authinfo);
        }
    }

    public synchronized void removeUserAuthenticationInfo(AuthInfo authinfo) {
        if (authinfo != null) {
            String username = authinfo.getLogin();
            Enumeration e = this.authInfo.elements();
            while (e.hasMoreElements()) {
                AuthInfo ai = (AuthInfo)e.nextElement();
                if (!ai.getLogin().equals(username)) continue;
                this.authInfo.removeElement(ai);
                break;
            }
        }
    }

    public boolean isAuthenticationOn() {
        return !this.authInfo.isEmpty();
    }

    @Override
    public void stop() {
        block3: {
            if (this.state == 0 || this.state == 3) {
                super.stop();
                try {
                    Socket s = new Socket(InetAddress.getLocalHost(), this.port);
                    s.close();
                }
                catch (IOException ioe) {
                    if (!this.logger.finestOn()) break block3;
                    this.logger.finest("stop", "I/O exception. [Exception=" + ioe + "]");
                }
            }
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (name == null) {
            name = new ObjectName(server.getDefaultDomain() + ":" + "name=HtmlAdaptorServer");
        }
        return super.preRegister(server, name);
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        super.postRegister(registrationDone);
    }

    @Override
    public void preDeregister() throws Exception {
        super.preDeregister();
    }

    @Override
    public void postDeregister() {
        super.postDeregister();
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.dmbeaninfo;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute == null || attribute.trim().equals("")) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null or empty"), "The getAttribute method of HtmlAdaptorServer was called with a null or empty attribute name string.");
        }
        if (attribute.equals("Active")) {
            return new Boolean(this.isActive());
        }
        if (attribute.equals("ActiveClientCount")) {
            return new Integer(this.getActiveClientCount());
        }
        if (attribute.equals("AuthenticationOn")) {
            return new Boolean(this.isAuthenticationOn());
        }
        if (attribute.equals("Host")) {
            return this.getHost();
        }
        if (attribute.equals("LastConnectedClient")) {
            return this.getLastConnectedClient();
        }
        if (attribute.equals("MaxActiveClientCount")) {
            return new Integer(this.getMaxActiveClientCount());
        }
        if (attribute.equals("Parser")) {
            return this.getParser();
        }
        if (attribute.equals("Port")) {
            return new Integer(this.getPort());
        }
        if (attribute.equals("Protocol")) {
            return this.getProtocol();
        }
        if (attribute.equals("ServedClientCount")) {
            return new Integer(this.getServedClientCount());
        }
        if (attribute.equals("State")) {
            return new Integer(this.getState());
        }
        if (attribute.equals("StateString")) {
            return this.getStateString();
        }
        throw new AttributeNotFoundException(attribute + " is unknown in HtmlAdaptorServer");
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList result = new AttributeList();
        String attribute = null;
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attributes cannot be null"), "Exception occurred trying to invoke the getter on the HtmlAdaptorServer");
        }
        if (attributes.length == 0) {
            return result;
        }
        for (int i = 0; i < attributes.length; ++i) {
            attribute = attributes[i];
            String elmt = attributes[i];
            try {
                Object value = this.getAttribute(elmt);
                result.add(new Attribute(elmt, value));
                continue;
            }
            catch (Exception e) {
                if (!this.logger.finestOn()) continue;
                this.logger.finest("getAttributes", "Unexpected exception [Exception=" + e + "]");
            }
        }
        return result;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null || actionName.trim().equals("")) {
            throw new RuntimeOperationsException(new IllegalArgumentException("String parameter 'actionName' of invoke method of HtmlAdaptorServer cannot be null or empty"), "String parameter 'actionName' of invoke method of HtmlAdaptorServer cannot be null or empty");
        }
        if (actionName.equals("start")) {
            this.start();
            return null;
        }
        if (actionName.equals("stop")) {
            this.stop();
            return null;
        }
        if (actionName.equals("waitState")) {
            try {
                if (params.length != 2 || !(params[0] instanceof Integer) || !(params[1] instanceof Long)) {
                    throw new RuntimeOperationsException(new IllegalArgumentException("invoke waitState: expecting params[0] instanceof Integer and params[1] instanceof Long"), "Wrong content for array Object[] params to invoke waitState method of HtmlAdaptorServer");
                }
                if (signature.length != 2 || !signature[0].equals("int") || !signature[1].equals("long")) {
                    throw new RuntimeOperationsException(new IllegalArgumentException("invoke waitState: expecting signature[0].equals(\"int\") and signature[1].equals(\"long\")"), "Wrong content for array String[] signature to invoke waitState method of HtmlAdaptorServer");
                }
                return new Boolean(this.waitState((Integer)params[0], (Long)params[1]));
            }
            catch (Exception e) {
                throw new MBeanException(e, "invoke waitState: " + e.getClass().getName() + "caught [" + e.getMessage() + "]");
            }
        }
        if (actionName.equals("createParser")) {
            try {
                if (!(params.length == 3 && params[0] instanceof String && params[1] instanceof String && params[2] instanceof String)) {
                    throw new RuntimeOperationsException(new IllegalArgumentException("invoke createParser: expecting params[0] instanceof String and params[1] instanceof String and params[2] instanceof String"), "Wrong content for array Object[] params to invoke createParser method of HtmlAdaptorServer");
                }
                if (!(signature.length == 3 && signature[0].equals("String") && signature[1].equals("String") && signature[2].equals("String"))) {
                    throw new RuntimeOperationsException(new IllegalArgumentException("invoke createParser: expecting signature[0].equals(\"String\") and signature[1].equals(\"String\") and signature[2].equals(\"String\")"), "Wrong content for array String[] signature to invoke createParser method of HtmlAdaptorServer");
                }
                this.createParser((String)params[0], (String)params[1], (String)params[2]);
            }
            catch (Exception e) {
                throw new MBeanException(e, "invoke createParser: " + e.getClass().getName() + "caught [" + e.getMessage() + "]");
            }
            return null;
        }
        if (actionName.equals("resetParser")) {
            this.resetParser();
            return null;
        }
        if (actionName.startsWith("get") && actionName.length() > 3) {
            String attrName = actionName.substring(3);
            try {
                return this.getAttribute(attrName);
            }
            catch (AttributeNotFoundException e) {
                throw new ReflectionException(new NoSuchMethodException(actionName), "The action with name " + actionName + " could not be found in HtmlAdaptorServer");
            }
        }
        if (actionName.startsWith("is") && actionName.length() > 2) {
            String attrName = actionName.substring(2);
            try {
                return this.getAttribute(attrName);
            }
            catch (AttributeNotFoundException e) {
                throw new ReflectionException(new NoSuchMethodException(actionName), "The action with name " + actionName + " could not be found in HtmlAdaptorServer");
            }
        }
        if (actionName.startsWith("set") && actionName.length() > 3) {
            String attrName = actionName.substring(3);
            if (params.length != 1) {
                throw new RuntimeOperationsException(new IllegalArgumentException("invoke " + actionName + ": expecting params.length == 1"), "Array Object[] params to invoke createParser method of HtmlAdaptorServer should be of length 1");
            }
            try {
                this.setAttribute(new Attribute(attrName, params[0]));
            }
            catch (AttributeNotFoundException e) {
                throw new ReflectionException(new NoSuchMethodException(actionName), "The action with name " + actionName + " could not be found in HtmlAdaptorServer");
            }
            catch (InvalidAttributeValueException e) {
                throw new MBeanException(e, "InvalidAttributeValueException thrown when invoking setAttribute for attribute with [name=" + attrName + "] and [value=" + params[0] + "]");
            }
            return null;
        }
        throw new ReflectionException(new NoSuchMethodException(actionName), "The action with name " + actionName + " could not be found in HtmlAdaptorServer");
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("setAttribute: attribute parameter cannot be null"), "Cannot invoke setAttribute method of " + this.dclassName + " with null attribute parameter");
        }
        String name = attribute.getName();
        Object value = attribute.getValue();
        if (name == null || name.trim().equals("")) {
            throw new RuntimeOperationsException(new IllegalArgumentException("setAttribute: name field of attribute parameter cannot be null or empty"), "Cannot invoke setAttribute method of " + this.dclassName + " with null or empty attribute parameter name field");
        }
        if (name.equals("Port")) {
            try {
                if (!Integer.class.isAssignableFrom(value != null ? value.getClass() : Integer.class)) {
                    throw new InvalidAttributeValueException("Cannot set attribute " + name + " to a " + (value != null ? value.getClass().getName() : value) + " object, java.lang.Integer expected");
                }
                this.setPort((Integer)attribute.getValue());
            }
            catch (Exception e) {
                if (this.logger.finestOn()) {
                    this.logger.finest("setAttribute", "setAttribute Port: caught [Exception=" + e + "]");
                }
                throw new MBeanException(e, "setAttribute Port: " + e.getClass().getName() + " caught [" + e.getMessage() + "]");
            }
        } else if (name.equals("MaxActiveClientCount")) {
            try {
                if (!Integer.class.isAssignableFrom(value != null ? value.getClass() : Integer.class)) {
                    throw new InvalidAttributeValueException("Cannot set attribute " + name + " to a " + (value != null ? value.getClass().getName() : value) + " object, java.lang.Integer expected");
                }
                this.setMaxActiveClientCount((Integer)attribute.getValue());
            }
            catch (Exception e) {
                if (this.logger.finestOn()) {
                    this.logger.finest("setAttribute", "setAttribute MaxActiveClientCount: caught [Exception=" + e + "]");
                }
                throw new MBeanException(e, "setAttribute MaxActiveClientCount: " + e.getClass().getName() + " caught [" + e.getMessage() + "]");
            }
        } else if (name.equals("Parser")) {
            try {
                if (!ObjectName.class.isAssignableFrom(value != null ? value.getClass() : ObjectName.class)) {
                    throw new InvalidAttributeValueException("Cannot set attribute " + name + " to a " + (value != null ? value.getClass().getName() : value) + " object, javax.management.ObjectName expected");
                }
                this.setParser((ObjectName)attribute.getValue());
            }
            catch (Exception e) {
                if (this.logger.finestOn()) {
                    this.logger.finest("setAttribute", "setAttribute Parser: caught [Exception=" + e + "]");
                }
                throw new MBeanException(e, "setAttribute Parser: " + e.getClass().getName() + " caught [" + e.getMessage() + "]");
            }
        } else {
            throw new AttributeNotFoundException("Attribute " + name + " is unknown in HtmlAdaptorServer, or is not writable");
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeList  cannot be null"), "Exception occurred trying to invoke the setter on the MBean");
        }
        AttributeList result = new AttributeList();
        if (attributes.isEmpty()) {
            return result;
        }
        for (Attribute attr : attributes) {
            String id = attr.getName();
            Object value = attr.getValue();
            try {
                Object newValue = null;
                this.setAttribute(attr);
                result.add(new Attribute(id, this.getAttribute(id)));
            }
            catch (Exception e) {
                if (!this.logger.finestOn()) continue;
                this.logger.finest("setAttributes", "Exception when setting " + id + ". [Exception=" + e + "]");
            }
        }
        return result;
    }

    @Override
    protected void doError(Exception e) throws CommunicationException {
    }

    @Override
    protected void doBind() throws CommunicationException, InterruptedException {
        if (this.logger.finerOn()) {
            this.logger.finer("doBind", "Bind the socket listener to [Port=" + this.port + ", MaxActiveClientCount=" + this.maxActiveClientCount + "]");
        }
        try {
            this.sockListen = new ServerSocket(this.port, 2 * this.maxActiveClientCount);
            if (this.logger.finerOn()) {
                this.logger.finer("doBind", "Bound to [Address=" + this.sockListen.getInetAddress() + ", Port=" + this.sockListen.getLocalPort() + "]");
            }
        }
        catch (SocketException e) {
            if (e.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(e.toString());
            }
            throw new CommunicationException(e);
        }
        catch (InterruptedIOException e) {
            throw new InterruptedException(e.toString());
        }
        catch (IOException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    protected void doUnbind() throws CommunicationException, InterruptedException {
        if (this.logger.finerOn()) {
            this.logger.finer("doUnbind", "Finally close the socket [Listener=" + this.sockListen + "]");
        }
        try {
            this.sockListen.close();
        }
        catch (SocketException e) {
            if (e.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(e.toString());
            }
            throw new CommunicationException(e);
        }
        catch (InterruptedIOException e) {
            throw new InterruptedException(e.toString());
        }
        catch (IOException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    protected void doReceive() throws CommunicationException, InterruptedException {
        if (this.logger.finerOn()) {
            this.logger.finer("doReceive", "Listens for a connection on [Listener=" + this.sockListen + "]");
        }
        try {
            this.sock = this.sockListen.accept();
            if (this.logger.finerOn()) {
                this.logger.finer("doReceive", "Accepted a connection on [Socket=" + this.sock + "]");
            }
        }
        catch (SocketException e) {
            if (e.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(e.toString());
            }
            throw new CommunicationException(e);
        }
        catch (InterruptedIOException e) {
            throw new InterruptedException(e.toString());
        }
        catch (IOException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    protected void doProcess() throws CommunicationException, InterruptedException {
        if (this.logger.finerOn()) {
            this.logger.finer("doProcess", "Process a request received on [Socket=" + this.sock + "]");
        }
        this.addrLastClient = this.sock.getInetAddress();
        HtmlRequestHandler server = new HtmlRequestHandler(this.sock, this, this.topMBS, this.objectName, this.servedClientCount);
        this.sock = null;
    }

    synchronized boolean checkChallengeResponse(String response) {
        if (this.logger.finerOn()) {
            this.logger.finer("checkChallengeResponse", " Validate  request");
        }
        if (response == null) {
            return false;
        }
        String username = null;
        String password = null;
        StringTokenizer parser = new StringTokenizer(response, ":");
        try {
            if (parser.hasMoreTokens()) {
                username = parser.nextToken();
                password = parser.nextToken();
            }
        }
        catch (NoSuchElementException nsee) {
            if (this.logger.finestOn()) {
                this.logger.finest("checkChallengeResponse", "No such element. [Exception=" + nsee + "]");
            }
            return false;
        }
        if (this.logger.finerOn()) {
            this.logger.finer("checkChallengeResponse", " Validate the request for [Login=" + username + ", Password=" + password + "]");
        }
        Enumeration e = this.authInfo.elements();
        while (e.hasMoreElements()) {
            AuthInfo ai = (AuthInfo)e.nextElement();
            if (!ai.getLogin().equals(username) || !ai.getPassword().equals(password)) continue;
            return true;
        }
        return false;
    }

    private void buildInfo() {
        this.dattributes[0] = new MBeanAttributeInfo("Active", "boolean", "Active: True if the HtmlAdaptorServer is in the ONLINE state.", true, false, true);
        this.dattributes[1] = new MBeanAttributeInfo("ActiveClientCount", "int", "ActiveClientCount: The number of clients being processed currently by the HtmlAdaptorServer.", true, false, false);
        this.dattributes[2] = new MBeanAttributeInfo("AuthenticationOn", "boolean", "AuthenticationOn: True if the HtmlAdaptorServer requests authentication.", true, false, true);
        this.dattributes[3] = new MBeanAttributeInfo("Host", "java.lang.String", "Host: Hostname.", true, false, false);
        this.dattributes[4] = new MBeanAttributeInfo("LastConnectedClient", "java.lang.String", "LastConnectedClient: The IP address of the last connected client.", true, false, false);
        this.dattributes[5] = new MBeanAttributeInfo("MaxActiveClientCount", "int", "MaxActiveClientCount: The maximum number of clients the HtmlAdaptorServer can process concurrently.", true, true, false);
        this.dattributes[6] = new MBeanAttributeInfo("Parser", "javax.management.ObjectName", "Parser: ObjectName of the MBean used to customized HTML pages generated by the HtmlAdaptorServer.", true, true, false);
        this.dattributes[7] = new MBeanAttributeInfo("Port", "int", "Port: Port number used.", true, true, false);
        this.dattributes[8] = new MBeanAttributeInfo("Protocol", "java.lang.String", "Protocol: html.", true, false, false);
        this.dattributes[9] = new MBeanAttributeInfo("ServedClientCount", "int", "ServedClientCount: The number of clients that have been processed by the HtmlAdaptorServer since its creation.", true, false, false);
        this.dattributes[10] = new MBeanAttributeInfo("State", "int", "State: State of the HtmlAdaptorServer.", true, false, false);
        this.dattributes[11] = new MBeanAttributeInfo("StateString", "java.lang.String", "StateString: State of the HtmlAdaptorServer.", true, false, false);
        Constructor<?>[] ctor = this.getClass().getConstructors();
        for (int i = 0; i < ctor.length; ++i) {
            if (ctor[i].getParameterTypes().length == 0) {
                this.dconstructors[0] = new MBeanConstructorInfo("Instantiate HtmlAdaptorServer with default port number equal to 8082.", ctor[i]);
                continue;
            }
            if (ctor[i].getParameterTypes().length == 1) {
                this.dconstructors[1] = new MBeanConstructorInfo("Instantiate HtmlAdaptorServer with the specified port number.", ctor[i]);
                continue;
            }
            this.dconstructors[2] = new MBeanConstructorInfo("Instantiate HtmlAdaptorServer with the specified port number and user authentication information list.", ctor[i]);
        }
        this.doperations[0] = new MBeanOperationInfo("start", "start: Start the HtmlAdaptorServer.", null, "void", 1);
        this.doperations[1] = new MBeanOperationInfo("stop", "stop: Stop the HtmlAdaptorServer.", null, "void", 1);
        MBeanParameterInfo[] params1 = new MBeanParameterInfo[]{new MBeanParameterInfo("state", "int", "state: The state to wait for."), new MBeanParameterInfo("timeout", "long", "timeout: The maximum time to wait in milliseconds.")};
        this.doperations[2] = new MBeanOperationInfo("waitState", "waitState: Waits to be notified of a specific state change in the HtmlAdaptorServer.", params1, "boolean", 1);
        MBeanParameterInfo[] params2 = new MBeanParameterInfo[]{new MBeanParameterInfo("className", "java.lang.String", "class name: The name of the class used to parse HTML page."), new MBeanParameterInfo("objectName", "java.lang.String", "object name: The name of the MBean to register in the MBeanServer."), new MBeanParameterInfo("classLoaderName", "java.lang.String", "class loader name: The ObjectName of the MBean to use as class loader, if it is empty, the default agent class loader will be used by the MBeanServer.")};
        this.doperations[3] = new MBeanOperationInfo("createParser", "createParser: Create, Register to the MBeanServer and set Parser attribute with the HTML parser MBean", params2, "void", 1);
        this.doperations[4] = new MBeanOperationInfo("resetParser", "resetParser: Remove the customization from HtmlAdaptorServer by reseting the Parser property to null.", null, "void", 1);
        this.dmbeaninfo = new MBeanInfo(this.dclassName, this.ddescription, this.dattributes, this.dconstructors, this.doperations, new MBeanNotificationInfo[0]);
    }

    @Override
    String makeDebugTag() {
        return "HtmlAdaptorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }
}

