/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.Introspector;
import com.sun.jdmk.comm.HtmlPage;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

class HtmlAdminPage
extends HtmlPage {
    final int inputfieldSize = 45;
    private MBeanConstructorInfo[] ctors = null;

    public HtmlAdminPage(MBeanServer f, boolean r, boolean w) {
        super(f, r, w);
    }

    @Override
    public void buildPage(String req) {
        if (this.logger.finerOn()) {
            this.logger.finer("buildPage", "Handle the request [" + req + "]");
        }
        if (req.startsWith("/Main")) {
            this.buildCmfPage();
        } else if (req.startsWith("/Objects")) {
            StringBuffer errBuf = new StringBuffer();
            StringBuffer htmlBuf = new StringBuffer();
            String domainName = null;
            String className = null;
            String cloaderName = null;
            Object moName = null;
            String keysName = null;
            String action = null;
            String params = "";
            errBuf.append("<HR><P>\r\n<FONT SIZE=+3 COLOR=red><B>Administration Request Failed</B></FONT><P><HR><P>");
            req = req.substring("/Objects".length());
            if (this.logger.finerOn()) {
                this.logger.finer("buildPage", "The admin request [" + req + "]");
            }
            if (!req.startsWith("/?") && !req.startsWith("%%")) {
                if (this.logger.finerOn()) {
                    this.logger.finer("buildPage", "Invalid command = /Admin/Objects");
                }
                this.buildError("Request badly formatted :<BR>" + req, "400 Bad Request");
                return;
            }
            boolean isreq2 = req.startsWith("%%");
            if (this.logger.finerOn()) {
                this.logger.finer("buildPage", "Admin request [type=" + (isreq2 ? "2" : "1") + "]");
            }
            if ((req = req.substring("/?".length())).indexOf(63, 0) != -1) {
                params = req.substring(req.indexOf(63, 0), req.length());
            }
            if (this.logger.finerOn()) {
                this.logger.finer("buildPage", "The request parameter list [" + params + "]");
            }
            boolean ok = false;
            while (!ok) {
                int id = req.indexOf(38);
                if (id < 0) {
                    ok = true;
                    id = req.length();
                }
                if (req.startsWith("domainName=")) {
                    if (!req.startsWith("&") && id != 11) {
                        domainName = req.substring(11, id);
                    }
                } else if (req.startsWith("cloaderName=")) {
                    if (!req.startsWith("&") && id != 12) {
                        cloaderName = req.substring(12, id);
                    }
                } else if (req.startsWith("className=")) {
                    if (!req.startsWith("&") && id != 10) {
                        className = req.substring(10, id);
                    }
                } else if (req.startsWith("action=")) {
                    if (!req.startsWith("&") && id != 7) {
                        action = req.substring(7, id);
                    }
                } else if (req.startsWith("keysName=") && !req.startsWith("&") && id != 9) {
                    keysName = req.substring(9, id);
                }
                if (ok) continue;
                req = req.substring(id + 1);
            }
            ok = true;
            if (domainName == null) {
                ok = false;
                errBuf.append("Domain Name cannot be null.<p>");
            } else {
                domainName = this.decodeUrl(domainName);
                domainName = domainName.trim();
            }
            if (action == null) {
                ok = false;
                errBuf.append("Action cannot be null.<p>");
            } else {
                action = this.decodeUrl(action);
                action = action.trim();
            }
            if (action != null && !action.equals("Unregister")) {
                if (className == null) {
                    ok = false;
                    errBuf.append("Class cannot be null.<p>");
                } else {
                    className = this.decodeUrl(className);
                    className = className.trim();
                }
            }
            if (cloaderName != null) {
                cloaderName = this.decodeUrl(cloaderName);
                cloaderName = cloaderName.trim();
            }
            if (keysName == null) {
                ok = false;
                errBuf.append("Keys cannot be null.<p>");
            } else {
                keysName = this.decodeUrl(keysName);
                keysName = keysName.trim();
            }
            ArrayList<String> valueList = new ArrayList<String>();
            ArrayList<String> typeList = new ArrayList<String>();
            if (ok && action.equals("Create") && isreq2 && params.indexOf(63, 0) != -1 && params.indexOf(61, 1) != -1) {
                String reqStr = params.substring(params.indexOf(63, 0) + 1);
                boolean done = false;
                String propReqStr = null;
                while (!done) {
                    int index = reqStr.indexOf(38);
                    if (index < 0) {
                        propReqStr = reqStr;
                        done = true;
                    } else {
                        propReqStr = reqStr.substring(0, index);
                        reqStr = reqStr.substring(index + 1);
                    }
                    index = propReqStr.indexOf(61);
                    if (index < 0) {
                        done = true;
                        ok = false;
                        errBuf.append("Syntax error in request [" + propReqStr + "] " + 400 + " " + "Bad Request");
                        break;
                    }
                    String propStr = propReqStr.substring(0, index);
                    String valueStr = propReqStr.substring(index + 1);
                    String typeStr = null;
                    if (propStr != null && propStr.length() != 0) {
                        while (propStr.startsWith("%")) {
                            propStr = propStr.substring(3);
                        }
                        valueStr = valueStr != null && valueStr.length() != 0 ? this.decodeUrl(valueStr) : "JDMK_NULL_VALUE";
                        if (this.logger.finerOn()) {
                            this.logger.finer("buildPage", "Parsing property name [" + propStr + "]");
                        }
                        if ((index = propStr.indexOf("%2B", 0)) < 0) {
                            index = propStr.indexOf("%2b", 0);
                        }
                        if (index >= 0) {
                            typeStr = propStr.substring(index + 3);
                            propStr = propStr.substring(0, index);
                        } else {
                            typeStr = "String";
                        }
                        if (this.logger.finerOn()) {
                            this.logger.finer("buildPage", "Found the property " + propStr + " [" + "Type=" + typeStr + ", " + " Value=" + valueStr + "]");
                        }
                        if (propStr.equals("action")) continue;
                        typeList.add(typeStr);
                        valueList.add(valueStr);
                        continue;
                    }
                    if (this.logger.finerOn()) {
                        this.logger.finer("buildPage", "Got null value or property");
                    }
                    ok = false;
                    errBuf.append("Syntax error in request [" + propReqStr + "]" + 400 + " " + "Bad Request");
                    break;
                }
                if (this.logger.finerOn()) {
                    this.logger.finer("buildPage", "Found " + valueList.size() + " parameters");
                }
            }
            if (ok) {
                errBuf = null;
                errBuf = this.cmfHttpAction(action, domainName, className, keysName, cloaderName, typeList, valueList, isreq2);
            }
            String nm = domainName + ":";
            if (keysName != null) {
                nm = nm + keysName;
            }
            String safeObjNameStr = this.translateNameToHtmlFormat(nm);
            if (action.equals("Unregister")) {
                if (this.logger.finerOn()) {
                    this.logger.finer("buildPage", "Build the unregister result page");
                }
                if (!isreq2) {
                    this.buildCmfPage(domainName, className, keysName, cloaderName, action, false);
                    this.add2Page("<TABLE WIDTH=100%><TR>");
                    this.add2Page("<TD ALIGN=LEFT><H3><STRONG>Unregister Result:</STRONG></H3></TD>");
                    this.add2Page("</TR></TABLE>");
                } else {
                    this.add2Page(this.buildHead("[Project OpenDMKopendmk-1.0-b02] Agent Administration"));
                    this.add2Page(this.startBody(null));
                }
                if (errBuf == null) {
                    this.htmlPage.append("<HR><P>\r\n<FONT SIZE=+3 COLOR=green><B>Unregister Successful</B></FONT><P><HR><P>The MBean [" + safeObjNameStr + "] was successfully unregistered.");
                } else {
                    this.add2Page(errBuf.toString());
                }
                if (isreq2) {
                    this.add2Page("<P><TABLE WIDTH=100%><TR>");
                    this.add2Page("<TD ALIGN=RIGHT><A HREF=\"/\">Back to Agent View</A></TD>");
                    this.add2Page("</TR></TABLE>");
                }
            } else if (action.equals("Create")) {
                if (this.logger.finerOn()) {
                    this.logger.finer("buildPage", "Build the create result page");
                }
                this.buildCmfPage(domainName, className, keysName, cloaderName, action, false);
                if (isreq2) {
                    this.buildCtorsList(domainName, className, keysName, cloaderName);
                }
                this.add2Page("<TABLE WIDTH=100%><TR>");
                this.add2Page("<TD ALIGN=LEFT><H3><STRONG>Create Result:</STRONG></H3></TD>");
                this.add2Page("</TR></TABLE>");
                if (errBuf == null) {
                    this.htmlPage.append("<HR><P>\r\n<FONT SIZE=+3 COLOR=green><B>Create Successful</B></FONT><P><HR><P>The MBean [" + safeObjNameStr + "] was successfully instantiated and registered.");
                    this.add2Page("<P><TABLE WIDTH=100%><TR>");
                    this.add2Page("<TD ALIGN=RIGHT><A HREF=\"/ViewObjectRes" + this.toUrlName(nm) + "\">Go to " + "MBean View" + "</A></TD>");
                    this.add2Page("</TR></TABLE>");
                } else {
                    this.add2Page(errBuf.toString());
                }
            } else if (action.equals("Constructors")) {
                if (this.logger.finerOn()) {
                    this.logger.finer("buildPage", "Build the constructors result page");
                }
                this.buildCmfPage(domainName, className, keysName, cloaderName, action, false);
                if (errBuf == null) {
                    this.buildCtorsList(domainName, className, keysName, cloaderName);
                }
                this.add2Page("<TABLE WIDTH=100%><TR>");
                this.add2Page("<TD ALIGN=LEFT><H3><STRONG>Constructors Result:</STRONG></H3></TD>");
                this.add2Page("</TR></TABLE>");
                if (errBuf == null) {
                    this.htmlPage.append("<HR><P>\r\n<FONT SIZE=+3 COLOR=green><B>List Constructors Successful</B></FONT><P><HR><P>The list of public constructors was successfully build for the MBean [" + safeObjNameStr + "].");
                } else {
                    this.add2Page(errBuf.toString());
                }
            }
            this.add2Page(this.stopBody());
        } else {
            this.buildError(req, "400 Bad Request");
        }
    }

    private void buildCmfPage() {
        this.buildCmfPage(null, null, null, null, null, true);
    }

    private void buildCmfPage(String domainName, String className, String keysName, String cloaderName, String action, boolean withEndPage) {
        this.add2Page(this.buildHead("[Project OpenDMKopendmk-1.0-b02] Agent Administration"));
        this.add2Page(this.startBody(null));
        this.add2Page("<TABLE WIDTH=100%>");
        this.add2Page("<TR>");
        this.add2Page("<TD ALIGN=left><H2>Agent Administration</H2></TD>");
        this.add2Page("<TD ALIGN=right VALIGN=top>[Project OpenDMKopendmk-1.0-b02]</TD>");
        this.add2Page("</TR></TABLE>");
        this.add2Page("<TABLE WIDTH=100%><TR>");
        this.add2Page("<TD ALIGN=RIGHT><A HREF=\"/\">Back to Agent View</A></TD>");
        this.add2Page("</TR></TABLE>");
        this.add2Page("<P>Specify the object name and java class of the MBean to add, delete or view the constructors of:<BR>");
        this.add2Page("<I>(Optionally provide a class loader name for loading the specified class.)</I><BR>");
        this.add2Page("<FORM ACTION=/Admin/Objects/ METHOD=GET>");
        this.add2Page("<TABLE ALIGN=center BORDER=1 WIDTH=480>");
        this.add2Page("<TR>");
        this.add2Page("<TD>");
        this.add2Page("<TABLE>");
        if (domainName == null) {
            domainName = this.mbs.getDefaultDomain();
        }
        this.addRow("Domain", "domainName", this.translateNameToHtmlFormat(domainName));
        this.addRow("Keys", "keysName", this.translateNameToHtmlFormat(keysName));
        this.add2Page("</TABLE>");
        this.add2Page("</TD>");
        this.add2Page("</TR>");
        this.add2Page("<TR>");
        this.add2Page("<TD>");
        this.add2Page("<TABLE>");
        this.addRow("Java Class", "className", className);
        this.add2Page("</TABLE>");
        this.add2Page("</TD>");
        this.add2Page("</TR>");
        this.add2Page("<TR>");
        this.add2Page("<TD>");
        this.add2Page("<TABLE>");
        this.addRow("Class Loader", "cloaderName", cloaderName);
        this.add2Page("</TABLE>");
        this.add2Page("</TD>");
        this.add2Page("</TR>");
        this.add2Page("</TABLE>");
        this.add2Page("<TABLE WIDTH=480 CELLPADDING=0 CELLSPACING=6>");
        this.add2Page("<TR>");
        this.add2Page("<TH ALIGN=RIGHT>Action:</TH>");
        this.add2Page("<TD>");
        this.add2Page("<SELECT NAME=\"action\">");
        if (action == null || action.equals("Create")) {
            this.add2Page("<OPTION SELECTED>Create");
            this.add2Page("<OPTION>Unregister");
            this.add2Page("<OPTION>Constructors");
        } else if (action.equals("Unregister")) {
            this.add2Page("<OPTION>Create");
            this.add2Page("<OPTION SELECTED>Unregister");
            this.add2Page("<OPTION>Constructors");
        } else if (action.equals("Constructors")) {
            this.add2Page("<OPTION>Create");
            this.add2Page("<OPTION>Unregister");
            this.add2Page("<OPTION SELECTED>Constructors");
        } else {
            this.add2Page("<OPTION SELECTED>Create");
            this.add2Page("<OPTION>Unregister");
            this.add2Page("<OPTION>Constructors");
        }
        this.add2Page("</SELECT>");
        this.add2Page("</TD></TR>");
        this.add2Page("<TR>");
        this.add2Page("<TD> </TD>");
        this.add2Page("<TD>");
        this.add2Page("<INPUT TYPE=SUBMIT VALUE=\"Send Request\">");
        this.add2Page("<INPUT TYPE=RESET VALUE=\"Reset\">");
        this.add2Page("</TD></TR>");
        this.add2Page("</TABLE>");
        this.add2Page("</FORM>");
        this.add2Page("<HR>");
        if (withEndPage) {
            this.add2Page("</BODY></HTML>");
        }
    }

    private StringBuffer cmfHttpAction(String action, String domainName, String className, String keysName, String cloaderName, ArrayList typeList, ArrayList valueList, boolean bctor) {
        String safeDomainName = this.translateNameToHtmlFormat(domainName);
        String safeKeysName = this.translateNameToHtmlFormat(keysName);
        StringBuffer errBuf = new StringBuffer();
        errBuf.append("<HR><P><FONT SIZE=+3 COLOR=red><B>");
        boolean error = false;
        if (action == null) {
            if (this.logger.finestOn()) {
                this.logger.finest("cmfHttpAction", "404 Not FoundUndefined action");
            }
            errBuf.append("404 Not Found</B></FONT><P><HR><P><P>Undefined action");
            return errBuf;
        }
        if (this.logger.finerOn()) {
            this.logger.finer("cmfHttpAction", "Perform the operation [" + action + "]");
        }
        ObjectName objName = null;
        try {
            objName = new ObjectName(domainName + ":" + keysName);
        }
        catch (MalformedObjectNameException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("cmfHttpAction", "474 Malformed ObjectName Cannot create the ObjectName [" + domainName + ":" + keysName + "]");
            }
            errBuf.append("474 Malformed ObjectName</B></FONT><P><HR><P><P>Cannot create the ObjectName [" + safeDomainName + ":" + safeKeysName + "]");
            return errBuf;
        }
        ObjectName ocloaderName = null;
        if (cloaderName != null && !cloaderName.equals("")) {
            try {
                ocloaderName = new ObjectName(cloaderName);
            }
            catch (MalformedObjectNameException e) {
                if (this.logger.finestOn()) {
                    this.logger.finest("cmfHttpAction", "474 Malformed ObjectName Cannot create the ObjectName for the classloader specified [" + cloaderName + "]");
                }
                errBuf.append("474 Malformed ObjectName</B></FONT><P><HR><P><P>Cannot create the ObjectName for the classloader specified [" + cloaderName + "]");
                return errBuf;
            }
        }
        try {
            if (action.equals("Unregister")) {
                this.mbs.unregisterMBean(objName);
                if (this.logger.finerOn()) {
                    this.logger.finer("cmfHttpAction", "Unregistered the MBean [" + objName + "]");
                }
            } else if (action.equals("Create")) {
                if (!valueList.isEmpty()) {
                    int nbElements = valueList.size();
                    Object[] argu = new Object[nbElements];
                    String[] sign = new String[nbElements];
                    for (int i = 0; i < nbElements; ++i) {
                        String type;
                        String val = (String)valueList.get(i);
                        sign[i] = type = (String)typeList.get(i);
                        if (this.logger.finerOn()) {
                            this.logger.finer("cmfHttpAction", "The MBean [" + objName + "] constructor paramater " + i + " [Type=" + type + ", Value=" + val + "]");
                        }
                        if (val.equals("JDMK_NULL_VALUE")) {
                            argu[i] = null;
                            continue;
                        }
                        if (type.endsWith("String")) {
                            argu[i] = val;
                            continue;
                        }
                        if (type.endsWith("Boolean") || type.endsWith("boolean")) {
                            argu[i] = new Boolean(val);
                            continue;
                        }
                        if (type.endsWith("Byte") || type.endsWith("byte")) {
                            argu[i] = new Byte(val);
                            continue;
                        }
                        if (type.equals("javax.management.ObjectName")) {
                            argu[i] = new ObjectName(val);
                            continue;
                        }
                        if (type.endsWith("Integer") || type.endsWith("int")) {
                            argu[i] = new Integer(val);
                            continue;
                        }
                        if (type.endsWith("Character") || type.endsWith("char")) {
                            argu[i] = new Character(val.charAt(0));
                            continue;
                        }
                        if (type.endsWith("Long") || type.endsWith("long")) {
                            argu[i] = new Long(val);
                            continue;
                        }
                        if (type.endsWith("Double") || type.endsWith("double")) {
                            argu[i] = new Double(val);
                            continue;
                        }
                        if (type.endsWith("Float") || type.endsWith("float")) {
                            argu[i] = new Float(val);
                            continue;
                        }
                        if (type.endsWith("Short") || type.endsWith("short")) {
                            argu[i] = new Short(val);
                            continue;
                        }
                        if (type.endsWith("Date")) {
                            try {
                                DateFormat df = DateFormat.getDateTimeInstance(1, 1);
                                df.setTimeZone(TimeZone.getDefault());
                                argu[i] = df.parse(val);
                                continue;
                            }
                            catch (ParseException e) {
                                errBuf.append("464 Invalid Property Value</B></FONT><P><HR><P>Cannot convert String to " + type);
                                error = true;
                                break;
                            }
                        }
                        if (type.endsWith("Number")) {
                            try {
                                argu[i] = new Integer(val);
                                continue;
                            }
                            catch (NumberFormatException e1) {
                                try {
                                    argu[i] = new Long(val);
                                    continue;
                                }
                                catch (NumberFormatException e2) {
                                    try {
                                        argu[i] = new Float(val);
                                        continue;
                                    }
                                    catch (NumberFormatException e3) {
                                        try {
                                            argu[i] = new Double(val);
                                            continue;
                                        }
                                        catch (NumberFormatException e4) {
                                            errBuf.append("464 Invalid Property Value</B></FONT><P><HR><P>Cannot convert String to " + type);
                                            error = true;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                        errBuf.append("464 Invalid Property Value</B></FONT><P><HR><P>Cannot convert String to " + type);
                        error = true;
                        break;
                    }
                    if (!error) {
                        if (ocloaderName != null) {
                            if (this.logger.finerOn()) {
                                this.logger.finer("cmfHttpAction", "Create the MBean [" + objName + "] with the specified constructor and using the class loader [" + ocloaderName + "]");
                            }
                            this.mbs.createMBean(className, objName, ocloaderName, argu, sign);
                        } else {
                            if (this.logger.finerOn()) {
                                this.logger.finer("cmfHttpAction", "Create the MBean [" + objName + "] with the specified constructor and using the default loader repository");
                            }
                            this.mbs.createMBean(className, objName, argu, sign);
                        }
                    }
                } else if (ocloaderName != null) {
                    if (this.logger.finerOn()) {
                        this.logger.finer("cmfHttpAction", "Create the MBean [" + objName + "] with the default constructor and using the class loader [" + ocloaderName + "]");
                    }
                    this.mbs.createMBean(className, objName, ocloaderName);
                } else {
                    if (this.logger.finerOn()) {
                        this.logger.finer("cmfHttpAction", "Create the MBean [" + objName + "] with the default constructor and using the default loader repository");
                    }
                    this.mbs.createMBean(className, objName);
                }
            }
            if (action.equals("Constructors") || bctor && action.equals("Create")) {
                if (this.logger.finerOn()) {
                    this.logger.finer("cmfHttpAction", "List the constructors of the MBean [" + objName + "] using the class loader [" + ocloaderName + "]");
                }
                this.ctors = this.getConstructors(this.findClass(className, ocloaderName));
            }
        }
        catch (ReflectionException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("cmfHttpAction", "Reflection exceptoin. [Exception=" + e.getTargetException() + "]");
            }
            error = true;
            errBuf.append("470 Reflection</B></FONT><P><HR><P>" + e.getTargetException());
        }
        catch (InstanceAlreadyExistsException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("cmfHttpAction", "Instance already exists. [Exception=" + e + "]");
            }
            error = true;
            errBuf.append("465 Instance Already Exists</B></FONT><P><HR><P>" + e.toString());
        }
        catch (MBeanRegistrationException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("cmfHttpAction", "MBean registration. [Exception=" + e + "]");
            }
            error = true;
            errBuf.append("471 MBean Registration Failure</B></FONT><P><HR><P>" + e.toString());
        }
        catch (MBeanException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("cmfHttpAction", "MBean exception. [Exception=" + e.getTargetException() + "]");
            }
            error = true;
            errBuf.append("472 MBean Failure</B></FONT><P><HR><P>" + e.getTargetException());
        }
        catch (NotCompliantMBeanException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("cmfHttpAction", "Not Compliant MBean. [Exception=" + e + "]");
            }
            error = true;
            errBuf.append("473 Not Compliant MBean</B></FONT><P><HR><P>" + e);
        }
        catch (InstanceNotFoundException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("cmfHttpAction", "Instance not found. [Exception=" + e + "]");
            }
            error = true;
            errBuf.append("459 Instance Not Found</B></FONT><P><HR><P>" + e);
        }
        catch (ClassNotFoundException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("cmfHttpAction", "The MBean class could not be loaded. [Exception=" + e + "]");
            }
            error = true;
            errBuf.append("460 Class Not Found</B></FONT><P><HR><P>" + e);
        }
        catch (NumberFormatException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("buildPage", "Cannot convert String to type. [Exception=" + e + "]");
            }
            error = true;
            errBuf.append("400 Bad Request</B></FONT><P><HR><P>" + e);
        }
        catch (MalformedObjectNameException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("buildPage", "Malformed object name. [Exception=" + e + "]");
            }
            error = true;
            errBuf.append("474 Malformed ObjectName</B></FONT><P><HR><P>" + e);
        }
        catch (JMRuntimeException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("cmfHttpAction", "Instance not found. [Exception=" + e + "]");
            }
            error = true;
            errBuf.append("472 MBean Failure</B></FONT><P><HR><P>" + e);
        }
        if (error) {
            return errBuf;
        }
        return null;
    }

    private void addRow(String fieldName, String fieldarg, String name) {
        String actualName = null;
        actualName = name == null ? "" : name;
        this.add2Page("<TR>");
        this.add2Page("<TD>");
        this.add2Page("<TABLE WIDTH=130 CELLPADDING=0 CELLSPACING=0>");
        this.add2Page("<TR>");
        this.add2Page("<TH ALIGN=RIGHT>" + fieldName + ":</TH>");
        this.add2Page("</TR>");
        this.add2Page("</TABLE>");
        this.add2Page("</TD>");
        this.add2Page("<TD>");
        this.add2Page("<TABLE CELLPADDING=0 CELLSPACING=0>");
        this.add2Page("<TR>");
        this.add2Page("<TD><INPUT TYPE=\"TEXT\" NAME=\"" + fieldarg + "\" VALUE=\"" + actualName + "\"SIZE=\"45\"></TD>");
        this.add2Page("</TR>");
        this.add2Page("</TABLE>");
        this.add2Page("</TD>");
        this.add2Page("</TR>");
    }

    private void buildCtorsList(String domainName, String className, String keysName, String cloaderName) {
        String safeDomainName = this.translateNameToHtmlFormat(domainName);
        String safeKeysName = this.translateNameToHtmlFormat(keysName);
        if (this.ctors != null) {
            if (this.logger.finerOn()) {
                this.logger.finer("buildCtorsList", "Found " + this.ctors.length + " constructors(s)");
            }
            String ctorStr = null;
            this.add2Page("<P><H3>List of MBean constructors for:</H3>\r\n");
            this.add2Page("<UL type=disc><LI><B>MBean Name:</B> " + safeDomainName + ":" + safeKeysName);
            this.add2Page("<LI><B>Class Loader Name:</B> " + (cloaderName == null ? "" : cloaderName));
            this.add2Page("</UL>");
            for (int i = 0; i < this.ctors.length; ++i) {
                ctorStr = this.buildCtorWithParam(domainName, className, keysName, cloaderName, this.ctors[i].getSignature());
                if (ctorStr == null) continue;
                String ai = this.ctors[i].getDescription();
                if (ai != null && ai.length() > 0) {
                    this.add2Page("<HR><A HREF=\"javascript:alert('" + ai + "');\"><B>Description of " + this.ctors[i].getName() + "</B></A>");
                } else {
                    this.add2Page("<HR><B>" + this.ctors[i].getName() + "</B>");
                }
                this.add2Page(ctorStr);
            }
        }
    }

    private String buildCtorWithParam(String domainName, String className, String keysName, String cloaderName, MBeanParameterInfo[] paramList) {
        int i;
        if (this.logger.finerOn()) {
            this.logger.finer("buildCtorWithParam", "Build the constructor [" + className + "] with parameters");
        }
        String encDomainName = this.encodeUrl(domainName);
        String encKeysName = this.encodeUrl(keysName);
        StringBuffer str = new StringBuffer(50);
        String propType = null;
        String param = null;
        int max = paramList.length;
        boolean support = true;
        for (i = 0; i < max; ++i) {
            propType = paramList[i].getType();
            if (this.checkType(propType) && !this.isArrayType(propType)) continue;
            support = false;
            break;
        }
        if (!support) {
            str.append("  <I>(Constructor Not Supported)</I>\r\n");
        }
        this.add2Page("<TD>");
        if (support) {
            str.append("<FORM ACTION=\"/Admin/Objects%%&domainName=" + encDomainName + "&keysName=" + encKeysName + "&className=" + className + "&cloaderName=" + (cloaderName != null ? cloaderName : "") + "&action=" + "Create" + "&\" METHOD=GET>" + "\r\n");
        }
        str.append("<TABLE>\r\n");
        if (!support) {
            str.append("<P><TD><B>" + className + "<B></TD>" + "\r\n");
        } else {
            str.append("<TD><INPUT TYPE=SUBMIT VALUE=\"Create\"></TD>\r\n");
            str.append("<TD><B>" + className + "</B> </TD>");
        }
        if (paramList.length == 0) {
            str.append("<TD>(default)</TD>");
        }
        for (i = 0; i < max; ++i) {
            String ai;
            propType = paramList[i].getType();
            param = paramList[i].getName().length() > 0 ? paramList[i].getName() : "param" + i;
            if (this.logger.finerOn()) {
                this.logger.finer("buildCtorWithParam", "Build the constructor [" + className + "] parameter " + param + " [Type=" + propType + "]");
            }
            if (i != 0) {
                str.append("<TD></TD>");
            }
            if ((ai = paramList[i].getDescription()) != null && ai.length() > 0) {
                str.append("<TD>(" + propType + ")<A HREF=\"javascript:alert('" + ai + "');\">" + param + "</A></TD>" + "\r\n");
            } else {
                str.append("<TD>(" + propType + ")" + param + "</TD>" + "\r\n");
            }
            if (!support) {
                str.append("<TD></TD>\r\n");
            } else if (propType.endsWith("Boolean") || propType.endsWith("boolean")) {
                str.append("<TD>" + this.boolToHtml(param, propType, "true", true) + "</TD>" + "\r\n");
            } else {
                str.append("<TD><INPUT TYPE=\"text\" NAME=\"" + param + "+" + propType + "\" ");
                str.append("SIZE=50%");
                str.append("></TD>\r\n");
            }
            str.append("</TR><TR><TD></TD>\r\n");
        }
        str.append("</TR></TABLE>\r\n");
        if (support) {
            str.append("</FORM>\r\n");
        }
        str.append("<HR>");
        return str.toString();
    }

    private MBeanConstructorInfo[] getConstructors(Class baseClass) throws NotCompliantMBeanException {
        MBeanInfo info = Introspector.testCompliance(baseClass);
        if (info != null) {
            return info.getConstructors();
        }
        if (this.logger.finestOn()) {
            this.logger.finest("getConstructors", "No MBean information, apply introspection on [Class=" + baseClass + "]");
        }
        return this.getTargetConstructors(baseClass);
    }

    private MBeanConstructorInfo[] getTargetConstructors(Class baseClass) {
        int i;
        Constructor<?>[] consList = baseClass.getConstructors();
        Vector<MBeanConstructorInfo> constructors = new Vector<MBeanConstructorInfo>();
        for (i = 0; i < consList.length; ++i) {
            MBeanConstructorInfo mc;
            block4: {
                Constructor<?> constructor = consList[i];
                mc = null;
                try {
                    mc = new MBeanConstructorInfo("Public constructor of the MBean", constructor);
                }
                catch (Exception ex) {
                    mc = null;
                    if (!this.logger.finestOn()) break block4;
                    this.logger.finest("getTargetConstructors", "Couldn't construct MBean constructor infor for [Constructor=" + constructor + "]");
                }
            }
            if (mc == null) continue;
            constructors.addElement(mc);
        }
        MBeanConstructorInfo[] resultConstructors = new MBeanConstructorInfo[constructors.size()];
        for (i = 0; i < resultConstructors.length; ++i) {
            resultConstructors[i] = (MBeanConstructorInfo)constructors.elementAt(i);
        }
        return resultConstructors;
    }

    private Class findClass(String className) throws ClassNotFoundException {
        if (this.logger.finerOn()) {
            this.logger.finer("findClass", "Load the class [" + className + "] using the class loader [Default Loader Repository]");
        }
        return this.loadClass(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class findClass(String className, ObjectName aLoader) throws ClassNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        if (aLoader == null) {
            return this.findClass(className);
        }
        Set<ObjectInstance> qresult = null;
        Object[] qmbeans = null;
        HtmlAdminPage htmlAdminPage = this;
        synchronized (htmlAdminPage) {
            qresult = this.mbs.queryMBeans(aLoader, null);
        }
        if (qresult.isEmpty()) {
            throw new InstanceNotFoundException("The loader named " + aLoader + " is not registered in the MBeanServer");
        }
        qmbeans = qresult.toArray();
        if (this.logger.finerOn()) {
            this.logger.finer("findClass", "Load the class [" + className + "] using the class loader [" + ((ObjectInstance)qmbeans[0]).getObjectName() + "]");
        }
        Object[] params = new Object[]{className};
        String[] signature = new String[]{"java.lang.String"};
        Class theClass = (Class)this.mbs.invoke(((ObjectInstance)qmbeans[0]).getObjectName(), "loadClass", params, signature);
        return theClass;
    }

    private Class loadClass(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            ClassLoaderRepository clr = MBeanServerFactory.getClassLoaderRepository(this.mbs);
            if (clr == null) {
                throw new ClassNotFoundException(className);
            }
            return clr.loadClass(className);
        }
    }
}

