/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.HtmlAdaptorServer;
import com.sun.jdmk.comm.HtmlPage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

class HtmlArrayPage
extends HtmlPage {
    private HtmlAdaptorServer server = null;

    public HtmlArrayPage(MBeanServer f, boolean r, boolean w, HtmlAdaptorServer server) {
        super(f, r, w);
        this.server = server;
    }

    @Override
    public void buildPage(String req) {
        int k;
        int index;
        if (this.logger.finerOn()) {
            this.logger.finer("buildPage", "Handle request [" + req + "]");
        }
        if ((index = req.indexOf("/", 1)) < 0) {
            this.buildError("Invalid request", "400 Bad Request");
            return;
        }
        String prop = req.substring(1, index);
        String objNameStr = req.substring(index, req.length());
        objNameStr = this.fromUrlName(objNameStr);
        String safeObjNameStr = this.translateNameToHtmlFormat(objNameStr);
        if (this.logger.finerOn()) {
            this.logger.finer("buildPage", "Build an Array page for the MBean [" + objNameStr + "] property [" + prop + "]");
        }
        this.htmlPage.append(this.buildHead("Array View of " + safeObjNameStr));
        this.htmlPage.append(this.startBody(null));
        Object o = null;
        ObjectName objName = null;
        MBeanAttributeInfo[] attinfo = null;
        try {
            objName = this.getObjectNameByObjNameStr(objNameStr);
            attinfo = this.mbs.getMBeanInfo(objName).getAttributes();
            o = this.mbs.getAttribute(objName, prop);
        }
        catch (IntrospectionException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("buildPage", "Exception = " + e);
            }
            this.buildError("Introspection: " + safeObjNameStr, "476 Introspection");
            return;
        }
        catch (MalformedObjectNameException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("buildPage", "Exception = " + e);
            }
            this.buildError("Invalid ObjectName: " + safeObjNameStr, "474 Malformed ObjectName");
            return;
        }
        catch (AttributeNotFoundException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("buildPage", "Exception = " + e);
            }
            this.buildError("Attribute " + prop + " not found", "475 Attribute Not Found");
            return;
        }
        catch (MBeanException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("buildPage", "Exception = " + e);
            }
            this.buildError("The getter of attribute " + prop + " throws the exception:<BR>" + e.getTargetException(), "472 MBean Failure");
            return;
        }
        catch (InstanceNotFoundException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("buildPage", "Exception = " + e);
            }
            this.buildError("Instance of " + safeObjNameStr + " not found", "459 Instance Not Found");
            return;
        }
        catch (ReflectionException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("buildPage", "Exception = " + e);
            }
            this.buildError("The MBeanServer throws an ReflectionException when calling attribute[" + prop + "] of [" + safeObjNameStr + "] :<BR>" + e.getTargetException().toString(), "470 Reflection");
            return;
        }
        catch (JMRuntimeException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("buildPage", "Exception = " + e);
            }
            this.buildError("The MBeanServer throws a JMRuntimeException when calling attribute [" + prop + "] of [" + safeObjNameStr + "] :<BR>" + e, "472 MBean Failure");
            return;
        }
        for (k = attinfo.length - 1; k >= 0 && !attinfo[k].getName().equals(prop); --k) {
        }
        if (o != null) {
            int y;
            Object[] tmp;
            Object[] ob = null;
            String typeStr = this.getElementClass(o);
            if (typeStr == null) {
                this.buildError("The attribute type " + o.getClass().getName() + " is not a supported array type<BR>", "472 MBean Failure");
                return;
            }
            if (typeStr.equals("int")) {
                tmp = (int[])o;
                ob = new String[tmp.length];
                for (y = tmp.length - 1; y >= 0; --y) {
                    ob[y] = String.valueOf(tmp[y]);
                }
            } else if (typeStr.equals("boolean")) {
                tmp = (boolean[])o;
                ob = new String[tmp.length];
                for (y = tmp.length - 1; y >= 0; --y) {
                    ob[y] = String.valueOf(tmp[y]);
                }
            } else if (typeStr.equals("char")) {
                tmp = (char[])o;
                ob = new String[tmp.length];
                for (y = tmp.length - 1; y >= 0; --y) {
                    ob[y] = String.valueOf(tmp[y]);
                }
            } else if (typeStr.equals("double")) {
                tmp = (double[])o;
                ob = new String[tmp.length];
                for (y = tmp.length - 1; y >= 0; --y) {
                    ob[y] = String.valueOf((double)tmp[y]);
                }
            } else if (typeStr.equals("float")) {
                tmp = (float[])o;
                ob = new String[tmp.length];
                for (y = tmp.length - 1; y >= 0; --y) {
                    ob[y] = String.valueOf((float)tmp[y]);
                }
            } else if (typeStr.equals("long")) {
                tmp = (long[])o;
                ob = new String[tmp.length];
                for (y = tmp.length - 1; y >= 0; --y) {
                    ob[y] = String.valueOf((long)tmp[y]);
                }
            } else if (typeStr.equals("short")) {
                tmp = (short[])o;
                ob = new Short[tmp.length];
                for (y = tmp.length - 1; y >= 0; --y) {
                    ob[y] = new Short(tmp[y]);
                }
            } else if (typeStr.equals("byte")) {
                tmp = (byte[])o;
                ob = new Byte[tmp.length];
                for (y = tmp.length - 1; y >= 0; --y) {
                    ob[y] = new Byte(tmp[y]);
                }
            } else {
                ob = (Object[])o;
            }
            String Extra = "";
            this.add2Page("<TABLE WIDTH=100%>");
            this.add2Page("<TR>");
            this.add2Page("<TD ALIGN=left><H2>Array View</H2></TD>");
            this.add2Page("<TD ALIGN=right VALIGN=top>[Project OpenDMKopendmk-1.0-b02]</TD>");
            this.add2Page("</TR></TABLE>");
            this.add2Page("<UL type=disc><LI><B>MBean Name:</B> " + safeObjNameStr);
            this.add2Page("<LI><B>MBean Attribute:</B> " + prop);
            this.add2Page("<LI><B>Array of:</B> " + typeStr);
            this.add2Page("</UL>");
            this.add2Page("<TABLE WIDTH=100%><TR>");
            this.add2Page("<TD ALIGN=LEFT><A HREF=\"/ViewObjectRes" + this.toUrlName(objNameStr) + "\">Back to " + "MBean View" + "</A></TD>");
            this.add2Page("<TD ALIGN=RIGHT><A HREF=\"/\">Back to Agent View</A></TD>");
            this.add2Page("</TR></TABLE>");
            this.add2Page("<HR>");
            if (attinfo[k].isWritable() && !attinfo[k].isReadable()) {
                if (this.logger.finerOn()) {
                    this.logger.finer("buildPage", "The property [Name=" + prop + ", Type=" + typeStr + "] is WR");
                }
                this.add2Page("<FORM ACTION=/SetForm" + this.toUrlName(objNameStr) + " METHOD=GET>");
                this.add2Page("<TABLE ALIGN=center BORDER=1 WIDTH=100% CELLPADDING=3>");
                this.add2Page("<TR>");
                this.add2Page("<TH WIDTH=10%> Element at </TH>");
                this.add2Page("<TH WIDTH=7%> Access </TH>");
                this.add2Page("<TH WIDTH=35%> Value </TH>");
                this.add2Page("</TR>");
                for (int i = 0; i < ob.length; ++i) {
                    this.add2Page("<TR>");
                    this.add2Page("<TD ALIGN=center>" + i + "</TD><TD ALIGN=center>WO</TD>");
                    if (ob[i] == null) {
                        this.add2Page("<TD>null</TD>");
                    } else if (typeStr.endsWith("Boolean") || typeStr.endsWith("boolean")) {
                        this.add2Page("<TD>");
                        this.add2Page(this.boolToHtml(prop + "[" + i + "]", typeStr, ob[i].toString(), false));
                        this.add2Page("</TD>");
                    } else {
                        this.htmlPage.append("<TD><INPUT TYPE=\"password\" NAME=\"" + prop + "[" + i + "]+" + typeStr + "\" ");
                        this.add2Page("SIZE=34%></TD>");
                    }
                    this.add2Page("</TR>");
                }
                this.add2Page("</TABLE>");
                this.add2Page("<ALIGN=center>");
                this.add2Page("<INPUT TYPE=submit VALUE=\"Apply\"> ");
            } else if (attinfo[k].isReadable() && !attinfo[k].isWritable()) {
                if (this.logger.finerOn()) {
                    this.logger.finer("buildPage", "The property [Name=" + prop + ", Type=" + typeStr + "] is RO");
                }
                this.add2Page("<A NAME=\"Top\"></A>");
                this.add2Page("<TABLE ALIGN=center BORDER=1 CELLPADDING=3>");
                this.add2Page("<TR>");
                this.add2Page("<TH WIDTH=10%> Element at </TH>");
                this.add2Page("<TH WIDTH=7%> Access </TH>");
                this.add2Page("<TH WIDTH=35%> Value </TH>");
                this.add2Page("</TR>");
                for (int i = 0; i < ob.length; ++i) {
                    this.add2Page("<TR>");
                    this.add2Page("<TD ALIGN=center>" + i + "</TD><TD ALIGN=center>RO</TD>");
                    if (ob[i] == null) {
                        this.htmlPage.append("<TD>null</TD>");
                    } else if (typeStr.equals("javax.management.ObjectName")) {
                        this.add2Page("<TD><A HREF=\"/ViewObjectRes" + this.toUrlName(ob[i].toString()) + "\">" + ob[i].toString() + "</A></TD>");
                    } else if (typeStr.endsWith("Date")) {
                        this.add2Page("<TD>");
                        this.add2Page(this.convertDate((Date)ob[i]));
                        this.add2Page("</TD>");
                    } else if (!this.checkType(typeStr)) {
                        Extra = Extra + "<P><A NAME=\"Element" + i + "\"> Element " + i + "</A> - <A HREF=\"#Top\">Go back to main table</A>";
                        Extra = Extra + this.buildEleTable(ob[i]);
                        this.add2Page("<TD><I>Type Not Supported</I>: [" + this.translateNameToHtmlFormat(ob[i].toString()) + "] <A HREF=\"#Element" + i + "\">View the value</A></TD>");
                    } else {
                        this.add2Page("<TD><PRE>" + this.translateNameToHtmlFormat(ob[i].toString()) + "</PRE></TD>");
                    }
                    this.add2Page("</TR>");
                }
                this.add2Page("</TABLE>");
                this.add2Page(Extra);
            } else if (attinfo[k].isReadable() && attinfo[k].isWritable()) {
                if (this.logger.finerOn()) {
                    this.logger.finer("buildPage", "The property [Name=" + prop + ", Type=" + typeStr + "] is RW");
                }
                this.add2Page("<FORM ACTION=/SetForm" + this.toUrlName(objNameStr) + " METHOD=GET>");
                this.add2Page("<TABLE ALIGN=center BORDER=1 CELLPADDING=3>");
                this.add2Page("<TR>");
                this.add2Page("<TH WIDTH=10%> Element at </TH>");
                this.add2Page("<TH WIDTH=7%> Access </TH>");
                this.add2Page("<TH WIDTH=35%> Value </TH>");
                this.add2Page("</TR>");
                for (int i = 0; i < ob.length; ++i) {
                    this.add2Page("<TR>");
                    this.add2Page("<TD ALIGN=center>" + i + "</TD><TD ALIGN=center>RW</TD>");
                    if (typeStr.endsWith("Boolean") || typeStr.endsWith("boolean")) {
                        this.add2Page("<TD>");
                        this.add2Page(this.boolToHtml(prop + "[" + i + "]", typeStr, ob[i] != null ? ob[i].toString() : "null", ob[i] != null));
                        this.add2Page("</TD>");
                    } else if (typeStr.equals("javax.management.ObjectName")) {
                        this.htmlPage.append("<TD><INPUT TYPE=\"text\" NAME=\"" + prop + "[" + i + "]+" + typeStr + "\" ");
                        this.htmlPage.append("VALUE= \"" + (ob[i] != null ? ob[i].toString() : "") + "\" ");
                        this.add2Page("SIZE=" + (ob[i] != null ? ob[i].toString().length() : 20) + ">");
                        this.add2Page("<A HREF=\"/ViewObjectRes" + this.toUrlName(ob[i] != null ? ob[i].toString() : "") + "\">V</A></TD>");
                    } else if (typeStr.endsWith("Date")) {
                        this.htmlPage.append("<TD><INPUT TYPE=\"text\" NAME=\"" + prop + "[" + i + "]+" + typeStr + "\" ");
                        this.htmlPage.append("VALUE= \"" + this.convertDate((Date)ob[i]) + "\" ");
                        this.add2Page("SIZE=" + (ob[i] != null ? ob[i].toString().length() : 20) + "></TD>");
                    } else if (!this.checkType(typeStr)) {
                        Extra = Extra + "<A NAME=\"Element" + i + "\"> Element " + i + "</A> - <A HREF=\"#Top\">Go back to main table</A>";
                        Extra = Extra + this.buildEleTable(ob[i]);
                        this.add2Page("<TD><I>Type Not Supported</I>: [" + this.translateNameToHtmlFormat(ob[i].toString()) + "] <A HREF=\"#Element" + i + "\">View the value</A></TD>");
                    } else {
                        this.htmlPage.append("<TD><INPUT TYPE=\"text\" NAME=\"" + prop + "[" + i + "]+" + typeStr + "\" ");
                        this.htmlPage.append("VALUE= \"" + this.translateNameToHtmlFormat(ob[i] != null ? ob[i].toString() : "") + "\" ");
                        this.add2Page("SIZE=34%></TD>");
                    }
                    this.add2Page("</TR>");
                }
                this.add2Page("</TABLE>");
                if (Extra.equals("")) {
                    this.add2Page("<INPUT TYPE=submit VALUE=\"Apply\"> ");
                } else {
                    this.add2Page(Extra);
                }
                this.add2Page("</FORM>");
            }
        } else {
            if (this.logger.finerOn()) {
                this.logger.finer("buildPage", "The property [" + prop + "] is a null");
            }
            this.add2Page("<p> Attribute " + prop + " is null");
        }
        this.add2Page(this.stopBody());
    }

    private String buildEleTable(Object obj) {
        if (obj == null) {
            return "Null object";
        }
        Class<?> c = obj.getClass();
        String cName = c.getName();
        if (this.logger.finerOn()) {
            this.logger.finer("buildEleTable", "Build a table for the element [Name= " + obj + "Classname=" + cName + "]");
        }
        Method[] methods = c.getMethods();
        String[] propertyName = new String[methods.length];
        String[] propertyType = new String[methods.length];
        String[] propertyView = new String[methods.length];
        int maxViewLength = 0;
        int nbGoodProperties = 0;
        boolean foundBadSetter = false;
        for (int i = 0; i < methods.length; ++i) {
            boolean flat = true;
            String mName = methods[i].getName();
            String declName = methods[i].getDeclaringClass().getName();
            Class<?> returnType = methods[i].getReturnType();
            Class<?>[] parameterType = methods[i].getParameterTypes();
            if (this.logger.finerOn()) {
                this.logger.finer("buildEleTable", "Analyze element [" + obj + "] method [" + returnType + " " + mName + "(" + parameterType.length + " param)]");
            }
            if (mName.startsWith("get")) {
                boolean reqDone;
                Object o;
                block26: {
                    if (parameterType.length > 0) {
                        propertyName[i] = null;
                        continue;
                    }
                    propertyName[i] = new String(mName.substring(3));
                    propertyType[i] = this.usualType(new String(returnType.getName()));
                    o = null;
                    reqDone = false;
                    try {
                        if (this.isArrayType(propertyType[i])) {
                            if (this.logger.finerOn()) {
                                this.logger.finer("buildEleTable", "Found array [Name=" + propertyName[i] + ", Type= " + propertyType[i] + "]");
                            }
                            o = "values of " + propertyName[i];
                        } else {
                            if (this.logger.finerOn()) {
                                this.logger.finer("buildEleTable", "Call the method [Name=" + methods[i] + "] for Property [Name=" + propertyName[i] + "]");
                            }
                            o = methods[i].invoke(obj, (Object[])null);
                        }
                        reqDone = true;
                    }
                    catch (InvocationTargetException e) {
                        if (this.logger.finestOn()) {
                            this.logger.finest("buildEleTable", "Cannot get value for propertyName[" + i + "] = " + propertyName[i] + " Got exception:\n" + e.toString());
                            this.logger.finest("EXCEPTION", e.toString());
                        }
                    }
                    catch (IllegalAccessException e) {
                        if (this.logger.finestOn()) {
                            this.logger.finest("buildEleTable", "Cannot get value for propertyName[" + i + "] = " + propertyName[i] + " Got exception:\n" + e.toString());
                            this.logger.finest("EXCEPTION", e.toString());
                        }
                    }
                    catch (IllegalArgumentException e) {
                        if (!this.logger.finestOn()) break block26;
                        this.logger.finest("buildEleTable", "Cannot get value for propertyName[" + i + "] = " + propertyName[i] + " Got exception:\n" + e.toString());
                        this.logger.finest("EXCEPTION", e.toString());
                    }
                }
                if (!reqDone) {
                    if (this.logger.finerOn()) {
                        this.logger.finer("buildEleTable", "Invocation error: Remove property [" + propertyName[i] + "]");
                    }
                    propertyName[i] = null;
                    continue;
                }
                ++nbGoodProperties;
                if (o == null) {
                    propertyView[i] = "";
                    continue;
                }
                propertyView[i] = o.toString();
                if (propertyView[i].length() <= maxViewLength) continue;
                maxViewLength = propertyView[i].length();
                continue;
            }
            propertyName[i] = null;
        }
        StringBuffer htmlProperty = new StringBuffer();
        if (nbGoodProperties > 0) {
            boolean hasInput = false;
            htmlProperty.append("<TABLE ALIGN=center BORDER=1>\r\n<TR>\r\n<TH> Property Name </TH>\r\n<TH> Type </TH>\r\n<TH> Value </TH>\r\n</TR>\r\n");
            for (int i = 0; i < methods.length; ++i) {
                if (propertyName[i] == null) continue;
                htmlProperty.append("<TR>\r\n<TD><B>" + propertyName[i] + "</B></TD>" + "<TD>" + propertyType[i] + "</TD>" + "\r\n");
                if (propertyView[i] != null) {
                    if (this.isArrayType(propertyType[i])) {
                        if (this.logger.finerOn()) {
                            this.logger.finer("buildEleTable", "Build link to array page.");
                        }
                        htmlProperty.append("<TD>Not displayable</TD>\r\n");
                    } else {
                        htmlProperty.append("<TD>" + propertyView[i] + "</TD>" + "\r\n");
                    }
                } else {
                    htmlProperty.append("<TD> ?? </TD>\r\n");
                }
                htmlProperty.append("</TR>\r\n");
            }
            htmlProperty.append("</TABLE>\r\n");
        }
        return htmlProperty.toString();
    }

    private String getElementClass(Object o) {
        String str = this.usualType(o.getClass().getName());
        if (!str.endsWith("[]")) {
            return null;
        }
        return str.substring(0, str.length() - 2);
    }

    private String convertDate(Date d) {
        if (d == null) {
            return "";
        }
        DateFormat df = DateFormat.getDateTimeInstance(1, 1);
        df.setTimeZone(TimeZone.getDefault());
        return df.format(d);
    }
}

