/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.HtmlPage;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.TimeZone;
import javax.management.InstanceNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

class HtmlInvokePage
extends HtmlPage {
    private ArrayList valueList = null;
    private ArrayList typeList = null;

    public HtmlInvokePage(MBeanServer f, boolean r, boolean w) {
        super(f, r, w);
    }

    @Override
    public void buildPage(String req) {
        if (this.logger.finerOn()) {
            this.logger.finer("buildPage", "Handle request = " + req);
        }
        int index = req.indexOf(47, 1);
        int query = req.indexOf("/action=", 1);
        if (index < 0 || query < 0) {
            this.buildError("Invalid Request: " + req, "400 Bad Request");
            return;
        }
        String func = this.getAction(req.substring(query + 1));
        if (func == null) {
            this.buildError("Invalid Request: " + req, "400 Bad Request");
            return;
        }
        if (!this.getParams(req.substring(req.indexOf(63, 1) + 1))) {
            return;
        }
        String objNameStr = this.fromUrlName(req.substring(0, query));
        String safeObjNameStr = this.translateNameToHtmlFormat(objNameStr);
        if (this.logger.finerOn()) {
            this.logger.finer("buildPage", "For objName = [" + objNameStr + "] " + "function called = [" + func + "]");
        }
        ObjectName objName = null;
        try {
            objName = this.getObjectNameByObjNameStr(objNameStr);
        }
        catch (MalformedObjectNameException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("buildPage", "Exception = " + e);
            }
            this.buildError("Invalid ObjectName: " + safeObjNameStr, "474 Malformed ObjectName");
            return;
        }
        if (objName == null) {
            if (this.logger.finestOn()) {
                this.logger.finest("buildPage", "Unable to get Object Definition for [" + objNameStr + "]");
            }
            this.buildError("Unable to get Object Definition for [" + safeObjNameStr + "]", "459 Instance Not Found");
            return;
        }
        this.htmlPage.append(this.buildHead("Java Dynamic Management View of " + func + " invocation"));
        this.htmlPage.append(this.startBody(null));
        int nbElements = this.valueList.size();
        Object[] argu = new Object[nbElements];
        String[] sign = new String[nbElements];
        for (int i = 0; i < nbElements; ++i) {
            String type;
            String val = (String)this.valueList.get(i);
            sign[i] = type = (String)this.typeList.get(i);
            if (val.equals("JDMK_NULL_VALUE")) {
                argu[i] = null;
                continue;
            }
            try {
                if (type.endsWith("String")) {
                    argu[i] = val;
                    continue;
                }
                if (type.endsWith("Boolean") || type.endsWith("boolean")) {
                    argu[i] = new Boolean(val);
                    continue;
                }
                if (type.endsWith("Byte") || type.endsWith("byte")) {
                    argu[i] = new Byte(val);
                    continue;
                }
                if (type.equals("javax.management.ObjectName")) {
                    argu[i] = new ObjectName(val);
                    continue;
                }
                if (type.endsWith("Integer") || type.endsWith("int")) {
                    argu[i] = new Integer(val);
                    continue;
                }
                if (type.endsWith("Character") || type.endsWith("char")) {
                    argu[i] = new Character(val.charAt(0));
                    continue;
                }
                if (type.endsWith("Long") || type.endsWith("long")) {
                    argu[i] = new Long(val);
                    continue;
                }
                if (type.endsWith("Double") || type.endsWith("double")) {
                    argu[i] = new Double(val);
                    continue;
                }
                if (type.endsWith("Float") || type.endsWith("float")) {
                    argu[i] = new Float(val);
                    continue;
                }
                if (type.endsWith("Short") || type.endsWith("short")) {
                    argu[i] = new Short(val);
                    continue;
                }
                if (type.endsWith("Date")) {
                    try {
                        DateFormat df = DateFormat.getDateTimeInstance(1, 1);
                        df.setTimeZone(TimeZone.getDefault());
                        argu[i] = df.parse(val);
                        continue;
                    }
                    catch (ParseException e) {
                        this.buildError("Cannot convert String \"" + val + "\" to " + type + ".<P>", "400 Bad Request");
                        return;
                    }
                }
                if (type.endsWith("Number")) {
                    try {
                        argu[i] = new Integer(val);
                        continue;
                    }
                    catch (NumberFormatException e1) {
                        try {
                            argu[i] = new Long(val);
                            continue;
                        }
                        catch (NumberFormatException e2) {
                            try {
                                argu[i] = new Float(val);
                                continue;
                            }
                            catch (NumberFormatException e3) {
                                try {
                                    argu[i] = new Double(val);
                                    continue;
                                }
                                catch (NumberFormatException e4) {
                                    this.buildError("Cannot convert String \"" + val + "\" to " + type + ".<P>", "400 Bad Request");
                                    return;
                                }
                            }
                        }
                    }
                }
                this.buildError("Cannot convert String to " + type, "464 Invalid Property Value");
                return;
            }
            catch (NumberFormatException e) {
                if (this.logger.finestOn()) {
                    this.logger.finest("buildPage", "Cannot convert String to " + type + " Exception = " + e);
                }
                this.buildError("Cannot convert String to " + type, "400 Bad Request");
                return;
            }
            catch (MalformedObjectNameException e) {
                if (this.logger.finestOn()) {
                    this.logger.finest("buildPage", "The format of the string [" + objNameStr + "] does not correspond to a valid ObjectName." + " Exception = " + e);
                }
                this.buildError("The format of the string [" + safeObjNameStr + "] does not correspond to a valid ObjectName <P>" + e.toString() + "<P>", "474 Malformed ObjectName");
                return;
            }
        }
        Object res = null;
        try {
            res = this.mbs.invoke(objName, func, argu, sign);
        }
        catch (InstanceNotFoundException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("buildPage", "Unable to get MBeanInfo for [" + objNameStr + "]" + " Exception = " + e);
            }
            this.buildError("Unable to get MBeanInfo for [" + safeObjNameStr + "]", "459 Instance Not Found");
            return;
        }
        catch (MBeanException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("buildPage", "The MBean [" + objNameStr + "] throws an MBeanException when calling [" + func + "]" + " Exception = " + e.getTargetException());
            }
            this.buildError("The MBean [" + safeObjNameStr + "] throws an MBeanException when calling [" + func + "]:<BR>" + e.getTargetException().toString(), "472 MBean Failure");
            return;
        }
        catch (ReflectionException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("buildPage", "The MBeanServer throws a ReflectionException when calling operation[" + func + "] of [" + objNameStr + "]" + " Exception = " + e.getTargetException());
            }
            this.buildError("The MBeanServer throws an ReflectionException when calling operation[" + func + "] of [" + safeObjNameStr + "] :<BR>" + e.getTargetException().toString(), "470 Reflection");
            return;
        }
        catch (JMRuntimeException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("buildPage", "The MBeanServer throws a JMRuntimeException when calling operation[" + func + "] of [" + objNameStr + "]" + " Exception = " + e);
            }
            this.buildError("The MBeanServer throws a JMRuntimeException when calling operation[" + func + "] of [" + safeObjNameStr + "] :<BR>" + e, "472 MBean Failure");
            return;
        }
        this.htmlPage.append("<HR><P>\r\n<FONT SIZE=+3 COLOR=green><B>" + func + " Successful" + "</B></FONT><P><HR><P>" + "The operation [" + func + "] was successfully invoked for the MBean [" + safeObjNameStr + "].");
        if (res != null) {
            this.add2Page("<BR>The operation returned with the value:<P>");
            this.add2Page(res.toString());
        } else {
            this.add2Page("<BR>The operation returned with no value.");
        }
        this.add2Page("<P><TABLE WIDTH=100%><TR>");
        this.add2Page("<TD ALIGN=LEFT><A HREF=\"/ViewObjectRes" + this.toUrlName(objNameStr) + "\">Back to " + "MBean View" + "</A></TD>");
        this.add2Page("<TD ALIGN=RIGHT><A HREF=\"/\">Back to Agent View</A></TD>");
        this.add2Page("</TR></TABLE>");
        this.add2Page(this.stopBody());
    }

    private String getAction(String req) {
        int beg = req.indexOf("action=");
        if (beg < 0) {
            return null;
        }
        int end = req.indexOf("?", beg);
        if (end < 0) {
            return null;
        }
        return req.substring(beg + 7, end);
    }

    private boolean getParams(String reqStr) {
        this.valueList = new ArrayList();
        this.typeList = new ArrayList();
        boolean done = false;
        String propReqStr = null;
        while (!done) {
            int index = reqStr.indexOf(38);
            if (index < 0) {
                propReqStr = reqStr;
                done = true;
            } else {
                propReqStr = reqStr.substring(0, index);
                reqStr = reqStr.substring(index + 1);
            }
            index = propReqStr.indexOf(61);
            if (index < 0) {
                done = true;
                this.buildError("Syntax error in request [" + propReqStr + "]", "400 Bad Request");
                return false;
            }
            String propStr = propReqStr.substring(0, index);
            String valueStr = propReqStr.substring(index + 1);
            String typeStr = null;
            if (propStr != null && propStr.length() != 0) {
                while (propStr.startsWith("%")) {
                    propStr = propStr.substring(3);
                }
                valueStr = valueStr != null && valueStr.length() != 0 ? this.decodeUrl(valueStr) : "JDMK_NULL_VALUE";
                if (this.logger.finerOn()) {
                    this.logger.finer("getParams", "Parsing property name [" + propStr + "]");
                }
                if ((index = propStr.indexOf("%2B", 0)) < 0) {
                    index = propStr.indexOf("%2b", 0);
                }
                if (index >= 0) {
                    typeStr = propStr.substring(index + 3);
                    propStr = propStr.substring(0, index);
                } else {
                    typeStr = "String";
                }
                if (this.logger.finerOn()) {
                    this.logger.finer("getParams", "Get Name = [" + propStr + "] " + "Type = [" + typeStr + "]" + " Value = [" + valueStr + "]");
                }
                if (propStr.equals("action")) continue;
                this.typeList.add(typeStr);
                this.valueList.add(valueStr);
                continue;
            }
            if (this.logger.finerOn()) {
                this.logger.finer("getParams", "Got null value or property");
            }
            this.buildError("Syntax error in request [" + propReqStr + "]", "400 Bad Request");
            return false;
        }
        if (this.logger.finerOn()) {
            this.logger.finer("getParams", "Returns " + this.valueList.size() + " params");
        }
        return true;
    }
}

