/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.Enumerated;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import com.sun.jdmk.comm.HtmlPage;
import java.lang.reflect.Constructor;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.loading.ClassLoaderRepository;

class HtmlObjectPage
extends HtmlPage {
    private MBeanAttributeInfo[] attinfo = null;
    private String[] propertyName = null;
    private String[] propertyView = null;
    private ObjectName manipulatedObjName = null;
    private MBeanInfo manipulatedObj = null;
    private String meta = null;
    private int autoRefresh = 0;
    private final int minAutoRefresh = 5;
    private HtmlAdaptorServer server = null;

    public HtmlObjectPage(MBeanServer f, boolean r, boolean w, HtmlAdaptorServer server) {
        super(f, r, w);
        this.server = server;
    }

    @Override
    public void buildPage(String req) {
        if (this.logger.finerOn()) {
            this.logger.finer("buildPage", "Handle request = " + req);
        }
        String objNameStr = req;
        int disp = req.indexOf("?");
        if (disp >= 0) {
            objNameStr = req.substring(0, disp);
        }
        if (!this.analyseObj(objNameStr = this.fromUrlName(objNameStr))) {
            return;
        }
        if (!this.startPage(objNameStr)) {
            return;
        }
        this.buildAttributes(objNameStr);
        this.buildOperations();
        this.endPage();
    }

    public void endPage() {
        if (this.logger.finerOn()) {
            this.logger.finer("endPage", "End the object(MBean) page.");
        }
        this.add2Page(this.stopBody());
    }

    public boolean startPage(String objNameStr) {
        if (this.logger.finerOn()) {
            this.logger.finer("startPage", "Start the object(MBean) page for = " + objNameStr);
        }
        String safeObjNameStr = this.translateNameToHtmlFormat(objNameStr);
        if (this.meta != null) {
            this.htmlPage.append(this.buildHeadMeta("MBean View of " + safeObjNameStr, this.meta));
        } else {
            this.htmlPage.append(this.buildHead("MBean View of " + safeObjNameStr));
        }
        this.htmlPage.append(this.startBody(null));
        this.add2Page("<TABLE WIDTH=100%>");
        this.add2Page("<TR>");
        this.add2Page("<TD ALIGN=left><H2>MBean View</H2></TD>");
        this.add2Page("<TD ALIGN=right VALIGN=top>[Project OpenDMKopendmk-1.0-b02]</TD>");
        this.add2Page("</TR></TABLE>");
        this.add2Page("<UL type=disc><LI><B>MBean Name:</B> " + safeObjNameStr);
        this.add2Page("<LI><B>MBean Java Class:</B> " + this.manipulatedObj.getClassName());
        this.add2Page("</UL>");
        this.add2Page("<TABLE WIDTH=100%><TR>");
        this.add2Page("<TD ALIGN=LEFT><A HREF=\"/\">Back to Agent View</A></TD>");
        this.add2Page("<TD ALIGN=CENTER>");
        this.add2Page("<FORM ACTION=/AutoRefresh" + this.toUrlName(objNameStr) + " METHOD=GET>");
        this.add2Page("Reload Period in seconds:<BR><INPUT type=text name=period value=" + this.autoRefresh + " SIZE=2>" + "<INPUT TYPE=submit VALUE=\"Reload\"></FORM></TD>");
        this.add2Page("<TD ALIGN=RIGHT><BR><FORM ACTION=\"/Admin/Objects%%&keysName=" + URLEncoder.encode(this.manipulatedObjName.getKeyPropertyListString()) + "&domainName=" + URLEncoder.encode(this.manipulatedObjName.getDomain()) + "&className=" + URLEncoder.encode(this.manipulatedObj.getClassName()) + "&action=" + "Unregister" + "&\" METHOD=GET>");
        this.add2Page("<FONT SIZE=-1><INPUT type=submit VALUE=\"Unregister\" ></FONT></FORM></TD>");
        this.add2Page("</TR></TABLE>");
        return true;
    }

    public boolean setObjectValue(String objNameStr, String reqStr) {
        if (this.logger.finerOn()) {
            this.logger.finer("setObjectValue", "[name=" + objNameStr + ", request=" + reqStr + "]");
        }
        StringBuffer errBuf = new StringBuffer();
        boolean error = false;
        objNameStr = this.fromUrlName(objNameStr);
        String safeObjNameStr = this.translateNameToHtmlFormat(objNameStr);
        if (!reqStr.startsWith("?")) {
            this.buildError("Incorrect request form, must start with ?", "400 Bad Request");
            return false;
        }
        reqStr = reqStr.substring(1);
        ArrayList<Object> anArray = null;
        AttributeList attlist = new AttributeList();
        String propReqStr = reqStr;
        boolean done = false;
        String propStr = null;
        String typeStr = null;
        String ind = null;
        try {
            this.manipulatedObjName = this.getObjectNameByObjNameStr(objNameStr);
        }
        catch (MalformedObjectNameException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("setObjectValue", "Exception = " + e);
            }
            this.buildError("The format of the string [" + safeObjNameStr + "] does not correspond to a valid ObjectName <P>" + e.toString() + "<P>", "474 Malformed ObjectName");
            return false;
        }
        while (!done) {
            int index = reqStr.indexOf(38);
            if (index < 0) {
                propReqStr = reqStr;
                done = true;
            } else {
                propReqStr = reqStr.substring(0, index);
                reqStr = reqStr.substring(index + 1);
            }
            index = propReqStr.indexOf(61);
            if (index < 0) {
                done = true;
                this.buildError("Syntax error in request [" + propReqStr + "]", "400 Bad Request");
                return false;
            }
            propStr = propReqStr.substring(0, index);
            String valueStr = propReqStr.substring(index + 1);
            if (valueStr != null && propStr != null && valueStr.length() != 0 && propStr.length() != 0) {
                int indexValue;
                Object attvalue;
                block50: {
                    while (propStr.startsWith("%")) {
                        propStr = propStr.substring(3);
                    }
                    valueStr = this.decodeUrl(valueStr);
                    if (this.logger.finerOn()) {
                        this.logger.finer("setObjectValue", "Parsing property name [" + propStr + "]");
                    }
                    if ((index = propStr.indexOf("%2B", 0)) < 0) {
                        index = propStr.indexOf("%2b", 0);
                    }
                    if (index >= 0) {
                        typeStr = propStr.substring(index + 3);
                        propStr = propStr.substring(0, index);
                    } else {
                        typeStr = "String";
                    }
                    ind = "";
                    if (propStr.indexOf("%5B") > 0) {
                        ind = propStr.substring(propStr.indexOf("%5B") + 3, propStr.indexOf("%5D"));
                        propStr = propStr.substring(0, propStr.indexOf("%5B"));
                    } else if (propStr.indexOf("%5b") > 0) {
                        ind = propStr.substring(propStr.indexOf("%5b") + 3, propStr.indexOf("%5d"));
                        propStr = propStr.substring(0, propStr.indexOf("%5b"));
                    }
                    if (this.logger.finerOn()) {
                        this.logger.finer("setObjectValue", "Get Name = [" + propStr + "] " + (ind.length() > 0 ? "[" + ind + "] " : " ") + "Type = [" + typeStr + "]" + " Value = [" + valueStr + "]");
                    }
                    attvalue = null;
                    if (propStr.startsWith("Enumerated%29")) {
                        propStr = propStr.substring(13);
                        if (!valueStr.equals("---")) {
                            try {
                                Class<?> ocl;
                                int i;
                                MBeanAttributeInfo[] attrInfos = this.mbs.getMBeanInfo(this.manipulatedObjName).getAttributes();
                                boolean found = false;
                                for (i = 0; i < attrInfos.length && !(found = attrInfos[i].getName().equals(propStr)); ++i) {
                                }
                                if (found) {
                                    ocl = attrInfos[i].isReadable() ? this.mbs.getAttribute(this.manipulatedObjName, propStr).getClass() : this.loadClass(typeStr);
                                    if (this.logger.finerOn()) {
                                        this.logger.finer("setObjectValue", "Got Class for Enumerated attribute[" + propStr + "] is [" + ocl.getName() + "]");
                                    }
                                } else {
                                    throw new AttributeNotFoundException("Could not find attribute [" + propStr + "] in MBean [" + this.manipulatedObjName + "]");
                                }
                                Class<?> sc = ocl.getSuperclass();
                                if (sc != null && Enumerated.class.isAssignableFrom(sc)) {
                                    Constructor<?>[] cons = ocl.getDeclaredConstructors();
                                    for (int consi = 0; consi < cons.length; ++consi) {
                                        Class<?>[] cl = cons[consi].getParameterTypes();
                                        if (cl.length != 1 || !cl[0].getName().endsWith("String")) continue;
                                        if (this.logger.finerOn()) {
                                            this.logger.finer("setObjectValue", "Found constructor for Enumerated = " + ocl.getName());
                                        }
                                        Object[] param = new Object[]{valueStr};
                                        attvalue = cons[consi].newInstance(param);
                                    }
                                    break block50;
                                }
                                this.buildError("Cannot get constructor of " + typeStr + " for setting " + propStr + ": Invalid Enumerated.", "464 Invalid Property Value");
                                return false;
                            }
                            catch (Exception e) {
                                if (this.logger.finestOn()) {
                                    this.logger.finest("setObjectValue", "Exception = " + e);
                                }
                                this.buildError("Cannot get constructor of " + typeStr + " for setting " + propStr + " of MBean " + this.manipulatedObjName.toString() + "<P>The following exception has been produced:<BR>" + e.toString() + "<P>", "464 Invalid Property Value");
                                return false;
                            }
                        }
                    } else {
                        attvalue = this.stringToObject(typeStr, valueStr);
                    }
                }
                if (attvalue == null) continue;
                if (ind.length() > 0) {
                    if (anArray == null) {
                        anArray = new ArrayList<Object>();
                    }
                    try {
                        indexValue = Integer.parseInt(ind);
                    }
                    catch (NumberFormatException e) {
                        if (this.logger.finestOn()) {
                            this.logger.finest("setObjectValue", "Exception = " + e);
                        }
                        this.buildError("Invalid Index value [" + ind + "] for property [" + propStr + "]<P>", "400 Bad Request");
                        return false;
                    }
                    anArray.add(indexValue, attvalue);
                    if (!this.logger.finerOn()) continue;
                    this.logger.finer("setObjectValue", "Add element " + indexValue + " to arrayList " + propStr + " type = " + attvalue.getClass().getName());
                    continue;
                }
                Attribute myAttr = new Attribute(propStr, attvalue);
                attlist.add(myAttr);
                indexValue = -1;
                if (!this.logger.finerOn()) continue;
                this.logger.finer("setObjectValue", "added [name=" + myAttr.getName() + ",value=" + myAttr.getValue() + ",type=" + typeStr + "] to list of attributes to set");
                continue;
            }
            if (!this.logger.finerOn()) continue;
            this.logger.finer("setObjectValue", "Got null value or property");
        }
        if (anArray != null) {
            attlist.add(new Attribute(propStr, this.getArray(typeStr, anArray)));
        }
        AttributeList resAttList = null;
        try {
            resAttList = this.mbs.setAttributes(this.manipulatedObjName, attlist);
            if (this.logger.finerOn()) {
                this.logger.finer("setObjectValue", "Invoked setAttributes() on " + this.manipulatedObjName + ". Checking result.");
            }
        }
        catch (InstanceNotFoundException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("setObjectValue", "Exception = " + e);
            }
            this.buildError("Setting of attributes has produced an exception <P>" + e.toString() + "<P>", "459 Instance Not Found");
            return false;
        }
        catch (ReflectionException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("setObjectValue", "Exception = " + e);
            }
            this.buildError("Setting of attributes has produced an exception <P>" + e.toString() + "<P>", "470 Reflection");
            return false;
        }
        catch (JMRuntimeException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("setObjectValue", "Exception = " + e);
            }
            this.buildError("The MBeanServer throws a JMRuntimeException when setting attributes for [" + safeObjNameStr + "] :<BR>" + e, "472 MBean Failure");
            return false;
        }
        if (attlist.size() != resAttList.size()) {
            if (this.logger.finerOn()) {
                this.logger.finer("setObjectValue", "Initial Number of attribute to set = " + attlist.size() + " and effectively set = " + resAttList.size());
            }
            int noset = attlist.size() - resAttList.size();
            String mess = noset + "/" + attlist.size() + " attribute(s) were not set:<BR><UL>";
            for (int k = attlist.size() - 1; k >= 0; --k) {
                int l;
                for (l = resAttList.size() - 1; l >= 0 && !((Attribute)attlist.get(k)).getName().equals(((Attribute)resAttList.get(l)).getName()); --l) {
                }
                if (l != -1) continue;
                mess = mess + "<LI>" + ((Attribute)attlist.get(k)).getName();
            }
            mess = mess + "</UL><HR>";
            this.buildError(mess, "477 All Attributes Not Set");
            return false;
        }
        return true;
    }

    public String getMeta() {
        return this.meta;
    }

    public void buildMeta(String objName) {
        String objNameStr = objName.substring(0, objName.indexOf("?"));
        try {
            this.autoRefresh = Integer.parseInt(objName.substring(objName.indexOf("period=") + 7));
        }
        catch (NumberFormatException e) {
            this.autoRefresh = 5;
        }
        if (this.autoRefresh == 0) {
            this.meta = " ";
        } else {
            if (this.autoRefresh < 5) {
                this.autoRefresh = 5;
            }
            this.meta = "<META HTTP-EQUIV=REFRESH CONTENT=\"";
            this.meta = this.meta + this.autoRefresh + "; URL=" + "/AutoRefresh" + objName + "\">";
        }
    }

    protected String enumToHtml(Enumerated o, MBeanAttributeInfo attrInfo) {
        boolean w;
        boolean r;
        String attrType;
        String attrName;
        block15: {
            if (attrInfo == null) {
                if (this.logger.finestOn()) {
                    this.logger.finest("enumToHtml", "Got null MBeanAttributeInfo parameter. Returning empty string");
                }
                return "";
            }
            attrName = attrInfo.getName();
            attrType = attrInfo.getType();
            r = attrInfo.isReadable();
            w = attrInfo.isWritable();
            if (o == null) {
                if (this.logger.finestOn()) {
                    this.logger.finest("enumToHtml", "Got null Enumerated object for [" + attrName + "]. attrInfo says [READ=" + r + ",WRITE=" + w + "]");
                }
                r = false;
                if (w) {
                    try {
                        Class cl = this.loadClass(attrType);
                        o = (Enumerated)cl.newInstance();
                    }
                    catch (Exception e) {
                        w = false;
                        if (!this.logger.finestOn()) break block15;
                        this.logger.finest("enumToHtml", "Could not create instance of [" + attrType + "] : " + e);
                    }
                }
            }
        }
        StringBuffer html = new StringBuffer(100);
        String ele = "";
        if (w) {
            html.append("<SELECT NAME=\"");
            html.append("(Enumerated)" + attrName + "+" + attrType + "\" >");
            if (!r) {
                html.append("<OPTION SELECTED>---");
            }
            Enumeration e = o.valueStrings();
            while (e.hasMoreElements()) {
                ele = (String)e.nextElement();
                html.append("<OPTION");
                if (r && o.toString() != null && o.toString().equals(ele)) {
                    html.append(" SELECTED ");
                }
                html.append(">" + ele);
            }
            html.append("</SELECT>");
        } else if (r) {
            html.append("Enumerated" + o.toString());
        } else if (this.logger.finestOn()) {
            this.logger.finest("enumToHtml", "Attribute is unreadable and unwritable. Returning empty string");
        }
        return html.toString();
    }

    @Override
    protected void inverseS(String[] a, int lo, int hi) {
        MBeanAttributeInfo ti = this.attinfo[lo];
        this.attinfo[lo] = this.attinfo[hi];
        this.attinfo[hi] = ti;
        String t = a[lo];
        a[lo] = a[hi];
        a[hi] = t;
    }

    private boolean analyseObj(String objNameStr) {
        int j;
        if (this.logger.finerOn()) {
            this.logger.finer("analyseObj", "Collect MBean information for = " + objNameStr);
        }
        String safeObjNameStr = this.translateNameToHtmlFormat(objNameStr);
        try {
            this.manipulatedObjName = this.getObjectNameByObjNameStr(objNameStr);
        }
        catch (MalformedObjectNameException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("analyseObj", "Exception = " + e);
            }
            this.buildError("The format of the string [" + safeObjNameStr + "] does not correspond to a valid ObjectName <P>" + e.toString() + "<P>", "474 Malformed ObjectName");
            return false;
        }
        if (this.manipulatedObjName != null) {
            try {
                this.manipulatedObj = this.mbs.getMBeanInfo(this.manipulatedObjName);
            }
            catch (InstanceNotFoundException e) {
                if (this.logger.finestOn()) {
                    this.logger.finest("analyseObj", "Exception = " + e);
                }
                this.buildError("Unable to get MBeanInfo for [" + safeObjNameStr + "]", "459 Instance Not Found");
                return false;
            }
            catch (IntrospectionException e) {
                if (this.logger.finestOn()) {
                    this.logger.finest("analyseObj", "Exception = " + e);
                }
                this.buildError("Unable to get MBeanInfo for [" + safeObjNameStr + "]", "476 Introspection");
                return false;
            }
            catch (ReflectionException e) {
                if (this.logger.finestOn()) {
                    this.logger.finest("analyseObj", "Exception = " + e);
                }
                this.buildError("Unable to get MBeanInfo for [" + safeObjNameStr + "]", "470 Reflection");
                return false;
            }
        }
        if (this.manipulatedObj == null) {
            this.buildError("Unable to get MBeanInfo for [" + this.manipulatedObjName + "]", "459 Instance Not Found");
            return false;
        }
        this.attinfo = this.checkedAttributeInfo(this.manipulatedObj.getAttributes());
        this.propertyName = new String[this.attinfo.length];
        this.propertyView = new String[this.attinfo.length];
        for (j = this.propertyName.length - 1; j >= 0; --j) {
            this.propertyName[j] = this.attinfo[j].getName();
        }
        this.quicksort(this.propertyName, 0, this.propertyName.length - 1);
        for (j = this.propertyName.length - 1; j >= 0; --j) {
            this.propertyView[j] = this.getStringValue(this.manipulatedObjName, this.attinfo[j]);
            if (!this.logger.finerOn()) continue;
            this.logger.finer("analyseObj", "MBean attribute: " + this.propertyName[j] + "=" + this.propertyView[j]);
        }
        return true;
    }

    private MBeanAttributeInfo[] checkedAttributeInfo(MBeanAttributeInfo[] orig) {
        if (orig == null) {
            return null;
        }
        MBeanAttributeInfo[] attr = new MBeanAttributeInfo[orig.length];
        for (int i = 0; i < attr.length; ++i) {
            attr[i] = orig[i] != null ? orig[i] : new MBeanAttributeInfo("null_MBeanAttributeInfo", null, "The attribute info at index[" + i + "] is null. Please" + " check the MBeanInfo.", true, false, false);
        }
        return attr;
    }

    private MBeanOperationInfo[] checkedOperationInfo(MBeanOperationInfo[] orig) {
        if (orig == null) {
            return null;
        }
        MBeanOperationInfo[] oper = new MBeanOperationInfo[orig.length];
        for (int i = 0; i < oper.length; ++i) {
            oper[i] = orig[i] != null ? orig[i] : new MBeanOperationInfo("null_MBeanOperationInfo", "The operation info at index[" + i + "] is null. Please" + " check the MBeanInfo.", null, null, 0);
        }
        return oper;
    }

    private void buildAttributes(String objNameStr) {
        String desc;
        if (this.logger.finerOn()) {
            this.logger.finer("buildAttributes", "Build attribute part for = " + objNameStr);
        }
        if ((desc = this.manipulatedObj.getDescription()) != null && desc.length() > 0) {
            this.add2Page("<HR><H3>MBean description:</H3><P>" + desc + "<P>");
        }
        this.add2Page("<HR><H3>List of MBean attributes:</H3>\r\n");
        if (this.logger.finerOn()) {
            this.logger.finer("buildAttributes", "Found " + this.attinfo.length + " attributes(s)");
        }
        if (this.attinfo.length == 0) {
            this.add2Page("<I>No Attributes</I><P>");
            return;
        }
        this.add2Page("<FORM ACTION=/SetForm" + this.toUrlName(objNameStr) + " METHOD=GET>");
        boolean hasInput = false;
        this.add2Page("<TABLE ALIGN=center BORDER=1 WIDTH=100% CELLPADDING=3>");
        this.add2Page("<TR>");
        this.add2Page("<TH WIDTH=23%> Name </TH><TH WIDTH=35%> Type </TH><TH WIDTH=7%> Access </TH><TH WIDTH=35%> Value </TH>");
        this.add2Page("</TR>");
        for (int i = 0; i < this.propertyName.length; ++i) {
            if (this.propertyName[i] == null) continue;
            String attType = this.usualType(this.attinfo[i].getType());
            this.add2Page("<TR>");
            String ai = this.attinfo[i].getDescription();
            if (ai != null && ai.length() > 0) {
                this.add2Page("<TD><A HREF=\"javascript:alert('" + this.translateNameToHtmlFormat(ai) + "');\"><B>" + this.propertyName[i] + "</B></A></TD>");
            } else {
                this.add2Page("<TD><B>" + this.propertyName[i] + "</B></TD>");
            }
            this.add2Page("<TD ALIGN=RIGHT>" + attType + "</TD>");
            if (this.attinfo[i].isReadable() && !this.attinfo[i].isWritable()) {
                this.add2Page("<TD ALIGN=center> RO </TD>");
                if (this.propertyView[i].startsWith("Enumerated")) {
                    this.add2Page("<TD>" + this.propertyView[i].substring(10) + "</TD>");
                } else if (this.propertyView[i].startsWith("<FONT color=red>UNAVAILABLE</FONT>")) {
                    this.add2Page("<TD>" + this.propertyView[i] + "</TD>");
                } else if (attType != null && attType.equals("javax.management.ObjectName")) {
                    this.add2Page("<TD><A HREF=\"/ViewObjectRes" + this.toUrlName(this.propertyView[i]) + "\">" + this.propertyView[i] + "</A></TD>");
                } else if (this.isArrayType(attType)) {
                    this.add2Page(this.buildArrayRef(this.propertyName[i], objNameStr, "view the values of " + this.propertyName[i]));
                } else if (!this.checkType(attType)) {
                    this.add2Page("<TD><I>Type Not Supported</I>: [" + this.translateNameToHtmlFormat(this.propertyView[i]) + "]</TD>");
                } else {
                    this.add2Page("<TD><PRE>" + this.translateNameToHtmlFormat(this.propertyView[i]) + "</PRE></TD>");
                }
            } else if (!this.attinfo[i].isReadable() && this.attinfo[i].isWritable()) {
                hasInput = true;
                this.add2Page("<TD ALIGN=center> WO </TD>");
                if (this.propertyView[i].startsWith("<SELECT NAME=\"(Enumerated)")) {
                    this.add2Page("<TD>" + this.propertyView[i] + "</TD>");
                } else if (!this.checkType(attType)) {
                    this.add2Page("<TD><I>Type Not Supported</I></TD>");
                } else if (attType.endsWith("Boolean") || attType.endsWith("boolean")) {
                    this.add2Page("<TD>" + this.boolToHtml(this.propertyName[i], attType, this.propertyView[i], false) + "</TD>");
                } else if (this.isArrayType(attType)) {
                    if (!this.checkType(attType)) {
                        this.propertyView[i] = "Write only for " + this.propertyName[i] + "[] Not supported ";
                    }
                    this.add2Page("<TD>" + this.propertyView[i] + "</TD>");
                } else {
                    this.add2Page("<TD><INPUT TYPE=\"text\" NAME=\"" + this.propertyName[i] + "+" + attType + "\" SIZE=34%></TD>");
                }
            } else if (this.attinfo[i].isReadable() && this.attinfo[i].isWritable()) {
                hasInput = true;
                this.add2Page("<TD ALIGN=center> RW </TD>");
                if (this.propertyView[i].startsWith("<SELECT NAME=\"(Enumerated)")) {
                    this.add2Page("<TD>" + this.propertyView[i] + "</TD>");
                } else if (this.propertyView[i].startsWith("<FONT color=red>UNAVAILABLE</FONT>")) {
                    this.add2Page("<TD>" + this.propertyView[i] + "</TD>");
                } else if (!this.checkType(attType)) {
                    this.add2Page("<TD><I>Type Not Supported</I>: [" + this.translateNameToHtmlFormat(this.propertyView[i]) + "]</TD>");
                } else if (this.propertyView[i].startsWith("<SELECT NAME=\"(Enumerated)")) {
                    this.add2Page("<TD>" + this.propertyView[i] + "</TD>");
                } else if (attType.endsWith("Boolean") || attType.endsWith("boolean")) {
                    this.add2Page("<TD>" + this.boolToHtml(this.propertyName[i], attType, this.propertyView[i], true) + "</TD>");
                } else if (this.isArrayType(attType)) {
                    this.add2Page(this.buildArrayRef(this.propertyName[i], objNameStr, "view the values of " + this.propertyName[i]));
                } else {
                    this.htmlPage.append("<TD><INPUT TYPE=\"text\" NAME=\"" + this.propertyName[i] + "+" + attType + "\" ");
                    this.htmlPage.append("VALUE=\"" + this.translateNameToHtmlFormat(this.propertyView[i]) + "\" ");
                    this.htmlPage.append("SIZE=34%");
                    this.add2Page(">");
                    if (attType.equals("javax.management.ObjectName")) {
                        if (this.propertyView[i].equals(" ") || this.propertyView[i].equals("")) {
                            this.htmlPage.append("<A HREF=\"/ViewObjectRes" + this.toUrlName(this.propertyView[i]) + "\"></A>");
                        } else {
                            this.htmlPage.append("<A HREF=\"/ViewObjectRes" + this.toUrlName(this.propertyView[i]) + "\">view</A>");
                        }
                    }
                    this.add2Page("</TD>");
                }
            } else {
                this.add2Page("<TD> ?? </TD>");
                this.add2Page("<TD>" + this.propertyView[i] + "</TD>");
            }
            this.add2Page("</TR>");
        }
        this.add2Page("</TABLE>");
        this.add2Page("<P>");
        this.add2Page("<TABLE WIDTH=100%><TR>");
        if (hasInput) {
            this.add2Page("<TD ALIGN=LEFT><INPUT TYPE=submit VALUE=\"Apply\"></TD>");
        } else {
            this.add2Page("<TD ALIGN=LEFT></TD>");
        }
        this.add2Page("</TR></TABLE></FORM>");
    }

    private void buildOperations() {
        if (this.logger.finerOn()) {
            this.logger.finer("buildOperations", "Build operations part");
        }
        String actionStr = null;
        String ai = null;
        MBeanOperationInfo[] op = this.checkedOperationInfo(this.manipulatedObj.getOperations());
        this.add2Page("<HR><H3>List of MBean operations:</H3>\r\n");
        if (this.logger.finerOn()) {
            this.logger.finer("buildOperations", "Found " + op.length + " operation(s)");
        }
        if (op.length == 0) {
            this.add2Page("<I>No Operations</I><P>");
            return;
        }
        for (int i = op.length - 1; i >= 0; --i) {
            ai = op[i].getDescription();
            actionStr = this.buildOperationWithParam(op[i].getReturnType(), op[i].getName(), op[i].getSignature());
            if (actionStr == null) continue;
            if (ai != null && ai.length() > 0) {
                this.add2Page("<HR><A HREF=\"javascript:alert('" + this.translateNameToHtmlFormat(ai) + "');\"><B>Description of " + op[i].getName() + "</B></A>");
            } else {
                this.add2Page("<HR><B>" + op[i].getName() + "</B>");
            }
            this.add2Page(actionStr);
        }
    }

    private String buildOperationWithParam(String returnType, String action, MBeanParameterInfo[] paramList) {
        int i;
        if (this.logger.finerOn()) {
            this.logger.finer("buildOperationWithParam", "Build operation for = " + action);
        }
        boolean support = true;
        String propType = null;
        String param = null;
        StringBuffer str = new StringBuffer(50);
        int max = paramList.length;
        for (i = 0; i < max; ++i) {
            propType = paramList[i].getType();
            if (propType != null && this.checkType(propType) && !this.isArrayType(propType)) continue;
            support = false;
            break;
        }
        if (!support) {
            str.append("  <I>(Operation Not Supported)</I><P>");
        }
        if (support) {
            str.append("<FORM ACTION=/InvokeAction" + this.toUrlName(this.manipulatedObjName.toString()) + "/action=" + action);
            str.append(" METHOD=GET>\r\n");
        }
        str.append("<TABLE>\r\n");
        str.append("<TR><TD>" + returnType + "</TD>" + "\r\n");
        if (!support) {
            str.append("<TD>" + action + "</TD>" + "\r\n");
        } else {
            str.append("<TD><INPUT TYPE=SUBMIT NAME=\"action\" VALUE=\"" + action + "\"></TD>" + "\r\n");
        }
        for (i = 0; i < max; ++i) {
            String ai;
            propType = paramList[i].getType();
            param = paramList[i].getName() != null && paramList[i].getName().length() > 0 ? paramList[i].getName() : "param" + i;
            if (i != 0) {
                str.append("<TD></TD>");
            }
            if ((ai = paramList[i].getDescription()) != null && ai.length() > 0) {
                str.append("<TD>(" + propType + ")<A HREF=\"javascript:alert('" + this.translateNameToHtmlFormat(ai) + "');\">" + param + "</A></TD>" + "\r\n");
            } else {
                str.append("<TD>(" + propType + ")" + param + "</TD>" + "\r\n");
            }
            if (!support) {
                str.append("<TD></TD>\r\n");
            } else if (propType.endsWith("Boolean") || propType.endsWith("boolean")) {
                str.append("<TD>" + this.boolToHtml(param, propType, "true", true) + "</TD>" + "\r\n");
            } else {
                str.append("<TD><INPUT TYPE=\"text\" NAME=\"" + param + "+" + propType + "\" ");
                str.append("SIZE=50%");
                str.append("></TD>\r\n");
            }
            str.append("</TR><TR><TD></TD>\r\n");
        }
        str.append("</TR></TABLE>\r\n");
        if (support) {
            str.append("</FORM>\r\n");
        }
        return str.toString();
    }

    private String buildArrayRef(String name, String objName, String value) {
        return new String("<TD> <A HREF=\"/ViewProperty/" + name + this.toUrlName(objName) + "\">" + value + "</A> </TD>");
    }

    private String getStringValue(ObjectName o, MBeanAttributeInfo attrInfo) {
        Object result;
        block14: {
            result = null;
            boolean r = attrInfo.isReadable();
            boolean w = attrInfo.isWritable();
            try {
                if (this.logger.finerOn()) {
                    this.logger.finer("getStringValue", "Build displayable value for attribute [" + attrInfo.getName() + "] of object [" + o.toString() + "]");
                }
                if (r) {
                    result = this.mbs.getAttribute(o, attrInfo.getName());
                }
            }
            catch (Exception e) {
                Exception ee = null;
                if (e instanceof RuntimeMBeanException) {
                    ee = ((RuntimeMBeanException)e).getTargetException();
                } else if (e instanceof MBeanException) {
                    ee = ((MBeanException)e).getTargetException();
                }
                if (this.logger.finestOn()) {
                    this.logger.finest("getStringValue", "Cannot get value: " + e + " [wrapped exception: " + ee + "]");
                }
                if (ee == null) {
                    return "<FONT color=red>UNAVAILABLE</FONT>: [" + e.toString() + "]";
                }
                return "<FONT color=red>UNAVAILABLE</FONT>: " + e.getClass().getName() + " wraps [" + ee.toString() + "]";
            }
            if (result instanceof Date) {
                DateFormat df = DateFormat.getDateTimeInstance(1, 1);
                df.setTimeZone(TimeZone.getDefault());
                return df.format((Date)result);
            }
            try {
                Class c = result != null ? result.getClass() : this.loadClass(attrInfo.getType());
                Class sc = c.getSuperclass();
                if (sc != null && Enumerated.class.isAssignableFrom(sc)) {
                    return this.enumToHtml((Enumerated)result, attrInfo);
                }
            }
            catch (ClassNotFoundException e) {
                if (!this.logger.finestOn()) break block14;
                this.logger.finest("getStringValue", "Cannot find class " + attrInfo.getType() + ":" + e);
            }
        }
        if (result == null) {
            return "";
        }
        return result.toString();
    }

    private Object stringToObject(String typeStr, String valueStr) {
        Object value;
        block26: {
            value = null;
            try {
                if (typeStr.endsWith("String")) {
                    value = valueStr;
                    break block26;
                }
                if (typeStr.endsWith("Byte") || typeStr.endsWith("byte")) {
                    value = new Byte(valueStr);
                    break block26;
                }
                if (typeStr.endsWith("Long") || typeStr.endsWith("long")) {
                    value = new Long(valueStr);
                    break block26;
                }
                if (typeStr.endsWith("Integer") || typeStr.endsWith("int")) {
                    value = new Integer(valueStr);
                    break block26;
                }
                if (typeStr.endsWith("Date")) {
                    try {
                        DateFormat df = DateFormat.getDateTimeInstance(1, 1);
                        df.setTimeZone(TimeZone.getDefault());
                        value = df.parse(valueStr);
                        break block26;
                    }
                    catch (ParseException e) {
                        this.buildError("Cannot convert String \"" + valueStr + "\" to " + typeStr + ".<P>", "400 Bad Request");
                        return null;
                    }
                }
                if (typeStr.endsWith("Boolean") || typeStr.endsWith("boolean")) {
                    value = new Boolean(valueStr);
                    break block26;
                }
                if (typeStr.endsWith("Number")) {
                    try {
                        value = new Integer(valueStr);
                        break block26;
                    }
                    catch (NumberFormatException e1) {
                        try {
                            value = new Long(valueStr);
                            break block26;
                        }
                        catch (NumberFormatException e2) {
                            try {
                                value = new Float(valueStr);
                                break block26;
                            }
                            catch (NumberFormatException e3) {
                                try {
                                    value = new Double(valueStr);
                                    break block26;
                                }
                                catch (NumberFormatException e4) {
                                    this.buildError("Cannot convert String \"" + valueStr + "\" to " + typeStr + ".<P>", "400 Bad Request");
                                    return null;
                                }
                            }
                        }
                    }
                }
                if (typeStr.equals("javax.management.ObjectName")) {
                    try {
                        value = new ObjectName(valueStr);
                        break block26;
                    }
                    catch (MalformedObjectNameException e) {
                        this.buildError("Cannot convert String \"" + valueStr + "\" to " + typeStr + ".<P>", "474 Malformed ObjectName");
                        return null;
                    }
                }
                if (typeStr.endsWith("Character") || typeStr.endsWith("char")) {
                    value = new Character(valueStr.charAt(0));
                    break block26;
                }
                if (typeStr.endsWith("Double") || typeStr.endsWith("double")) {
                    value = new Double(valueStr);
                    break block26;
                }
                if (typeStr.endsWith("Float") || typeStr.endsWith("float")) {
                    value = new Float(valueStr);
                    break block26;
                }
                if (typeStr.endsWith("Short") || typeStr.endsWith("short")) {
                    value = new Short(valueStr);
                    break block26;
                }
                this.buildError("Cannot convert the String \"" + valueStr + "\" to " + typeStr, "464 Invalid Property Value");
                return null;
            }
            catch (NumberFormatException e) {
                this.buildError("Cannot convert the String \"" + valueStr + "\" to " + typeStr + ".<P>", "400 Bad Request");
                return null;
            }
        }
        return value;
    }

    private Object getArray(String typeStr, ArrayList a) {
        Object[] value = null;
        int l = a.size();
        if (typeStr.endsWith("String")) {
            value = a.toArray(new String[l]);
        } else if (typeStr.endsWith("Byte")) {
            value = a.toArray(new Byte[l]);
        } else if (typeStr.endsWith("byte")) {
            value = new byte[l];
            for (int i = l - 1; i >= 0; --i) {
                ((byte[])value)[i] = (Byte)a.get(i);
            }
        } else if (typeStr.endsWith("Long")) {
            value = a.toArray(new Long[l]);
        } else if (typeStr.endsWith("long")) {
            value = new long[l];
            for (int i = l - 1; i >= 0; --i) {
                ((long[])value)[i] = (Long)a.get(i);
            }
        } else if (typeStr.endsWith("Integer")) {
            value = a.toArray(new Integer[l]);
        } else if (typeStr.endsWith("int")) {
            value = new int[l];
            for (int i = l - 1; i >= 0; --i) {
                ((int[])value)[i] = (Integer)a.get(i);
            }
        } else if (typeStr.endsWith("Date")) {
            value = a.toArray(new Date[l]);
        } else if (typeStr.endsWith("Boolean")) {
            value = a.toArray(new Boolean[l]);
        } else if (typeStr.endsWith("boolean")) {
            value = new boolean[l];
            for (int i = l - 1; i >= 0; --i) {
                ((boolean[])value)[i] = (Boolean)a.get(i);
            }
        } else if (typeStr.equals("javax.management.ObjectName")) {
            value = a.toArray(new ObjectName[l]);
        } else if (typeStr.equals("Character")) {
            value = a.toArray(new Character[l]);
        } else if (typeStr.equals("char")) {
            value = new char[l];
            for (int i = l - 1; i >= 0; --i) {
                ((char[])value)[i] = ((Character)a.get(i)).charValue();
            }
        } else if (typeStr.equals("Double")) {
            value = a.toArray(new Double[l]);
        } else if (typeStr.equals("double")) {
            value = new double[l];
            for (int i = l - 1; i >= 0; --i) {
                ((double[])value)[i] = (Double)a.get(i);
            }
        } else if (typeStr.equals("Float")) {
            value = a.toArray(new Float[l]);
        } else if (typeStr.equals("float")) {
            value = new float[l];
            for (int i = l - 1; i >= 0; --i) {
                ((float[])value)[i] = ((Float)a.get(i)).floatValue();
            }
        } else {
            return null;
        }
        return value;
    }

    private Class loadClass(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            ClassLoaderRepository clr = MBeanServerFactory.getClassLoaderRepository(this.mbs);
            if (clr == null) {
                throw new ClassNotFoundException(className);
            }
            return clr.loadClass(className);
        }
    }
}

