/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.GenericHttpConnectorAddress;
import com.sun.jdmk.comm.GenericHttpConnectorServer;
import com.sun.jdmk.comm.GenericHttpNotificationForwarder;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HttpConnectorServerMBean;
import com.sun.jdmk.comm.HttpNotificationForwarder;
import com.sun.jdmk.comm.HttpSocket;
import java.net.InetAddress;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class HttpConnectorServer
extends GenericHttpConnectorServer
implements HttpConnectorServerMBean {
    private int timeout = 60000;

    public HttpConnectorServer() {
        super(2, 8081);
    }

    public HttpConnectorServer(int port) {
        super(2, port);
    }

    public HttpConnectorServer(int port, AuthInfo[] authInfoList) {
        super(2, port, authInfoList);
    }

    public HttpConnectorServer(int port, InetAddress bindAddr) {
        super(2, port, bindAddr);
    }

    public HttpConnectorServer(int port, AuthInfo[] authInfoList, InetAddress bindAddr) {
        super(2, port, authInfoList, bindAddr);
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (name == null) {
            name = new ObjectName(server.getDefaultDomain() + ":" + "name=HttpConnectorServer");
        }
        return super.preRegister(server, name);
    }

    @Override
    GenericHttpSocket createSocket() {
        HttpSocket http_socket = new HttpSocket();
        http_socket.setTimeout(this.getTimeout());
        return http_socket;
    }

    @Override
    GenericHttpNotificationForwarder getNotificationForwarder(GenericHttpConnectorAddress address) {
        return new HttpNotificationForwarder(address);
    }

    @Override
    public String getProtocol() {
        return "http";
    }

    @Override
    public int getTimeout() {
        if (this.sockListen != null) {
            return this.sockListen.getTimeout();
        }
        return this.timeout;
    }

    @Override
    public void setTimeout(int value) throws IllegalStateException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException("Stop server before carrying out this operation");
        }
        this.timeout = value;
        if (this.sockListen != null) {
            this.sockListen.setTimeout(value);
        }
    }

    @Override
    String makeDebugTag() {
        return "HttpConnectorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }
}

