/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.HttpBody;
import com.sun.jdmk.comm.HttpMessage;
import com.sun.jdmk.comm.MalformedHttpException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class HttpRequest
extends HttpMessage {
    public int method = 0;
    public String requestURI = null;
    public static final int METHOD_GET = 1;
    public static final int METHOD_POST = 2;
    static final String MALFORMED_REQUEST_LINE = "Malformed request line";
    static final String MALFORMED_HEADER_LINE = "Malformed header line";
    static final String UNSUPPORTED_METHOD = "Unsupported HTTP method";
    static final String PREFIX_AUTHORIZATION = "Authorization: ";

    public HttpRequest(HttpBody body) {
        super(body);
    }

    public String getURIPath() {
        return this.requestURI;
    }

    @Override
    public void readFrom(InputStream s) throws IOException, MalformedHttpException {
        String headerLine;
        String requestLine;
        this.method = 0;
        this.requestURI = null;
        this.httpVersion = null;
        while ((requestLine = HttpRequest.readLine(s)).length() == 0) {
        }
        int space1Index = requestLine.indexOf(32);
        int space2Index = requestLine.indexOf(32, space1Index + 1);
        if (space1Index == -1 || space2Index == -1) {
            throw new MalformedHttpException(MALFORMED_REQUEST_LINE);
        }
        String methodStr = requestLine.substring(0, space1Index);
        if (methodStr.equals("GET")) {
            this.method = 1;
        } else if (methodStr.equals("POST")) {
            this.method = 2;
        } else {
            throw new MalformedHttpException(UNSUPPORTED_METHOD);
        }
        this.requestURI = requestLine.substring(space1Index + 1, space2Index);
        this.httpVersion = requestLine.substring(space2Index + 1);
        if (this.requestURI.length() == 0 || this.httpVersion.length() == 0) {
            throw new MalformedHttpException(MALFORMED_REQUEST_LINE);
        }
        block3: while ((headerLine = HttpRequest.readLine(s)).length() != 0) {
            int colon = headerLine.indexOf(58);
            if (colon < 0) {
                throw new MalformedHttpException(MALFORMED_HEADER_LINE);
            }
            String header = headerLine.substring(0, colon);
            for (int i = 0; i < KNOWN_HEADERS.length; ++i) {
                if (!header.equalsIgnoreCase(KNOWN_HEADERS[i])) continue;
                this.setHeader(i, headerLine.substring(colon + 1).trim());
                continue block3;
            }
        }
        String contentLengthString = this.getHeader(0);
        if (contentLengthString != null) {
            int contentLength;
            try {
                contentLength = Integer.parseInt(contentLengthString);
            }
            catch (NumberFormatException e) {
                throw new MalformedHttpException(e.toString());
            }
            if (contentLength > 0) {
                this.readBodyFrom(s, contentLength);
            }
        }
    }

    @Override
    public void writeTo(OutputStream s) throws IOException {
        String methodString;
        switch (this.method) {
            case 1: {
                methodString = "GET";
                break;
            }
            case 2: {
                methodString = "POST";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported method " + this.method);
            }
        }
        String firstLine = methodString + " " + this.requestURI + " " + this.httpVersion;
        this.writeHeadersAndBodyTo(s, firstLine);
    }

    static String readLine(InputStream s) throws IOException {
        StringBuffer result = new StringBuffer();
        int prevCh = s.read();
        int ch = s.read();
        while (ch != -1 && (prevCh != 13 || ch != 10)) {
            result.append((char)prevCh);
            prevCh = ch;
            ch = s.read();
        }
        if (ch == -1) {
            throw new EOFException();
        }
        return result.toString();
    }
}

