/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.CommunicatorServer;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.HeartBeatServerHandler;
import com.sun.jdmk.comm.NotificationBackConnector;
import com.sun.jdmk.comm.RmiConnectorAddress;
import com.sun.jdmk.comm.RmiConnectorServerMBean;
import com.sun.jdmk.comm.RmiConnectorServerObjectImpl;
import com.sun.jdmk.comm.RmiConnectorServerObjectImplV2;
import com.sun.jdmk.comm.RmiNotificationForwarder;
import com.sun.jdmk.comm.ServerNotificationDispatcher;
import com.sun.jdmk.comm.ServerNotificationHandlerInternal;
import java.rmi.RemoteException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class RmiConnectorServer
extends CommunicatorServer
implements MBeanRegistration,
RmiConnectorServerMBean {
    private static int defaultPort = 1099;
    private static final String defaultServiceName = "name=RmiConnectorServer";
    private String serviceName = null;
    private transient RmiConnectorServerObjectImpl rmiConnectorV1;
    private transient RmiConnectorServerObjectImplV2 rmiConnectorV2;
    private ServerNotificationDispatcher serverNotificationDispatcher = null;
    private RmiNotificationForwarder rmiNotificationForwarder = null;
    private HeartBeatServerHandler heartbeatServerHandler = null;

    public RmiConnectorServer() {
        this(defaultPort, defaultServiceName);
    }

    public RmiConnectorServer(int port) {
        this(port, defaultServiceName);
    }

    public RmiConnectorServer(String serviceName) {
        this(defaultPort, serviceName);
    }

    public RmiConnectorServer(int port, String serviceName) {
        super(1);
        this.port = port;
        this.serviceName = serviceName;
    }

    static String serviceNameForVersion(String serviceName, int version) {
        switch (version) {
            case 1: {
                return serviceName;
            }
            case 2: {
                return serviceName + "V2";
            }
        }
        throw new IllegalArgumentException("serviceNameForVersion" + version);
    }

    NotificationBackConnector startPush(ConnectorAddress addr) {
        if (!(addr instanceof RmiConnectorAddress)) {
            throw new IllegalArgumentException("Expected RmiConnectorAddress class, got " + addr.getClass().getName());
        }
        try {
            RmiNotificationForwarder rmiNotificationForwarder = new RmiNotificationForwarder((RmiConnectorAddress)addr, this);
            return rmiNotificationForwarder;
        }
        catch (IllegalAccessException e) {
            throw new CommunicationException(e);
        }
        catch (RemoteException e) {
            throw new CommunicationException(e);
        }
    }

    void stopPush(NotificationBackConnector connector) {
        if (connector instanceof RmiNotificationForwarder) {
            ((RmiNotificationForwarder)connector).disconnect();
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        Object propertyValue = null;
        if (name == null) {
            name = new ObjectName(server.getDefaultDomain() + ":" + defaultServiceName);
        }
        super.preRegister(server, name);
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        super.postRegister(registrationDone);
        NotificationHandlerInternal handler = new NotificationHandlerInternal(this);
        this.serverNotificationDispatcher = new ServerNotificationDispatcher(handler, this.topMBS);
        this.heartbeatServerHandler = new HeartBeatServerHandler(this.topMBS, this.serverNotificationDispatcher);
    }

    @Override
    public void preDeregister() throws Exception {
        super.preDeregister();
    }

    @Override
    public void postDeregister() {
        super.postDeregister();
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public void setServiceName(String serviceName) throws IllegalStateException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException("Stop server before carrying out this operation");
        }
        this.serviceName = serviceName;
        this.dbgTag = this.makeDebugTag();
    }

    @Override
    public String getProtocol() {
        return "rmi";
    }

    @Override
    public void stop() {
        if (this.state == 0 || this.state == 3) {
            super.stop();
            this.heartbeatServerHandler.cleanupClientResources();
        }
    }

    @Override
    public synchronized void setMBeanServer(MBeanServer newMBS) throws IllegalArgumentException, IllegalStateException {
        super.setMBeanServer(newMBS);
        this.serverNotificationDispatcher.setMBeanServer(newMBS);
    }

    @Override
    protected void doError(Exception e) throws CommunicationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void doBind() throws CommunicationException, InterruptedException {
        try {
            if (this.rmiConnectorV1 == null) {
                if (this.logger.finerOn()) {
                    this.logger.finer("doBind", "Create the RMI object server");
                }
                if (this.logger.finestOn()) {
                    this.logger.finest("doBind", "serviceName=" + this.serviceName + " ; port=" + this.port);
                }
                String v1name = RmiConnectorServer.serviceNameForVersion(this.serviceName, 1);
                String v2name = RmiConnectorServer.serviceNameForVersion(this.serviceName, 2);
                this.rmiConnectorV2 = new RmiConnectorServerObjectImplV2(this, v2name, this.port, this.serverNotificationDispatcher, this.heartbeatServerHandler);
                this.rmiConnectorV1 = new RmiConnectorServerObjectImpl(this.rmiConnectorV2, v1name, this.port, this.serverNotificationDispatcher, this.heartbeatServerHandler);
            }
            try {
                this.rmiConnectorV2.bind();
            }
            finally {
                this.rmiConnectorV1.bind();
            }
            if (this.logger.finerOn()) {
                this.logger.finer("doBind", "Bind RMI object server");
            }
        }
        catch (RemoteException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("doBind", "Got Exception: " + e.getMessage());
            }
            throw new CommunicationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doReceive() throws CommunicationException, InterruptedException {
        while (true) {
            try {
                while (true) {
                    Object sync;
                    Object object = sync = new Object();
                    synchronized (object) {
                        sync.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    @Override
    protected void doProcess() throws CommunicationException, InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doUnbind() throws CommunicationException, InterruptedException {
        if (this.logger.finerOn()) {
            this.logger.finer("doUnbind", "Unbind RMI object server");
        }
        try {
            this.rmiConnectorV1.unbind();
        }
        finally {
            this.rmiConnectorV2.unbind();
        }
    }

    @Override
    protected String makeDebugTag() {
        return "RmiConnectorServer[" + this.getProtocol() + ":" + this.getPort() + ":" + this.getServiceName() + "]";
    }

    private class NotificationHandlerInternal
    implements ServerNotificationHandlerInternal {
        private RmiConnectorServer connector;

        public NotificationHandlerInternal(RmiConnectorServer connector) {
            this.connector = connector;
        }

        @Override
        public NotificationBackConnector startPush(ConnectorAddress addr) {
            return this.connector.startPush(addr);
        }

        @Override
        public void stopPush(NotificationBackConnector connector) {
            this.connector.stopPush(connector);
        }
    }
}

