/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.NotificationBackConnector;
import com.sun.jdmk.comm.RemoteNotification;
import com.sun.jdmk.comm.RmiConnectorAddressV2;
import com.sun.jdmk.comm.ServerNotificationHandlerInternal;
import com.sun.jdmk.internal.ClassLogger;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

class ServerNotificationDispatcher {
    public static final int NEW_CLIENT = 0;
    public static final int REMOTE_TERMINATE = 1;
    public static final int REGISTER_TO_MBEAN = 2;
    public static final int UNREGISTER_FROM_MBEAN = 3;
    public static final int GET_NOTIFICATIONS = 4;
    public static final int CLEAR_NOTIFICATIONS = 5;
    public static final int SET_PUSH_MODE = 6;
    public static final int SET_OVERFLOW_MODE = 7;
    public static final int GET_OVERFLOW_MODE = 8;
    public static final int SET_CACHE_SIZE = 9;
    public static final int GET_CACHE_SIZE = 10;
    public static final int SET_OVERFLOW_COUNT = 11;
    public static final int GET_OVERFLOW_COUNT = 12;
    public static final int GET_NOTIF_SERVER_VERSION = 13;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.notification", "ServerNotificationDispatcher");
    private static final ClassLogger ciLogger = new ClassLogger("com.sun.jdmk.notification", "ClientInfo");
    private static final ClassLogger rliLogger = new ClassLogger("com.sun.jdmk.notification", "RemoteListenerInfo");
    private MBeanServer mbServer;
    private ServerNotificationHandlerInternal connector;
    private PushNotification pushNotif;
    private HashMap clientList = new HashMap();
    private static long localCounter = 0L;
    private boolean isTerminated = false;
    private static final Integer SERVER_VERSION = new Integer(2);

    public ServerNotificationDispatcher(ServerNotificationHandlerInternal connector, MBeanServer server) throws IllegalArgumentException {
        if (connector == null) {
            throw new IllegalArgumentException("It should specify a connector.");
        }
        if (server == null) {
            throw new IllegalArgumentException("It should specify a MBeanServer.");
        }
        this.connector = connector;
        this.mbServer = server;
        this.pushNotif = new PushNotification();
        if (logger.finerOn()) {
            logger.finer("Constructor", "create a ServerNotificationDispatcher object.");
        }
    }

    public Object[] remoteRequest(int opType, Object[] params) throws Exception {
        Object[] ret = null;
        switch (opType) {
            case 0: {
                ret = this.newClientNotificationDispatcher(params);
                break;
            }
            case 1: {
                ret = this.remoteTerminate((Long)params[0]);
                break;
            }
            case 2: {
                ret = this.registerToMBean((Long)params[0], (ObjectName)params[1], (NotificationFilter)params[2]);
                break;
            }
            case 3: {
                ret = this.unregisterFromMBean((Long)params[0], (Long)params[1]);
                break;
            }
            case 4: {
                ret = this.getNotifications((Long)params[0]);
                break;
            }
            case 5: {
                ret = this.clearNotifications(params);
                break;
            }
            case 6: {
                ret = this.setPushMode((Long)params[0], (Integer)params[1], (ConnectorAddress)params[2]);
                break;
            }
            case 7: {
                ret = this.setOverflowMode(params);
                break;
            }
            case 8: {
                ret = this.getOverflowMode(params);
                break;
            }
            case 9: {
                ret = this.setCacheSize(params);
                break;
            }
            case 10: {
                ret = this.getCacheSize(params);
                break;
            }
            case 11: {
                ret = this.setOverflowCount(params);
                break;
            }
            case 12: {
                ret = this.getOverflowCount(params);
                break;
            }
            case 13: {
                ret = new Object[]{SERVER_VERSION};
                break;
            }
            default: {
                throw new JMRuntimeException("The request is unknown.");
            }
        }
        return ret;
    }

    public void terminate() {
        if (logger.finerOn()) {
            logger.finer("terminate", "the object is being terminated.");
        }
        this.clientList.clear();
        this.isTerminated = true;
    }

    public void setMBeanServer(MBeanServer newMBS) {
        this.mbServer = newMBS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] newClientNotificationDispatcher(Object[] params) {
        this.isTerminated();
        Long id = ServerNotificationDispatcher.getID();
        if (logger.finerOn()) {
            logger.finer("newClientNotificationDispatcher", "New client is coming, its id is " + id);
        }
        HashMap hashMap = this.clientList;
        synchronized (hashMap) {
            this.clientList.put(id, new ClientInfo(id, (Integer)params[0], (Integer)params[1]));
        }
        Object[] ret = new Object[]{id};
        return ret;
    }

    protected Object[] remoteTerminate(Long id) {
        ClientInfo ci;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("newClientNotificationDispatcher", "A client is leaving, its id is " + id);
        }
        if ((ci = (ClientInfo)this.clientList.remove(id)) != null) {
            ci.terminate();
        }
        return new Object[0];
    }

    protected Object[] registerToMBean(Long id, ObjectName mbean, NotificationFilter filter) throws InstanceNotFoundException {
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("registerToMBean", "Add a remote listener from the client " + id + " to the mbean " + mbean.toString());
        }
        Object[] ret = new Object[1];
        ClientInfo ci = (ClientInfo)this.clientList.get(id);
        if (ci == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        ret[0] = ci.addListener(mbean, filter);
        return ret;
    }

    protected Object[] unregisterFromMBean(Long clientID, Long listenerID) throws InstanceNotFoundException, ListenerNotFoundException {
        ClientInfo ci;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("unregisterFromMBean", "Remove a remote listener " + listenerID + " from the client " + clientID);
        }
        if ((ci = (ClientInfo)this.clientList.get(clientID)) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        ci.removeListener(listenerID);
        return new Object[0];
    }

    protected RemoteNotification[] getNotifications(Long clientID) {
        ClientInfo ci;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("getNotifications", "Send back all saved notification to the client " + clientID);
        }
        if ((ci = (ClientInfo)this.clientList.get(clientID)) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        return ci.getAllNotifs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] clearNotifications(Object[] params) {
        ClientInfo ci;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("clearNotifications", "clear the notification cache.");
        }
        if ((ci = (ClientInfo)this.clientList.get((Long)params[0])) != null) {
            List list = ci.notifLog;
            synchronized (list) {
                ci.notifLog.clear();
            }
        }
        return new Object[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] setPushMode(Long id, Integer push, ConnectorAddress addr) {
        ClientInfo ci;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("setPushMode", "The client " + id + " asks to change push mode to " + push);
        }
        if ((ci = (ClientInfo)this.clientList.get(id)) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        ClientInfo clientInfo = ci;
        synchronized (clientInfo) {
            int p = push;
            if (ci.forwardMode != p) {
                if (p == 0) {
                    if (addr instanceof RmiConnectorAddressV2) {
                        Remote obj = ((RmiConnectorAddressV2)addr).getRemoteObj();
                        ci.backConnector = (NotificationBackConnector)obj;
                    } else {
                        ci.backConnector = this.connector.startPush(addr);
                    }
                    ci.forwardMode = 0;
                    this.pushNotif.newNotif(ci);
                } else if (p == 1) {
                    this.connector.stopPush(ci.backConnector);
                    ci.backConnector = null;
                }
                ci.forwardMode = p;
            }
        }
        return new Object[0];
    }

    protected Object[] setOverflowMode(Object[] params) {
        ClientInfo ci;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("setOverflowMode", "Set the overflow mode to " + (Integer)params[1] + " for the client " + (Long)params[0]);
        }
        if ((ci = (ClientInfo)this.clientList.get((Long)params[0])) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        ci.discard_mode = (Integer)params[1];
        return new Object[0];
    }

    protected Object[] getOverflowMode(Object[] params) {
        ClientInfo ci;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("getOverflowMode", "Get the overflow mode of the client " + (Long)params[0]);
        }
        if ((ci = (ClientInfo)this.clientList.get((Long)params[0])) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        Object[] ret = new Object[]{new Integer(ci.discard_mode)};
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] setCacheSize(Object[] params) {
        ClientInfo ci;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("setCacheSize", "Set the cache size of the client " + (Long)params[0]);
        }
        if ((ci = (ClientInfo)this.clientList.get((Long)params[0])) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        int newSize = (Integer)params[1];
        List list = ci.notifLog;
        synchronized (list) {
            if (ci.notifLog.size() > newSize) {
                if (((Boolean)params[2]).booleanValue()) {
                    ci.overflow_count += ci.notifLog.size() - newSize;
                    if (ci.discard_mode == 10) {
                        for (int i = 0; i < ci.notifLog.size() - newSize; ++i) {
                            ci.notifLog.remove(0);
                        }
                    } else if (ci.discard_mode == 11) {
                        for (int i = ci.notifLog.size() - 1; i >= newSize; --i) {
                            ci.notifLog.remove(i);
                        }
                    }
                    ci.cache_size = (Integer)params[1];
                }
            } else {
                ci.cache_size = (Integer)params[1];
            }
        }
        Object[] ret = new Object[]{new Integer(ci.cache_size)};
        return ret;
    }

    protected Object[] getCacheSize(Object[] params) {
        ClientInfo ci;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("getCacheSize", "Get the cache size of the client " + (Long)params[0]);
        }
        if ((ci = (ClientInfo)this.clientList.get((Long)params[0])) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        Object[] ret = new Object[]{new Integer(ci.cache_size)};
        return ret;
    }

    protected Object[] setOverflowCount(Object[] params) {
        ClientInfo ci;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("setOverflowCount", "Set the overflow count of the client " + (Long)params[0]);
        }
        if ((ci = (ClientInfo)this.clientList.get((Long)params[0])) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        ci.overflow_count = (Integer)params[1];
        return new Object[0];
    }

    protected Object[] getOverflowCount(Object[] params) {
        ClientInfo ci;
        this.isTerminated();
        if (logger.finerOn()) {
            logger.finer("getOverflowCount", "Get the overflow count of the client " + (Long)params[0]);
        }
        if ((ci = (ClientInfo)this.clientList.get((Long)params[0])) == null) {
            throw new JMRuntimeException("Do not know your client.");
        }
        Object[] ret = new Object[]{new Integer(ci.overflow_count)};
        return ret;
    }

    private void isTerminated() {
        if (this.isTerminated) {
            throw new JMRuntimeException("This ServerNotificationDispatcher object has been terminated and is waiting to be destroyed.");
        }
    }

    private static Long getID() {
        if (localCounter == Long.MAX_VALUE) {
            localCounter = 0L;
        }
        return new Long(localCounter++);
    }

    private class PushNotification {
        private List waitingClientList = Collections.synchronizedList(new ArrayList());
        private TaskThread taskThread = null;
        private boolean tobeTerminated = false;

        public synchronized void newNotif(ClientInfo ci) {
            if (!this.waitingClientList.contains(ci)) {
                this.waitingClientList.add(ci);
            }
            if (this.taskThread == null || !this.taskThread.isAlive()) {
                this.taskThread = new TaskThread();
                this.taskThread.start();
            }
        }

        public void terminate() {
            boolean tobeTerminated = true;
            this.taskThread = null;
        }

        private class TaskThread
        extends Thread {
            public TaskThread() {
                super("taskThread");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!PushNotification.this.tobeTerminated) {
                    ClientInfo ci = null;
                    List list = PushNotification.this.waitingClientList;
                    synchronized (list) {
                        if (PushNotification.this.waitingClientList.isEmpty()) {
                            break;
                        }
                        ci = (ClientInfo)PushNotification.this.waitingClientList.remove(0);
                    }
                    try {
                        Object[] params = ci.getAllNotifs();
                        ci.backConnector.remoteRequest(0, params);
                    }
                    catch (Exception e) {
                        if (!logger.finestOn()) continue;
                        logger.finest("TaskThread", "run", e);
                    }
                }
            }
        }
    }

    private class RemoteListenerInfo
    implements NotificationListener {
        public ObjectName mbean;
        public NotificationFilter filter;
        public Long listenerID;
        private ClientInfo client;

        public RemoteListenerInfo(ObjectName mbean, NotificationFilter filter, Long listenerID, ClientInfo client) {
            this.mbean = mbean;
            this.filter = filter;
            this.listenerID = listenerID;
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleNotification(Notification n, Object o) {
            if (rliLogger.finestOn()) {
                String info = "Receive a notification for remote listener " + this.listenerID + " of the client " + this.client.clientID;
                rliLogger.finest("handleNotification", info);
            }
            List list = this.client.notifLog;
            synchronized (list) {
                if (this.client.forwardMode == 1 && this.client.cache_size >= 0) {
                    if (this.client.notifLog.size() < this.client.cache_size) {
                        this.client.notifLog.add(new RemoteNotification(this.listenerID, n));
                    } else {
                        if (this.client.discard_mode == 10 && this.client.cache_size > 0) {
                            this.client.notifLog.remove(0);
                            this.client.notifLog.add(new RemoteNotification(this.listenerID, n));
                        }
                        ++this.client.overflow_count;
                    }
                } else {
                    this.client.notifLog.add(new RemoteNotification(this.listenerID, n));
                }
            }
            if (this.client.forwardMode == 0) {
                ServerNotificationDispatcher.this.pushNotif.newNotif(this.client);
            }
        }
    }

    private class ClientInfo {
        public Long clientID;
        public int forwardMode = 1;
        public NotificationBackConnector backConnector;
        public List notifLog = Collections.synchronizedList(new ArrayList());
        public int cache_size;
        public int discard_mode;
        public int overflow_count = 0;
        private HashMap rliList = new HashMap();

        public ClientInfo(Long id, int discardMode, int cacheSize) {
            this.clientID = id;
            this.discard_mode = discardMode;
            this.cache_size = cacheSize;
        }

        public Long addListener(ObjectName mbean, NotificationFilter filter) throws InstanceNotFoundException {
            Long id = ServerNotificationDispatcher.getID();
            RemoteListenerInfo rli = new RemoteListenerInfo(mbean, filter, id, this);
            ServerNotificationDispatcher.this.mbServer.addNotificationListener(mbean, rli, filter, null);
            this.rliList.put(id, rli);
            return id;
        }

        public synchronized void removeListener(Long id) throws InstanceNotFoundException, ListenerNotFoundException {
            RemoteListenerInfo rli = (RemoteListenerInfo)this.rliList.remove(id);
            if (rli == null) {
                throw new ListenerNotFoundException("The listener does not find.");
            }
            ServerNotificationDispatcher.this.mbServer.removeNotificationListener(rli.mbean, rli);
        }

        public synchronized RemoteNotification[] getAllNotifs() {
            ArrayList tmp = new ArrayList(this.notifLog.size());
            while (!this.notifLog.isEmpty()) {
                tmp.add(this.notifLog.remove(0));
            }
            RemoteNotification[] ret = new RemoteNotification[tmp.size()];
            tmp.toArray(ret);
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void terminate() {
            block9: {
                if (this.forwardMode == 0) {
                    try {
                        ServerNotificationDispatcher.this.connector.stopPush(this.backConnector);
                    }
                    catch (Exception e) {
                        if (!ciLogger.finestOn()) break block9;
                        ciLogger.finest("terminate", e);
                    }
                }
            }
            this.backConnector = null;
            HashMap hashMap = this.rliList;
            synchronized (hashMap) {
                for (RemoteListenerInfo rli : this.rliList.values()) {
                    try {
                        ServerNotificationDispatcher.this.mbServer.removeNotificationListener(rli.mbean, rli);
                    }
                    catch (Exception e) {
                        if (!ciLogger.finestOn()) continue;
                        ciLogger.finest("terminate", e);
                    }
                }
            }
            this.notifLog.clear();
            this.rliList.clear();
        }
    }
}

