/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.discovery.ActualMonitor;
import com.sun.jdmk.discovery.DiscoveryMonitorMBean;
import com.sun.jdmk.internal.ClassLogger;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import java.util.Vector;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;

public class DiscoveryMonitor
extends NotificationBroadcasterSupport
implements Serializable,
DiscoveryMonitorMBean,
MBeanRegistration {
    private static final long serialVersionUID = 4303049868337627283L;
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;
    public static final int STOPPING = 2;
    public static final int STARTING = 3;
    private String localClassName;
    private String dbgTag;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.discovery", "DiscoveryMonitor");
    private ObjectName monitorObjectName;
    private MBeanServer cmf;
    private static final String sccs_id = "@(#)DiscoveryMonitor.java 4.37 07/03/08 SMI";
    private static int defaultMulticastPort = 9000;
    private static String defaultMulticastGroup = "224.224.224.224";
    private int multicastPort;
    private String multicastGroup;
    private transient ActualMonitor monitor;
    private transient Thread monitorThread;
    private volatile transient int state;
    private transient Vector listeners;
    private static final String GROUP = "group";
    private static final String PORT = "port";
    private InetAddress usrInet;

    public DiscoveryMonitor() {
        this.dbgTag = this.localClassName = "com.sun.jdmk.discovery.DiscoveryMonitor";
        this.monitorObjectName = null;
        this.cmf = null;
        this.monitor = null;
        this.monitorThread = null;
        this.state = 1;
        this.listeners = new Vector();
        this.usrInet = null;
        this.multicastGroup = defaultMulticastGroup;
        this.multicastPort = defaultMulticastPort;
        if (logger.finerOn()) {
            logger.finer("constructor ", "Set group to '" + this.multicastGroup + "'");
            logger.finer("constructor ", "Set port  to '" + this.multicastPort + "'");
        }
    }

    public DiscoveryMonitor(String multicastGroup, int multicastPort) {
        this.dbgTag = this.localClassName = "com.sun.jdmk.discovery.DiscoveryMonitor";
        this.monitorObjectName = null;
        this.cmf = null;
        this.monitor = null;
        this.monitorThread = null;
        this.state = 1;
        this.listeners = new Vector();
        this.usrInet = null;
        this.multicastGroup = multicastGroup;
        this.multicastPort = multicastPort;
        if (logger.finerOn()) {
            logger.finer("constructor ", "Set group to '" + multicastGroup + "'");
            logger.finer("constructor ", "Set port  to '" + multicastPort + "'");
        }
    }

    public DiscoveryMonitor(String multicastGroup, int multicastPort, InetAddress inf) {
        this.dbgTag = this.localClassName = "com.sun.jdmk.discovery.DiscoveryMonitor";
        this.monitorObjectName = null;
        this.cmf = null;
        this.monitor = null;
        this.monitorThread = null;
        this.state = 1;
        this.listeners = new Vector();
        this.usrInet = null;
        this.multicastGroup = multicastGroup;
        this.multicastPort = multicastPort;
        this.usrInet = inf;
        if (logger.finerOn()) {
            logger.finer("constructor ", "Set group to '" + multicastGroup + "'");
            logger.finer("constructor ", "Set port  to '" + multicastPort + "'");
            logger.finer("constructor ", "Set interface  to '" + inf + "'");
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        String port;
        String grp;
        if (logger.finerOn()) {
            logger.finer("preRegister ", "object name   = " + name);
        }
        if ((grp = name.getKeyProperty(GROUP)) != null) {
            this.multicastGroup = grp;
        }
        if (logger.finerOn()) {
            logger.finer("preRegister ", "Set group to '" + this.multicastGroup + "'");
        }
        if ((port = name.getKeyProperty(PORT)) != null) {
            this.multicastPort = Integer.parseInt(port);
        }
        if (logger.finerOn()) {
            logger.finer("preRegister ", "Set Port  to '" + this.multicastPort + "'");
        }
        this.monitorObjectName = name;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (registrationDone == Boolean.FALSE) {
            return;
        }
    }

    @Override
    public void preDeregister() throws Exception {
        this.stop();
    }

    @Override
    public void postDeregister() {
        System.runFinalization();
    }

    @Override
    public void start() throws IOException {
        if (this.state == 1) {
            try {
                this.changeState(3);
                this.monitor = new ActualMonitor(this.multicastGroup, this.multicastPort, this);
                if (this.usrInet != null) {
                    this.monitor.setInterface(this.usrInet);
                    if (logger.finerOn()) {
                        logger.finer("start", "set to the interface " + this.usrInet);
                    }
                }
                this.monitorThread = this.cmf == null ? new Thread(this.monitor) : new Thread(this.monitor);
                this.monitorThread.setName("Multicast monitor");
            }
            catch (IOException e) {
                if (logger.finestOn()) {
                    logger.finest("start", e);
                }
                throw e;
            }
            catch (NullPointerException e) {
                if (logger.finestOn()) {
                    logger.finest("start ", e);
                }
                throw new IOException(e.getMessage());
            }
            this.monitorThread.start();
        } else if (logger.finerOn()) {
            logger.finer("start ", "not OFFLINE ");
        }
    }

    @Override
    public void stop() {
        if (this.state == 0) {
            this.changeState(2);
            this.monitor.stopMonitor();
        } else if (logger.finerOn()) {
            logger.finer("stop ", "not ONLINE");
        }
    }

    @Override
    public Integer getState() {
        return new Integer(this.state);
    }

    @Override
    public String getStateString() {
        String result = "UNKNOWN";
        switch (this.state) {
            case 0: {
                result = "ONLINE";
                break;
            }
            case 1: {
                result = "OFFLINE";
                break;
            }
            case 2: {
                result = "STOPPING";
                break;
            }
            case 3: {
                result = "STARTING";
            }
        }
        return result;
    }

    @Override
    public String getMulticastGroup() {
        return this.multicastGroup;
    }

    @Override
    public void setMulticastGroup(String multicastGroup) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.multicastGroup = multicastGroup;
    }

    @Override
    public int getMulticastPort() {
        return this.multicastPort;
    }

    @Override
    public void setMulticastPort(int multicastPort) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.multicastPort = multicastPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitState(int state, long timeout) {
        if (logger.finerOn()) {
            logger.finer("waitState", state + "(0on,1off,2st) TO=" + timeout + " ; current state = " + this.getStateString());
        }
        if (timeout < 0L) {
            return this.state == state;
        }
        boolean done = this.state == state;
        long currentTimeOut = -1L;
        Date endDate = new Date(new Date().getTime() + timeout);
        while (!done) {
            if (timeout != 0L && (currentTimeOut = endDate.getTime() - new Date().getTime()) <= 0L) {
                done = true;
                break;
            }
            try {
                DiscoveryMonitor discoveryMonitor = this;
                synchronized (discoveryMonitor) {
                    if (timeout == 0L) {
                        if (logger.finerOn()) {
                            logger.finer("waitState", "Start waiting infinite, current state = " + this.state);
                        }
                        boolean bl = done = this.state == state;
                        while (!done) {
                            done = this.state == state;
                            try {
                                this.wait(1000L);
                            }
                            catch (Exception e) {}
                        }
                    } else {
                        if (logger.finerOn()) {
                            logger.finer("waitState", "Start waiting " + currentTimeOut + " current state = " + this.state);
                        }
                        this.wait(currentTimeOut);
                    }
                }
                done = this.state == state;
            }
            catch (InterruptedException e) {
                done = this.state == state;
            }
        }
        if (logger.finerOn()) {
            logger.finer("waitState", "End, TO=" + currentTimeOut);
        }
        return this.state == state;
    }

    synchronized void changeState(int s) {
        if (this.state == s) {
            return;
        }
        int old = this.state;
        this.state = s;
        this.notifyAll();
    }
}

