/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.discovery.DiscoveryMsg;
import com.sun.jdmk.internal.ClassLogger;
import java.net.InetAddress;

class DiscoveryPDU
extends DiscoveryMsg {
    private static final long serialVersionUID = 8485362476672832834L;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.discovery", "DiscoveryPDU");
    private boolean objectRequired = false;
    private String objName = null;
    private boolean returnAddr = false;
    private InetAddress returnHost;
    private int returnPort;
    private int timeOut;

    public DiscoveryPDU() {
        this.localClassName = "com.sun.jdmk.discovery.DiscoveryPDU";
    }

    @Override
    public String printState() {
        String state = new String();
        state = state + "(TimeStamp=" + this.getTimeStamp() + ")";
        state = state + "(Ttl=" + this.getTimeToLive() + ")";
        state = this.getReturnAddr() ? state + "(Point_to_point_response=" + this.getReturnHost() + ":" + this.getReturnPort() + ")" : state + "(Multicast response)";
        state = this.objectRequired ? state + "(object required)" : state + "(object not required)";
        state = this.getHost() != null ? state + "(selected host = " + this.getHost() + ")" : state + "(all hosts)";
        return state;
    }

    public boolean getObjectRequired() {
        return this.objectRequired;
    }

    public void setObjectRequired(boolean objectRequired) {
        this.objectRequired = objectRequired;
    }

    public void unsetReturnaddr() {
        this.returnAddr = false;
    }

    public void setReturnaddr(InetAddress host, int port) {
        this.returnAddr = true;
        this.returnHost = host;
        this.returnPort = port;
    }

    public boolean getReturnAddr() {
        return this.returnAddr;
    }

    public InetAddress getReturnHost() {
        if (this.returnAddr) {
            return this.returnHost;
        }
        return null;
    }

    public int getReturnPort() {
        if (this.returnAddr) {
            return this.returnPort;
        }
        return -1;
    }

    public void setTimeOut(int timeOut) {
        if (logger.finerOn()) {
            logger.finer("setTimeOut ", "Set to " + timeOut);
        }
        this.timeOut = timeOut;
    }

    public int getTimeOut() {
        if (logger.finerOn()) {
            logger.finer("getTimeOut ", "Value = " + this.timeOut);
        }
        return this.timeOut;
    }
}

