/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.discovery.ActualResponder;
import com.sun.jdmk.discovery.DiscoveryResponderMBean;
import com.sun.jdmk.internal.ClassLogger;
import com.sun.jdmk.internal.Useful;
import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.util.Date;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class DiscoveryResponder
implements Serializable,
DiscoveryResponderMBean,
MBeanRegistration {
    private static final long serialVersionUID = -3259829717493969016L;
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;
    public static final int STOPPING = 2;
    public static final int STARTING = 3;
    private String localClassName = "com.sun.jdmk.discovery.DiscoveryResponder";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.discovery", "DiscoveryResponder");
    private static final String sccs_id = "@(#)DiscoveryResponder.java 4.42 07/03/08 SMI";
    private int multicastPort;
    private String multicastGroup;
    private static int defaultMulticastPort = 9000;
    private static String defaultMulticastGroup = "224.224.224.224";
    private int ttl = 1;
    private MBeanServer cmf = null;
    private ObjectName responderObjectName = null;
    private transient ActualResponder responder = null;
    private transient Thread responderThread = null;
    private static final String HOST = "host";
    private static final String GROUP = "group";
    private static final String PORT = "port";
    private static final String TTL = "ttl";
    private static final String SPY = "spy";
    private String spy = "";
    private String noEvent = null;
    private volatile transient int state = 1;
    private byte[] userData;
    private InetAddress usrInet = null;
    private String local = null;

    public DiscoveryResponder() {
        this(defaultMulticastGroup, defaultMulticastPort, null, null);
    }

    public DiscoveryResponder(String multicastGroup, int multicastPort) {
        this(multicastGroup, multicastPort, null, null);
    }

    public DiscoveryResponder(String multicastGroup, int multicastPort, InetAddress inf) {
        this(multicastGroup, multicastPort, inf, null);
    }

    public DiscoveryResponder(String multicastGroup, int multicastPort, InetAddress inf, String local) {
        this.multicastGroup = multicastGroup;
        this.multicastPort = multicastPort;
        if (inf != null && !Useful.isLocalHost(inf)) {
            throw new IllegalArgumentException("The user specified multi cast group is not a local interface: " + inf);
        }
        this.usrInet = inf;
        if (local != null && !Useful.isLocalHost(local)) {
            throw new IllegalArgumentException("The user specified local host is not a local: " + local);
        }
        this.local = local;
        if (logger.finerOn()) {
            logger.finer("constructor ", "Set group to '" + multicastGroup + "'");
            logger.finer("constructor ", "Set port  to '" + multicastPort + "'");
            if (inf != null) {
                logger.finer("constructor ", "Set interface  to '" + inf + "'");
            }
            if (local != null) {
                logger.finer("constructor ", "Set the local host to '" + local + "'");
            }
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (logger.finerOn()) {
            logger.finer("preRegister ", "object name   = " + name);
        }
        this.responderObjectName = name;
        this.spy = name.getKeyProperty(SPY);
        this.noEvent = name.getKeyProperty("PRIVATE_NO_EVENT");
        this.cmf = server;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
        if (this.state == 0) {
            this.stop();
        }
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void start() throws IOException {
        if (this.state == 1) {
            this.changeState(3);
            if (this.cmf == null) {
                if (logger.finerOn()) {
                    logger.finer("start ", "Can't start discoveryResponder: JDMK MBeanServer is not set");
                }
                return;
            }
            try {
                if (logger.finerOn()) {
                    logger.finer("start ", "Create a new responder");
                }
                this.responder = new ActualResponder(this.multicastGroup, this.multicastPort, this.getTimeToLive(), this.cmf, this.spy, this);
                if (this.local != null) {
                    this.responder.setLocalHost(this.local);
                }
                if (this.usrInet != null) {
                    this.responder.setInterface(this.usrInet);
                    if (logger.finerOn()) {
                        logger.finer("start ", "set interface to " + this.usrInet);
                    }
                }
                if (this.noEvent != null) {
                    this.responder.noEvent();
                }
                if (logger.finerOn()) {
                    logger.finer("start ", "call responder connect");
                }
                this.responder.connectToGroup();
                this.responderThread = new Thread(this.responder);
                this.responderThread.setName("Multicast responder");
                this.responderThread.start();
            }
            catch (SocketException e) {
                if (logger.finestOn()) {
                    logger.finest("start", e);
                }
                throw new IOException(e.getMessage());
            }
            catch (IOException e) {
                if (logger.finestOn()) {
                    logger.finest("start ", e);
                }
                throw e;
            }
            catch (NullPointerException e) {
                if (logger.finestOn()) {
                    logger.finest("start ", e);
                }
                throw new IOException(e.getMessage());
            }
        } else if (logger.finerOn()) {
            logger.finer("start ", "Responder is not OFFLINE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.state == 0) {
            block11: {
                this.changeState(2);
                this.responder.stopRequested = true;
                Boolean bl = this.responder.interrupted;
                synchronized (bl) {
                    if (!this.responder.interrupted.booleanValue()) {
                        this.responderThread.interrupt();
                    }
                }
                try {
                    MulticastSocket ms = new MulticastSocket(this.multicastPort);
                    if (this.usrInet != null) {
                        ms.setInterface(this.usrInet);
                        if (logger.finerOn()) {
                            logger.finer("stop ", "use the interface " + this.usrInet);
                        }
                    }
                    InetAddress group = InetAddress.getByName(this.multicastGroup);
                    ms.joinGroup(group);
                    ms.send(new DatagramPacket(new byte[1], 1, group, this.multicastPort));
                    ms.leaveGroup(group);
                }
                catch (Exception e) {
                    if (!logger.finerOn()) break block11;
                    logger.finer("stop ", "Unexpected exception occurred trying to send empty message " + e.getMessage());
                }
            }
            this.responder = null;
            System.runFinalization();
        } else if (logger.finerOn()) {
            logger.finer("stop ", "Responder is not ONLINE");
        }
    }

    @Override
    public boolean isActive() {
        return this.state == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitState(int state, long timeout) {
        if (logger.finerOn()) {
            logger.finer("waitState", state + "(0on,1off,2st) TO=" + timeout + " ; current state = " + this.getStateString());
        }
        if (timeout < 0L) {
            return this.state == state;
        }
        boolean done = this.state == state;
        long currentTimeOut = -1L;
        Date endDate = new Date(new Date().getTime() + timeout);
        while (!done) {
            if (timeout != 0L && (currentTimeOut = endDate.getTime() - new Date().getTime()) <= 0L) {
                done = true;
                break;
            }
            try {
                DiscoveryResponder discoveryResponder = this;
                synchronized (discoveryResponder) {
                    if (timeout == 0L) {
                        if (logger.finerOn()) {
                            logger.finer("waitState", "Start waiting infinite, current state = " + this.state);
                        }
                        boolean bl = done = this.state == state;
                        while (!done) {
                            done = this.state == state;
                            try {
                                this.wait(1000L);
                            }
                            catch (Exception e) {}
                        }
                    } else {
                        if (logger.finerOn()) {
                            logger.finer("waitState", "Start waiting " + currentTimeOut + " current state = " + this.state);
                        }
                        this.wait(currentTimeOut);
                    }
                }
                done = this.state == state;
            }
            catch (InterruptedException e) {
                done = this.state == state;
            }
        }
        if (logger.finerOn()) {
            logger.finer("waitState", "End, TO=" + currentTimeOut);
        }
        return this.state == state;
    }

    @Override
    public String getMulticastGroup() {
        return this.multicastGroup;
    }

    @Override
    public void setMulticastGroup(String multicastGroup) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.multicastGroup = multicastGroup;
    }

    @Override
    public int getMulticastPort() {
        return this.multicastPort;
    }

    @Override
    public void setMulticastPort(int multicastPort) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.multicastPort = multicastPort;
    }

    @Override
    public int getTimeToLive() {
        return this.ttl;
    }

    @Override
    public void setTimeToLive(int ttl) throws IllegalStateException {
        if (this.state == 1) {
            if (ttl <= 0 || ttl > 255) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new IllegalStateException();
        }
        this.ttl = ttl;
    }

    @Override
    public Integer getState() {
        return new Integer(this.state);
    }

    @Override
    public String getStateString() {
        String result = "UNKNOWN";
        switch (this.state) {
            case 0: {
                result = "ONLINE";
                break;
            }
            case 1: {
                result = "OFFLINE";
                break;
            }
            case 2: {
                result = "STOPPING";
                break;
            }
            case 3: {
                result = "STARTING";
            }
        }
        return result;
    }

    @Override
    public void setUserData(byte[] data) {
        this.userData = data;
    }

    @Override
    public byte[] getUserData() {
        return this.userData;
    }

    synchronized void changeState(int s) {
        if (this.state == s) {
            return;
        }
        int old = this.state;
        this.state = s;
        this.notifyAll();
    }
}

