/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerDelegate;

public class ClassLogger {
    private static final int NONE = -1;
    private static final int SEVERE = 0;
    private static final int WARNING = 1;
    private static final int INFO = 2;
    private static final int CONFIG = 3;
    private static final int FINE = 4;
    private static final int FINER = 5;
    private static final int FINEST = 6;
    private static final boolean ok;
    private final String className;
    private final Logger logger;
    private final int level;
    public static final String LOGGER_JDMK = "com.sun.jdmk";
    public static final String LOGGER_MBEANSERVER = "com.sun.jdmk.mbeanserver";
    public static final String LOGGER_SNMP = "com.sun.jdmk.snmp.runtime";
    public static final String LOGGER_PROXY_SNMP = "com.sun.jdmk.snmp.proxy";
    public static final String LOGGER_ADAPTOR_SNMP = "com.sun.jdmk.snmp.adaptor";
    public static final String LOGGER_ADAPTOR_HTML = "com.sun.jdmk.html.adaptor";
    public static final String LOGGER_DISCOVERY = "com.sun.jdmk.discovery";
    public static final String LOGGER_NOTIFICATION = "com.sun.jdmk.notification";
    public static final String LOGGER_CASCADING = "com.sun.jdmk.cascading";
    public static final String LOGGER_LEGACY_CASCADING = "com.sun.jdmk.legacy.cascading";
    public static final String LOGGER_MISC = "com.sun.jdmk.misc";
    public static final String LOGGER_COMM = "com.sun.jdmk.comm";
    public static final String LOGGER_CONNECTION_TIMER = "com.sun.jdmk.comm.timer";
    public static final String LOGGER_LEGACY_RMI = "com.sun.jdmk.comm.legacy.connector.rmi";
    public static final String LOGGER_LEGACY_HTTP = "com.sun.jdmk.comm.legacy.connector.http";
    public static final String LOGGER_LEGACY_HTTPS = "com.sun.jdmk.comm.legacy.connector.https";
    public static final String LOGGER_LEGACY_HEARTBEAT = "com.sun.jdmk.comm.legacy.connector.heartbeat";
    public static final String LOGGER_LEGACY_SERVER_WRAPPER = "com.sun.jdmk.comm.legacy.connector.wrapper";
    public static final String LOGGER_LEGACY_CLIENT_WRAPPER = "com.sun.jdmk.comm.legacy.client.wrapper";

    public static String getClassName(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isArray()) {
            return ClassLogger.getClassName(clazz.getComponentType()) + "[]";
        }
        String fullname = clazz.getName();
        int lastpoint = fullname.lastIndexOf(46);
        int len = fullname.length();
        if (lastpoint < 0 || lastpoint >= len) {
            return fullname;
        }
        return fullname.substring(lastpoint + 1, len);
    }

    public static String getPackageName(Class clazz) {
        if (clazz == null) {
            return "";
        }
        Package p = clazz.getPackage();
        if (p == null) {
            return "";
        }
        String pname = p.getName();
        if (pname == null) {
            return "";
        }
        return pname;
    }

    public ClassLogger(Class clazz) {
        this(ClassLogger.getPackageName(clazz), ClassLogger.getClassName(clazz));
    }

    public ClassLogger(String subsystem, Class clazz) {
        this(subsystem, ClassLogger.getClassName(clazz));
    }

    public ClassLogger(String subsystem, String className) {
        int propLevel = 2;
        if (ok) {
            this.logger = Logger.getLogger(subsystem);
            propLevel = -1;
        } else {
            this.logger = null;
            try {
                if (System.getProperty("LEVEL_SEVERE") != null) {
                    propLevel = 0;
                }
                if (System.getProperty("LEVEL_WARNING") != null) {
                    propLevel = 1;
                }
                if (System.getProperty("LEVEL_TRACE") != null) {
                    propLevel = 5;
                }
                if (System.getProperty("LEVEL_DEBUG") != null) {
                    propLevel = 6;
                }
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        this.level = propLevel;
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public final boolean traceOn() {
        return this.finerOn();
    }

    public final boolean debugOn() {
        return this.finestOn();
    }

    public final boolean warningOn() {
        if (ok) {
            return this.logger.isLoggable(Level.WARNING);
        }
        return this.level >= 1;
    }

    public final boolean infoOn() {
        if (ok) {
            return this.logger.isLoggable(Level.INFO);
        }
        return this.level >= 2;
    }

    public final boolean configOn() {
        if (ok) {
            return this.logger.isLoggable(Level.CONFIG);
        }
        return this.level >= 3;
    }

    public final boolean fineOn() {
        if (ok) {
            return this.logger.isLoggable(Level.FINE);
        }
        return this.level >= 4;
    }

    public final boolean finerOn() {
        if (ok) {
            return this.logger.isLoggable(Level.FINER);
        }
        return this.level >= 5;
    }

    public final boolean finestOn() {
        if (ok) {
            return this.logger.isLoggable(Level.FINEST);
        }
        return this.level >= 6;
    }

    public final void debug(String func, String msg) {
        this.finest(func, msg);
    }

    public final void debug(String func, Throwable t) {
        this.finest(func, t);
    }

    public final void debug(String func, String msg, Throwable t) {
        this.finest(func, msg, t);
    }

    public final void trace(String func, String msg) {
        this.finer(func, msg);
    }

    public final void trace(String func, Throwable t) {
        this.finer(func, t);
    }

    public final void trace(String func, String msg, Throwable t) {
        this.finer(func, msg, t);
    }

    public final void error(String func, String msg) {
        this.severe(func, msg);
    }

    public final void error(String func, Throwable t) {
        this.severe(func, t);
    }

    public final void error(String func, String msg, Throwable t) {
        this.severe(func, msg, t);
    }

    public final void finest(String func, String msg) {
        if (ok) {
            this.logger.logp(Level.FINEST, this.getClassName(), func, msg);
        } else if (this.level >= 6) {
            System.err.println("FINEST: [" + this.getClassName() + "] [" + func + "] " + msg);
        }
    }

    public final void finest(String func, Throwable t) {
        if (ok) {
            this.logger.logp(Level.FINEST, this.getClassName(), func, t.toString(), t);
        } else if (this.level >= 6) {
            System.err.println("FINEST: [" + this.getClassName() + "] [" + func + "] " + t);
            t.printStackTrace();
        }
    }

    public final void finest(String func, String msg, Throwable t) {
        if (ok) {
            this.logger.logp(Level.FINEST, this.getClassName(), func, msg, t);
        } else if (this.level >= 6) {
            System.err.println("FINEST: [" + this.getClassName() + "] [" + func + "] " + msg + " " + t);
            t.printStackTrace();
        }
    }

    public final void finer(String func, String msg) {
        if (ok) {
            this.logger.logp(Level.FINER, this.getClassName(), func, msg);
        } else if (this.level >= 5) {
            System.err.println("FINER: [" + this.getClassName() + "] [" + func + "] " + msg);
        }
    }

    public final void finer(String func, Throwable t) {
        if (ok) {
            this.logger.logp(Level.FINER, this.getClassName(), func, t.toString(), t);
        } else if (this.level >= 5) {
            System.err.println("FINER: [" + this.getClassName() + "] [" + func + "] " + t);
            t.printStackTrace();
        }
    }

    public final void finer(String func, String msg, Throwable t) {
        if (ok) {
            this.logger.logp(Level.FINER, this.getClassName(), func, msg, t);
        } else if (this.level >= 5) {
            System.err.println("FINER: [" + this.getClassName() + "] [" + func + "] " + msg + " " + t);
            t.printStackTrace();
        }
    }

    public final void fine(String func, String msg) {
        if (ok) {
            this.logger.logp(Level.FINE, this.getClassName(), func, msg);
        } else if (this.level >= 4) {
            System.err.println("FINE: [" + this.getClassName() + "] [" + func + "] " + msg);
        }
    }

    public final void fine(String func, Throwable t) {
        if (ok) {
            this.logger.logp(Level.FINE, this.getClassName(), func, t.toString(), t);
        } else if (this.level >= 4) {
            System.err.println("FINE: [" + this.getClassName() + "] [" + func + "] " + t);
            t.printStackTrace();
        }
    }

    public final void fine(String func, String msg, Throwable t) {
        if (ok) {
            this.logger.logp(Level.FINE, this.getClassName(), func, msg, t);
        } else if (this.level >= 4) {
            System.err.println("FINE: [" + this.getClassName() + "] [" + func + "] " + msg + " " + t);
            t.printStackTrace();
        }
    }

    public final void config(String func, String msg) {
        if (ok) {
            this.logger.logp(Level.CONFIG, this.getClassName(), func, msg);
        } else if (this.level >= 3) {
            System.err.println("CONFIG: [" + this.getClassName() + "] [" + func + "] " + msg);
        }
    }

    public final void config(String func, Throwable t) {
        if (ok) {
            this.logger.logp(Level.CONFIG, this.getClassName(), func, t.toString(), t);
        } else if (this.level >= 3) {
            System.err.println("CONFIG: [" + this.getClassName() + "] [" + func + "] " + t);
            t.printStackTrace();
        }
    }

    public final void config(String func, String msg, Throwable t) {
        if (ok) {
            this.logger.logp(Level.CONFIG, this.getClassName(), func, msg, t);
        } else if (this.level >= 3) {
            System.err.println("CONFIG: [" + this.getClassName() + "] [" + func + "] " + msg + " " + t);
            t.printStackTrace();
        }
    }

    public final void info(String func, String msg) {
        if (ok) {
            this.logger.logp(Level.INFO, this.getClassName(), func, msg);
        } else if (this.level >= 2) {
            System.err.println("INFO: [" + this.getClassName() + "] [" + func + "] " + msg);
        }
    }

    public final void info(String func, Throwable t) {
        if (ok) {
            this.logger.logp(Level.INFO, this.getClassName(), func, t.toString(), t);
        } else if (this.level >= 2) {
            System.err.println("INFO: [" + this.getClassName() + "] [" + func + "] " + t);
            t.printStackTrace();
        }
    }

    public final void info(String func, String msg, Throwable t) {
        if (ok) {
            this.logger.logp(Level.INFO, this.getClassName(), func, msg, t);
        } else if (this.level >= 2) {
            System.err.println("INFO: [" + this.getClassName() + "] [" + func + "] " + msg + " " + t);
            t.printStackTrace();
        }
    }

    public final void warning(String func, String msg) {
        if (ok) {
            this.logger.logp(Level.WARNING, this.getClassName(), func, msg);
        } else if (this.level >= 1) {
            System.err.println("WARNING: [" + this.getClassName() + "] [" + func + "] " + msg);
        }
    }

    public final void warning(String func, Throwable t) {
        if (ok) {
            this.logger.logp(Level.WARNING, this.getClassName(), func, t.toString(), t);
        } else if (this.level >= 1) {
            System.err.println("WARNING: [" + this.getClassName() + "] [" + func + "] " + t);
            t.printStackTrace();
        }
    }

    public final void warning(String func, String msg, Throwable t) {
        if (ok) {
            this.logger.logp(Level.WARNING, this.getClassName(), func, msg, t);
        } else if (this.level >= 1) {
            System.err.println("WARNING: [" + this.getClassName() + "] [" + func + "] " + msg + " " + t);
            t.printStackTrace();
        }
    }

    public final void severe(String func, String msg) {
        if (ok) {
            this.logger.logp(Level.SEVERE, this.getClassName(), func, msg);
        } else {
            System.err.println("SEVERE: [" + this.getClassName() + "] [" + func + "] " + msg);
        }
    }

    public final void severe(String func, Throwable t) {
        if (ok) {
            this.logger.logp(Level.SEVERE, this.getClassName(), func, t.toString(), t);
        } else {
            System.err.println("SEVERE: [" + this.getClassName() + "] [" + func + "] " + t);
            t.printStackTrace();
        }
    }

    public final void severe(String func, String msg, Throwable t) {
        if (ok) {
            this.logger.logp(Level.SEVERE, this.getClassName(), func, msg, t);
        } else {
            System.err.println("SEVERE: [" + this.getClassName() + "] [" + func + "] " + msg + " " + t);
            t.printStackTrace();
        }
    }

    static {
        boolean loaded = false;
        try {
            Class<Logger> c = Logger.class;
            loaded = true;
        }
        catch (Error e) {
            // empty catch block
        }
        ok = loaded;
        if (ok) {
            String jmxImp = "Unknown";
            try {
                MBeanServerDelegate md = new MBeanServerDelegate();
                jmxImp = md.getImplementationName() + " " + md.getImplementationVersion();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.getLogger(LOGGER_JDMK).logp(Level.FINE, "ClassLogger", "init", "Java DMK build version [opendmk-1.0-b02]\n      JMX implementation [" + jmxImp + "]" + "\n      Java version [" + System.getProperty("java.version") + "]" + "\n      os name [" + System.getProperty("os.name") + "]" + "\n      os arch [" + System.getProperty("os.arch") + "]" + "\n      os version [" + System.getProperty("os.version") + "]");
        }
    }
}

