/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.internal;

import com.sun.jdmk.remote.cascading.BasicMBeanServerConnectionFactory;
import com.sun.jdmk.remote.cascading.MBeanServerConnectionFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class ReconnectMBeanServerConnectionFactory
extends BasicMBeanServerConnectionFactory
implements Runnable,
Serializable {
    private static final long serialVersionUID = -5764359043690071419L;
    private long envelopTime;
    private long period;
    private boolean stop = false;
    private transient boolean failed = false;
    private final NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
    private JMXServiceURL url;
    private Map map;
    private String currentConnectionId;
    private transient JMXConnector connector = null;
    private transient MBeanServerConnection connection = null;
    private final NotificationListener listener;

    public ReconnectMBeanServerConnectionFactory(JMXServiceURL url, Map map, long envelopTime, long period) throws IOException {
        super(null, null);
        this.url = url;
        this.map = map;
        this.envelopTime = envelopTime;
        this.period = period;
        this.listener = new NotificationListener(){

            @Override
            public void handleNotification(Notification n, Object handback) {
                ReconnectMBeanServerConnectionFactory.this.handleConnectionNotification(n, handback);
            }
        };
        if (this.getJMXConnector() == null) {
            if (envelopTime == 0L) {
                throw new IOException("Unable to connect to " + url);
            }
            this.reconnect();
        } else {
            this.currentConnectionId = this.getConnectionId();
        }
    }

    public JMXServiceURL getURL() {
        return this.url;
    }

    private static JMXConnector makeConnector(JMXServiceURL url, Map map) throws IOException {
        JMXConnector c = null;
        try {
            c = JMXConnectorFactory.connect(url, map);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return c;
    }

    public synchronized void stopReconnection() {
        this.stop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        JMXConnector old = this.getJMXConnector();
        String connectionId = null;
        while (true) {
            try {
                JMXConnector c = ReconnectMBeanServerConnectionFactory.makeConnector(this.url, this.map);
                if (c == null) {
                    throw new Exception("Not connected");
                }
                c.addConnectionNotificationListener(this.listener, null, null);
                ReconnectMBeanServerConnectionFactory reconnectMBeanServerConnectionFactory = this;
                synchronized (reconnectMBeanServerConnectionFactory) {
                    this.connector = c;
                    this.connection = null;
                }
                connectionId = c.getConnectionId();
                JMXConnectionNotification notif = new JMXConnectionNotification("jmx.remote.connection.open", "", connectionId, 0L, "", "");
                this.broadcaster.sendNotification(notif);
                return;
            }
            catch (Exception e) {
                long currentTime;
                try {
                    Thread.sleep(this.period);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if ((currentTime = System.currentTimeMillis()) - startTime < this.envelopTime && !this.stop) continue;
                if (!this.stop) {
                    if (this.currentConnectionId == null) {
                        this.currentConnectionId = "NeverConnectedConnection";
                    }
                    JMXConnectionNotification notif = new JMXConnectionNotification("jmx.remote.connection.failed", "", this.currentConnectionId, 0L, "", "");
                    this.broadcaster.sendNotification(notif);
                    try {
                        this.currentConnectionId = this.getConnectionId();
                    }
                    catch (Exception e2) {
                        this.currentConnectionId = null;
                    }
                }
                return;
            }
            break;
        }
    }

    private void reconnect() {
        if (this.envelopTime > 0L) {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void handleConnectionNotification(Notification notification, Object handback) {
        if (notification.getType().equals("jmx.remote.connection.failed")) {
            try {
                this.getJMXConnector().removeConnectionNotificationListener(this.listener);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.reconnect();
        } else {
            this.broadcaster.sendNotification(notification);
        }
    }

    @Override
    public void addConnectionNotificationListener(NotificationListener l, NotificationFilter filter, Object handback) {
        this.broadcaster.addNotificationListener(l, filter, handback);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener l) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(l);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener l, NotificationFilter f, Object handback) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(l, f, handback);
    }

    public static MBeanServerConnectionFactory newInstance(JMXServiceURL url, Map map, long envelopTime, long period) throws IOException {
        return new ReconnectMBeanServerConnectionFactory(url, map, envelopTime, period);
    }

    @Override
    public synchronized JMXConnector getJMXConnector() {
        try {
            if (this.connector == null) {
                this.connector = ReconnectMBeanServerConnectionFactory.makeConnector(this.url, this.map);
                this.connector.addConnectionNotificationListener(this.listener, null, this.connector);
                this.connection = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.connector;
    }

    @Override
    public synchronized MBeanServerConnection getMBeanServerConnection() throws IOException {
        if (this.failed) {
            throw new IOException("connection already failed");
        }
        if (this.getJMXConnector() == null) {
            throw new IOException("Unable to connect");
        }
        if (this.connection == null) {
            this.connection = this.getJMXConnector().getMBeanServerConnection(this.getDelegationSubject());
        }
        return this.connection;
    }
}

