/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.internal;

import com.sun.jdmk.internal.ThreadService;
import com.sun.jdmk.tasks.Task;
import com.sun.jdmk.tasks.TaskServer;
import java.util.ArrayList;

public class TimedExecutor
implements TaskServer {
    private ThreadService tService;
    private ArrayList jobInfoList = new ArrayList();
    private ExecutorThread exeThread;
    private boolean terminated;
    private long doneJob = 0L;
    private long addedJob = 0L;

    public TimedExecutor() {
        this(2);
    }

    public TimedExecutor(int threads) {
        if (threads <= 0) {
            throw new IllegalArgumentException("Thread number should be bigger than zero.");
        }
        this.tService = new ThreadService(threads);
        this.exeThread = new ExecutorThread();
        this.exeThread.start();
    }

    @Override
    public void submitTask(Task task) throws IllegalArgumentException {
        this.submitTask((Runnable)task, 0L);
    }

    public void submitTask(Task task, long delay) throws IllegalArgumentException {
        this.submitTask((Runnable)task, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitTask(Runnable task, long delay) throws IllegalArgumentException {
        if (task == null) {
            throw new IllegalArgumentException("No task specified.");
        }
        long startTime = delay + System.currentTimeMillis();
        JobInfo newJob = new JobInfo(task, startTime);
        boolean added = false;
        ArrayList arrayList = this.jobInfoList;
        synchronized (arrayList) {
            int lg = this.jobInfoList.size();
            for (int i = lg - 1; i >= 0; --i) {
                JobInfo info = (JobInfo)this.jobInfoList.get(i);
                if (newJob.startTime < info.startTime) continue;
                this.jobInfoList.add(i + 1, newJob);
                added = true;
                break;
            }
            if (!added) {
                this.jobInfoList.add(0, newJob);
            }
            this.jobInfoList.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable removeTask(Runnable task) {
        Runnable removed = null;
        ArrayList arrayList = this.jobInfoList;
        synchronized (arrayList) {
            int lg = this.jobInfoList.size();
            for (int i = 0; i < lg; ++i) {
                JobInfo info = (JobInfo)this.jobInfoList.get(i);
                if (task != info.job) continue;
                removed = ((JobInfo)this.jobInfoList.remove((int)i)).job;
                if (i != 0) break;
                this.jobInfoList.notify();
                break;
            }
        }
        if (removed != null && removed instanceof Task) {
            ((Task)removed).cancel();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        JobInfo[] jobs;
        ArrayList arrayList = this.jobInfoList;
        synchronized (arrayList) {
            jobs = new JobInfo[this.jobInfoList.size()];
            this.jobInfoList.toArray(jobs);
            this.jobInfoList.clear();
            this.jobInfoList.notifyAll();
        }
        int len = jobs.length;
        for (int i = 0; i < len; ++i) {
            Runnable o = jobs[i].job;
            if (o == null || !(o instanceof Task)) continue;
            ((Task)o).cancel();
        }
    }

    public void terminate() {
        this.terminated = true;
        this.removeAll();
        try {
            Thread.sleep(100L);
            this.exeThread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class JobInfo {
        public Runnable job;
        public long startTime;

        public JobInfo(Runnable job, long startTime) {
            this.job = job;
            this.startTime = startTime;
        }
    }

    private class ExecutorThread
    extends Thread {
        public ExecutorThread() {
            super("ExecutorThread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!TimedExecutor.this.terminated) {
                JobInfo ji = this.getJobInfo();
                if (TimedExecutor.this.terminated) break;
                try {
                    TimedExecutor.this.tService.submitTask(ji.job);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JobInfo getJobInfo() {
            JobInfo ji = null;
            ArrayList arrayList = TimedExecutor.this.jobInfoList;
            synchronized (arrayList) {
                while (!TimedExecutor.this.terminated) {
                    if (TimedExecutor.this.jobInfoList.size() == 0) {
                        try {
                            TimedExecutor.this.jobInfoList.wait();
                            continue;
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    ji = (JobInfo)TimedExecutor.this.jobInfoList.get(0);
                    long dt = ji.startTime - System.currentTimeMillis();
                    if (dt <= 0L) {
                        TimedExecutor.this.jobInfoList.remove(0);
                        break;
                    }
                    try {
                        TimedExecutor.this.jobInfoList.wait(dt);
                    }
                    catch (InterruptedException e) {}
                }
            }
            return ji;
        }
    }
}

