/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.remote.cascading;

import com.sun.jdmk.remote.cascading.MBeanServerConnectionFactory;
import java.io.IOException;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;

public class BasicMBeanServerConnectionFactory
implements MBeanServerConnectionFactory {
    private final Subject subject;
    private final JMXConnector connector;
    private MBeanServerConnection connection;
    private boolean failed = false;
    private final NotificationBroadcasterSupport emitter;
    private final NotificationListener listener;

    public BasicMBeanServerConnectionFactory(JMXConnector connector, Subject delegationSubject) {
        this.connector = connector;
        this.subject = delegationSubject;
        this.connection = null;
        this.emitter = new NotificationBroadcasterSupport();
        this.listener = new NotificationListener(){

            @Override
            public void handleNotification(Notification n, Object handback) {
                BasicMBeanServerConnectionFactory.this.handleConnectionNotification(n, handback);
            }
        };
        this.failed = false;
        if (connector != null) {
            this.connector.addConnectionNotificationListener(this.listener, null, connector);
        }
    }

    public synchronized JMXConnector getJMXConnector() {
        return this.connector;
    }

    public final Subject getDelegationSubject() {
        return this.subject;
    }

    @Override
    public synchronized MBeanServerConnection getMBeanServerConnection() throws IOException {
        if (this.failed) {
            throw new IOException("connection already failed");
        }
        if (this.connection == null) {
            this.connection = this.connector.getMBeanServerConnection(this.subject);
        }
        return this.connection;
    }

    @Override
    public void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.emitter.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener l, NotificationFilter f, Object handback) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(l, f, handback);
    }

    @Override
    public String getConnectionId() throws IOException {
        if (this.failed) {
            throw new IOException("connection already failed");
        }
        return this.getJMXConnector().getConnectionId();
    }

    public static MBeanServerConnectionFactory newInstance(JMXServiceURL url) throws IOException {
        return BasicMBeanServerConnectionFactory.newInstance(url, null, null);
    }

    public static MBeanServerConnectionFactory newInstance(JMXServiceURL url, Map map) throws IOException {
        return BasicMBeanServerConnectionFactory.newInstance(url, map, null);
    }

    public static MBeanServerConnectionFactory newInstance(JMXServiceURL url, Map map, Subject subject) throws IOException {
        return BasicMBeanServerConnectionFactory.newInstance(JMXConnectorFactory.connect(url, map), subject);
    }

    public static MBeanServerConnectionFactory newInstance(JMXConnector c) {
        return BasicMBeanServerConnectionFactory.newInstance(c, null);
    }

    public static MBeanServerConnectionFactory newInstance(JMXConnector c, Subject subject) {
        return new BasicMBeanServerConnectionFactory(c, subject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnectionNotification(Notification n, Object handback) {
        block9: {
            try {
                if (!"jmx.remote.connection.failed".equals(n.getType())) break block9;
                BasicMBeanServerConnectionFactory basicMBeanServerConnectionFactory = this;
                synchronized (basicMBeanServerConnectionFactory) {
                    if (!this.failed && handback == this.getJMXConnector()) {
                        this.failed = true;
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.emitter.sendNotification(n);
            }
        }
    }
}

