/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.remote.cascading;

import com.sun.jdmk.defaults.Utils;
import com.sun.jdmk.remote.cascading.BasicMBeanServerConnectionFactory;
import com.sun.jdmk.remote.cascading.CascadingAgent;
import com.sun.jdmk.remote.cascading.CascadingServiceMBean;
import com.sun.jdmk.remote.cascading.MBeanServerConnectionFactory;
import com.sun.jdmk.remote.cascading.proxy.ProxyCascadingAgent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class CascadingService
implements CascadingServiceMBean,
NotificationEmitter,
MBeanRegistration {
    private static final String[] jmxConnectionNotificationTypes = new String[]{"com.sun.jdmk.remote.cascading.failed", "com.sun.jdmk.remote.cascading.stopped"};
    private static final MBeanNotificationInfo jmxConnectionNotificationInfo = new MBeanNotificationInfo(jmxConnectionNotificationTypes, JMXConnectionNotification.class.getName(), "Notifications relating to the underlying CascadingAgent.");
    private final NotificationBroadcasterSupport emitter;
    private final MBeanServer targetMBS;
    private final NotificationListener listener;
    private final HashMap mountMap;
    private MBeanServer myMBS = null;
    private long sequenceNumber = 0L;

    static String makeID(JMXServiceURL sourceURL, ObjectName sourcePattern, String targetPath) {
        String url = sourceURL == null ? "???" : String.valueOf(sourceURL);
        String filter = sourcePattern == null ? "*:*" : String.valueOf(sourcePattern);
        return "mount: " + url + " " + sourcePattern + " " + targetPath;
    }

    public CascadingService() {
        this(null);
    }

    public CascadingService(MBeanServer targetMBS) {
        this.targetMBS = targetMBS;
        this.listener = new NotificationListener(){

            @Override
            public void handleNotification(Notification nt, Object handback) {
                CascadingService.this.handleJMXCN(nt, handback);
            }
        };
        this.emitter = new NotificationBroadcasterSupport();
        this.mountMap = new HashMap();
    }

    @Override
    public final synchronized String mount(JMXServiceURL sourceURL, Map sourceMap, ObjectName sourcePattern, String targetPath) throws IOException, InstanceAlreadyExistsException {
        MountPoint mpt = new MountPoint(sourceURL, sourcePattern, targetPath);
        if (this.isMounted(mpt.mountPointID)) {
            throw new IOException(mpt.mountPointID + ": already mounted.");
        }
        JMXConnector sourceConnector = this.connectSource(sourceURL, sourceMap, mpt.mountPointID);
        try {
            this.mountMap.put(mpt.mountPointID, mpt);
            mpt.mount(sourceConnector, this.getTargetMBeanServer());
            return mpt.mountPointID;
        }
        catch (Exception x) {
            try {
                this.mountMap.remove(mpt.mountPointID);
                mpt.unmount();
            }
            catch (Exception xx) {
                // empty catch block
            }
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            if (x instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)x;
            }
            if (x instanceof RuntimeException) {
                throw (RuntimeException)x;
            }
            IOException io = new IOException(mpt.mountPointID + ": " + x);
            Utils.initCause(io, x);
            throw io;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public final boolean unmount(String mountPointID) throws IOException {
        String message;
        Exception failure;
        MountPoint mpt;
        block9: {
            mpt = null;
            failure = null;
            CascadingService cascadingService = this;
            // MONITORENTER : cascadingService
            mpt = (MountPoint)this.mountMap.remove(mountPointID);
            if (mpt != null) break block9;
            boolean bl = false;
            // MONITOREXIT : cascadingService
            if (mpt == null) return bl;
            String type = "com.sun.jdmk.remote.cascading.stopped";
            String message2 = failure == null ? ": succesfully unmounted" : ": unmounted with errors: " + failure;
            JMXConnectionNotification stopped = new JMXConnectionNotification("com.sun.jdmk.remote.cascading.stopped", this, mpt.mountPointID, this.newSequenceNumber(), mpt.mountPointID + message2, null);
            this.sendNotification(stopped);
            return bl;
        }
        try {
            mpt.unmount();
            // MONITOREXIT : cascadingService
            if (mpt == null) return true;
            String type = "com.sun.jdmk.remote.cascading.stopped";
            message = failure == null ? ": succesfully unmounted" : ": unmounted with errors: " + failure;
        }
        catch (IOException x) {
            try {
                failure = x;
                throw x;
                catch (RuntimeException r) {
                    failure = r;
                    throw r;
                }
            }
            catch (Throwable throwable) {
                if (mpt == null) throw throwable;
                String type = "com.sun.jdmk.remote.cascading.stopped";
                String message3 = failure == null ? ": succesfully unmounted" : ": unmounted with errors: " + failure;
                JMXConnectionNotification stopped = new JMXConnectionNotification("com.sun.jdmk.remote.cascading.stopped", this, mpt.mountPointID, this.newSequenceNumber(), mpt.mountPointID + message3, null);
                this.sendNotification(stopped);
                throw throwable;
            }
        }
        JMXConnectionNotification stopped = new JMXConnectionNotification("com.sun.jdmk.remote.cascading.stopped", this, mpt.mountPointID, this.newSequenceNumber(), mpt.mountPointID + message, null);
        this.sendNotification(stopped);
        return true;
    }

    @Override
    public synchronized boolean isMounted(String mountPointID) {
        return this.mountMap.containsKey(mountPointID);
    }

    @Override
    public synchronized String[] getMountPointIDs() {
        return this.mountMap.keySet().toArray(new String[this.mountMap.size()]);
    }

    @Override
    public final void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.emitter.addNotificationListener(listener, filter, handback);
    }

    @Override
    public final void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener);
    }

    @Override
    public final void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] info = new MBeanNotificationInfo[]{jmxConnectionNotificationInfo};
        return info;
    }

    public final MBeanServer getTargetMBeanServer() {
        return this.targetMBS != null ? this.targetMBS : this.myMBS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        CascadingService cascadingService = this;
        synchronized (cascadingService) {
            if (this.targetMBS == null && this.myMBS != null && this.myMBS != server) {
                throw new IllegalArgumentException("Already registered");
            }
            this.myMBS = server;
        }
        if (name != null) {
            return name;
        }
        return CascadingServiceMBean.CASCADING_SERVICE_DEFAULT_NAME;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        this.myMBS = null;
    }

    CascadingAgent createCascadingAgent(JMXConnector sourceConnector, ObjectName sourcePattern, String targetPath, MBeanServer targetMBS, String mountPointID) throws IOException {
        MBeanServerConnectionFactory sourceConnectionFactory = BasicMBeanServerConnectionFactory.newInstance(sourceConnector);
        return new ProxyCascadingAgent(sourceConnectionFactory, sourcePattern, null, targetPath, targetMBS, mountPointID);
    }

    JMXConnector connectSource(JMXServiceURL sourceURL, Map sourceMap, String mountPointID) throws IOException {
        return JMXConnectorFactory.connect(sourceURL, sourceMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate(CascadingAgent agent, JMXConnector sourceConnector, String mountPointID) throws IOException {
        try {
            if (agent != null) {
                agent.stop();
            }
        }
        finally {
            if (sourceConnector != null) {
                sourceConnector.close();
            }
        }
    }

    void sendNotification(Notification notification) {
        this.emitter.sendNotification(notification);
    }

    final synchronized long newSequenceNumber() {
        return this.sequenceNumber++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleJMXCN(Notification nt, Object handback) {
        MountPoint mpt = (MountPoint)handback;
        if (mpt == null) {
            return;
        }
        boolean closed = false;
        CascadingService cascadingService = this;
        synchronized (cascadingService) {
            if ("jmx.remote.connection.closed".equals(nt.getType()) && mpt.isClosed() || "jmx.remote.connection.failed".equals(nt.getType())) {
                try {
                    if (this.mountMap.remove(mpt.mountPointID) != null) {
                        mpt.unmount();
                    }
                }
                catch (Exception x) {
                    // empty catch block
                }
                closed = true;
            }
        }
        if (closed) {
            String type = "com.sun.jdmk.remote.cascading.failed";
            String cause = "jmx.remote.connection.failed".equals(nt.getType()) ? "failed" : "closed";
            JMXConnectionNotification failed = new JMXConnectionNotification("com.sun.jdmk.remote.cascading.failed", this, mpt.mountPointID, this.newSequenceNumber(), mpt.mountPointID + ": connection " + cause, nt);
            this.sendNotification(failed);
        }
    }

    class MountPoint {
        public final JMXServiceURL sourceURL;
        public final ObjectName sourcePattern;
        public final String targetPath;
        public final String mountPointID;
        private JMXConnector sourceConnector = null;
        private MBeanServerConnectionFactory sourceConnectionFactory = null;
        private CascadingAgent agent = null;

        public MountPoint(JMXServiceURL sourceURL, ObjectName sourcePattern, String targetPath) throws IOException {
            this.mountPointID = CascadingService.makeID(sourceURL, sourcePattern, targetPath);
            this.sourceURL = sourceURL;
            this.sourcePattern = sourcePattern;
            this.targetPath = targetPath;
        }

        public void mount(JMXConnector sourceConnector, MBeanServer targetMBS) throws IOException, InstanceAlreadyExistsException {
            this.sourceConnector = sourceConnector;
            this.agent = CascadingService.this.createCascadingAgent(sourceConnector, this.sourcePattern, this.targetPath, targetMBS, this.mountPointID);
            this.sourceConnectionFactory = this.agent.getConnectionFactory();
            this.agent.start(false);
            this.sourceConnectionFactory.addConnectionNotificationListener(CascadingService.this.listener, null, this);
            this.checkConnection();
        }

        public void unmount() throws IOException {
            Exception failure = null;
            try {
                this.sourceConnectionFactory.removeConnectionNotificationListener(CascadingService.this.listener, null, this);
            }
            catch (Exception x) {
                failure = x;
            }
            try {
                CascadingService.this.terminate(this.agent, this.sourceConnector, this.mountPointID);
            }
            catch (Exception x) {
                failure = x;
            }
            if (failure instanceof IOException) {
                throw (IOException)failure;
            }
            if (failure instanceof RuntimeException) {
                throw (RuntimeException)failure;
            }
            if (failure != null) {
                IOException io = new IOException(this.mountPointID + ": " + failure);
                Utils.initCause(io, failure);
                throw io;
            }
        }

        public boolean isClosed() {
            if (this.agent != null) {
                try {
                    this.agent.getConnectionFactory().getMBeanServerConnection().getDefaultDomain();
                    return false;
                }
                catch (Exception x) {
                    return true;
                }
            }
            return true;
        }

        public void checkConnection() throws IOException {
            if (this.sourceConnector == null) {
                throw new IOException("not connected");
            }
            if (this.sourceConnectionFactory == null) {
                throw new IOException("not connected");
            }
            MBeanServerConnection mbs = this.sourceConnectionFactory.getMBeanServerConnection();
            if (mbs == null) {
                throw new IOException("not connected");
            }
            mbs.getDefaultDomain();
        }
    }
}

