/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.remote.cascading;

import com.sun.jdmk.remote.cascading.CascadingAgent;
import com.sun.jdmk.remote.cascading.MBeanServerConnectionFactory;
import java.io.IOException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class LocalMBeanServerConnectionFactory
implements MBeanServerConnectionFactory {
    private final MBeanServerConnection localConnection;
    private final String connectionId;

    public LocalMBeanServerConnectionFactory(MBeanServerConnection local, String localID) {
        this.localConnection = local;
        this.connectionId = localID;
    }

    @Override
    public final MBeanServerConnection getMBeanServerConnection() throws IOException {
        return this.localConnection;
    }

    @Override
    public void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener l, NotificationFilter f, Object handback) throws ListenerNotFoundException {
    }

    @Override
    public final String getConnectionId() throws IOException {
        return this.connectionId;
    }

    public static MBeanServerConnectionFactory newInstance(MBeanServer s) {
        String mbsid = "unknown_MBeanServerId";
        try {
            mbsid = (String)s.getAttribute(CascadingAgent.MBSDelegateObjectName, "MBeanServerId");
        }
        catch (Exception x) {
            // empty catch block
        }
        String cid = "local://" + mbsid;
        return new LocalMBeanServerConnectionFactory(s, cid);
    }
}

