/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.remote.cascading.proxy;

import com.sun.jdmk.defaults.Utils;
import com.sun.jdmk.internal.ClassLogger;
import com.sun.jdmk.remote.cascading.CascadingAgent;
import com.sun.jdmk.remote.cascading.MBeanServerConnectionFactory;
import com.sun.jdmk.remote.cascading.MBeanServerConnectionWrapper;
import com.sun.jdmk.remote.cascading.proxy.CascadingProxy;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.remote.JMXConnectionNotification;

public class ProxyCascadingAgent
extends CascadingAgent {
    private final NotificationListener mbsNotifHandler = new NotificationListener(){

        @Override
        public void handleNotification(Notification notification, Object handback) {
            ProxyCascadingAgent.this.handleMBeanServerNotification(notification, handback);
        }
    };
    private final HashMap mbeanList = new HashMap();
    private final MBeanServerConnectionWrapper wrapper = new MBeanServerConnectionWrapper(){

        @Override
        protected MBeanServerConnection getMBeanServerConnection() throws IOException {
            return ProxyCascadingAgent.this.getConnectionFactory().getMBeanServerConnection();
        }
    };
    private final String description;
    private String state = "Stopped";
    private long sequenceNumber = 0L;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.cascading", "ProxyCascadingAgent");

    public ProxyCascadingAgent(MBeanServerConnectionFactory sourceConnection, ObjectName sourcePattern, QueryExp sourceQuery, String targetPath, MBeanServer targetMBS, String description) {
        super(sourceConnection, sourcePattern, sourceQuery, targetPath, targetMBS);
        this.description = description;
    }

    public ProxyCascadingAgent(MBeanServerConnectionFactory sourceConnection, ObjectName sourcePattern, QueryExp sourceQuery, String description) {
        this(sourceConnection, sourcePattern, sourceQuery, null, null, description);
    }

    @Override
    public synchronized void start() throws IOException {
        try {
            this.start(true);
        }
        catch (InstanceAlreadyExistsException iae) {
            throw new UndeclaredThrowableException(iae);
        }
    }

    @Override
    public synchronized void start(boolean conflictAllowed) throws IOException, InstanceAlreadyExistsException {
        if (!this.state.equals("Stopped")) {
            throw new IllegalStateException("Can't start when state is: " + this.state);
        }
        MBeanServer mbs = this.getTargetMBeanServer();
        if (mbs == null) {
            throw new IllegalStateException("Can't start with no MBeanServer");
        }
        this.state = "Starting";
        if (logger.fineOn()) {
            logger.fine("start", this.state);
        }
        try {
            this.getConnectionFactory().getMBeanServerConnection().addNotificationListener(MBSDelegateObjectName, this.mbsNotifHandler, null, null);
            this.enableConnectionNotifications();
        }
        catch (IOException io) {
            this.state = "Stopped";
            this.unexpectedException("start", MBSDelegateObjectName, io);
            throw io;
        }
        catch (Exception x) {
            this.unexpectedException("start", MBSDelegateObjectName, x);
            IOException io = new IOException("failed to start: " + x);
            Utils.initCause(io, x);
            this.state = "Stopped";
            throw io;
        }
        catch (Error e) {
            this.state = "Stopped";
            if (logger.finerOn()) {
                logger.finer("start", "failed to start: " + e);
            }
            throw e;
        }
        Throwable failure = null;
        try {
            Set<ObjectName> mbeans = this.getConnectionFactory().getMBeanServerConnection().queryNames(this.getPattern(), this.getQuery());
            ObjectName[] names = new ObjectName[mbeans.size()];
            int count = 0;
            for (ObjectName sourceName : mbeans) {
                ObjectName targetName = this.getTargetName(sourceName);
                if (mbs.isRegistered(targetName) && !conflictAllowed) {
                    this.nameConflictDetected("start", targetName);
                    throw new InstanceAlreadyExistsException(String.valueOf(targetName));
                }
                names[count++] = sourceName;
            }
            for (int i = 0; i < count; ++i) {
                this.showMBean("start", names[i]);
            }
        }
        catch (Throwable t) {
            failure = t;
        }
        if (failure != null) {
            try {
                try {
                    this.state = "ShuttingDown";
                    if (logger.fineOn()) {
                        logger.fine("start", "Failed to start: " + this.state);
                    }
                    this.cleanup(false);
                    throw failure;
                }
                catch (IOException x) {
                    throw x;
                }
                catch (InstanceAlreadyExistsException x) {
                    throw x;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable x) {
                    IOException io = new IOException("Failed to start: " + x);
                    Utils.initCause(io, x);
                    throw io;
                }
            }
            catch (Throwable throwable) {
                this.state = "Stopped";
                if (logger.fineOn()) {
                    logger.fine("start", "Not started: " + this.state);
                }
                throw throwable;
            }
        }
        this.state = "Started";
        if (logger.fineOn()) {
            logger.fine("start", this.state);
        }
    }

    @Override
    public void stop() throws IOException {
        this.stop(false);
    }

    @Override
    public int getCascadedMBeanCount() {
        return this.getLinkedCount();
    }

    @Override
    public Set getCascadedMBeans() {
        HashSet<ObjectInstance> result = new HashSet<ObjectInstance>();
        try {
            Set<ObjectInstance> sprutstc = this.getConnectionFactory().getMBeanServerConnection().queryMBeans(this.getPattern(), this.getQuery());
            for (ObjectInstance moi : sprutstc) {
                if (!this.isLinked(moi.getObjectName())) continue;
                result.add(moi);
            }
        }
        catch (Exception x) {
            this.unexpectedException("getCascadedMBeans", this.getPattern(), x);
        }
        return result;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public synchronized boolean isActive() {
        return this.state.equals("Started");
    }

    public synchronized void update() throws IOException {
        if (!this.state.equals("Started")) {
            if (logger.finerOn()) {
                logger.finer("update", "CascadingAgent " + this.state);
            }
            return;
        }
        if (logger.finerOn()) {
            logger.finer("update", "CascadingAgent " + this.state);
        }
        ObjectName[] names = this.getLinkedSourceNames();
        HashSet<ObjectName> sprutstc = new HashSet<ObjectName>(this.getConnectionFactory().getMBeanServerConnection().queryNames(this.getPattern(), this.getQuery()));
        int len = names.length;
        MBeanServer mbs = this.getTargetMBeanServer();
        if (mbs == null) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            ObjectName targetName = this.getTargetName(names[i]);
            if (sprutstc.remove(names[i])) {
                this.showMBean("update", names[i]);
                continue;
            }
            this.hideMBean("update", names[i]);
        }
        Iterator it = sprutstc.iterator();
        while (it.hasNext()) {
            this.showMBean("update", (ObjectName)it.next());
        }
        if (logger.finerOn()) {
            logger.finer("update", "CascadingAgent updated");
        }
    }

    @Override
    public synchronized void preDeregister() throws Exception {
        if (!this.state.equals("Stopped")) {
            throw new IllegalStateException("ProxyCascadingAgent is still active.");
        }
    }

    protected Object createProxy(ObjectName sourceName, MBeanServerConnectionFactory cf) {
        return new CascadingProxy(sourceName, cf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleJMXConnectionNotification(Notification n, Object handback) {
        String nt = n.getType();
        try {
            ProxyCascadingAgent proxyCascadingAgent = this;
            synchronized (proxyCascadingAgent) {
                if (!this.state.equals("Started")) {
                    return;
                }
                if ("jmx.remote.connection.opened".equals(nt) || "jmx.remote.connection.notifs.lost".equals(nt)) {
                    this.update();
                } else if ("jmx.remote.connection.closed".equals(nt)) {
                    this.stopIfClosed();
                } else if ("jmx.remote.connection.failed".equals(nt)) {
                    this.stop(true);
                }
            }
        }
        catch (Exception x) {
            this.unexpectedException(nt, null, x);
        }
        String connectionId = ((JMXConnectionNotification)n).getConnectionId();
        JMXConnectionNotification newn = new JMXConnectionNotification(nt, this, connectionId, this.newSequenceNumber(), n.getMessage(), n.getUserData());
        this.sendNotification(newn);
    }

    protected void handleMBeanServerNotification(Notification notification, Object handback) {
        if (notification instanceof MBeanServerNotification) {
            MBeanServerNotification n = (MBeanServerNotification)notification;
            String nt = notification.getType();
            ObjectName sourceName = n.getMBeanName();
            if ("JMX.mbean.registered".equals(nt)) {
                if (this.mustCascade(sourceName)) {
                    this.showMBean(nt, sourceName);
                }
            } else if ("JMX.mbean.unregistered".equals(nt) && this.isLinked(sourceName)) {
                this.hideMBean(nt, sourceName);
            }
        }
    }

    protected boolean mustCascade(ObjectName sourceName) {
        return this.isIncluded(sourceName, this.getPattern(), this.getQuery());
    }

    synchronized void showMBean(String operation, ObjectName sourceName) {
        if (this.state.equals("Stopped")) {
            return;
        }
        if (this.state.equals("ShuttingDown")) {
            return;
        }
        MBeanServer srv = this.getTargetMBeanServer();
        if (srv == null) {
            return;
        }
        try {
            ObjectName targetName = this.getTargetName(sourceName);
            if (this.isLinked(sourceName) && srv.isRegistered(targetName)) {
                return;
            }
            Object proxy = this.getProxy(sourceName, this.getConnectionFactory());
            this.link(sourceName, proxy);
            try {
                srv.registerMBean(proxy, targetName);
                if (logger.finestOn()) {
                    logger.finest(operation, "Registered proxy: " + targetName + " for: " + sourceName);
                }
            }
            catch (InstanceAlreadyExistsException x) {
                this.unlink(sourceName);
                this.nameConflictDetected(operation, targetName);
                return;
            }
            catch (Exception x) {
                this.unlink(sourceName);
                this.unexpectedException(operation, sourceName, x);
                return;
            }
        }
        catch (Exception x) {
            this.unexpectedException(operation, sourceName, x);
        }
    }

    synchronized void hideMBean(String operation, ObjectName sourceName) {
        MBeanServer srv = this.getTargetMBeanServer();
        if (srv == null) {
            return;
        }
        if (this.state.equals("Stopped")) {
            return;
        }
        if (this.state.equals("ShuttingDown")) {
            return;
        }
        try {
            if (this.isLinked(sourceName)) {
                ObjectName targetName = this.getTargetName(sourceName);
                srv.unregisterMBean(targetName);
                if (logger.finestOn()) {
                    logger.finest(operation, "Unregistered proxy: " + targetName + " for: " + sourceName);
                }
                this.unlink(sourceName);
            }
        }
        catch (InstanceNotFoundException x) {
            return;
        }
        catch (Exception x) {
            this.unexpectedException(operation, sourceName, x);
            return;
        }
    }

    void unexpectedException(String operation, ObjectName name, Exception x) {
        logger.fine(operation, "Unexpected exception while handling " + name + ": " + x);
        logger.finest(operation, x);
    }

    void unexpectedCleanupException(ObjectName targetName, Exception x) {
        logger.finer("cleanup", "Unexpected exception while handling " + targetName + ": " + x);
        logger.finest("cleanup", x);
    }

    void nameConflictDetected(String operation, ObjectName targetName) {
        logger.fine(operation, "Name conflict detected for " + targetName);
    }

    protected final synchronized long newSequenceNumber() {
        return this.sequenceNumber++;
    }

    ObjectName getTargetName(ObjectName sourceName) {
        String path = this.getTargetPath();
        if (path == null || path.length() == 0) {
            return sourceName;
        }
        try {
            String domain = sourceName.getDomain();
            String list = sourceName.getKeyPropertyListString();
            String targetName = path + "/" + domain + ":" + list;
            return ObjectName.getInstance(targetName);
        }
        catch (MalformedObjectNameException x) {
            return sourceName;
        }
    }

    private Object getProxy(ObjectName sourceName, MBeanServerConnectionFactory cf) {
        Object proxy = this.getLinked(sourceName);
        if (proxy != null) {
            return proxy;
        }
        if (logger.finestOn()) {
            logger.finest("getProxy", "create proxy for: " + sourceName);
        }
        return this.createProxy(sourceName, cf);
    }

    private void stopIfClosed() throws IOException {
        if (!this.state.equals("Started")) {
            return;
        }
        try {
            this.getConnectionFactory().getMBeanServerConnection().getDefaultDomain();
            return;
        }
        catch (IOException x) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void stop(boolean connectionDown) throws IOException {
        if (this.state.equals("Stopped")) {
            if (logger.fineOn()) {
                logger.fine("stop", "Already " + this.state);
            }
            return;
        }
        if (!this.state.equals("Started")) {
            throw new IllegalStateException("Can't stop when state is: " + this.state);
        }
        this.state = "ShuttingDown";
        if (logger.fineOn()) {
            logger.fine("stop", this.state);
        }
        try {
            this.cleanup(connectionDown);
        }
        finally {
            this.state = "Stopped";
            if (logger.fineOn()) {
                logger.fine("stop", this.state);
            }
        }
    }

    private synchronized void cleanup(boolean connectionDown) {
        try {
            try {
                if (!connectionDown) {
                    this.getConnectionFactory().getMBeanServerConnection().removeNotificationListener(MBSDelegateObjectName, this.mbsNotifHandler, null, null);
                }
            }
            catch (Exception x) {
                this.unexpectedCleanupException(MBSDelegateObjectName, x);
            }
            try {
                this.disableConnectionNotifications();
            }
            catch (Exception x) {
                this.unexpectedCleanupException(null, x);
            }
            this.clearProxies();
        }
        catch (Exception x) {
            this.unexpectedCleanupException(null, x);
        }
    }

    private synchronized void clearProxies() {
        try {
            ObjectName[] names = this.clearLinks();
            MBeanServer mbs = this.getTargetMBeanServer();
            if (mbs == null) {
                return;
            }
            for (int i = 0; i < names.length; ++i) {
                try {
                    mbs.unregisterMBean(names[i]);
                    if (!logger.finestOn()) continue;
                    logger.finest("clearProxies", "Unregistered target proxy: " + names[i]);
                    continue;
                }
                catch (Exception x) {
                    this.unexpectedCleanupException(names[i], x);
                }
            }
        }
        catch (Exception x) {
            this.unexpectedCleanupException(null, x);
        }
    }

    private synchronized void link(ObjectName sourceName, Object targetProxy) {
        this.mbeanList.put(sourceName, targetProxy);
    }

    private synchronized void unlink(ObjectName sourceName) {
        this.mbeanList.remove(sourceName);
    }

    private synchronized ObjectName[] clearLinks() {
        ObjectName[] keys = this.getLinkedSourceNames();
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.getTargetName(keys[i]);
        }
        this.mbeanList.clear();
        return keys;
    }

    private synchronized boolean isLinked(ObjectName sourceName) {
        return this.mbeanList.get(sourceName) != null;
    }

    private synchronized Object getLinked(ObjectName sourceName) {
        return this.mbeanList.get(sourceName);
    }

    private synchronized int getLinkedCount() {
        return this.mbeanList.size();
    }

    private synchronized ObjectName[] getLinkedSourceNames() {
        ObjectName[] keys = new ObjectName[this.mbeanList.size()];
        this.mbeanList.keySet().toArray(keys);
        return keys;
    }

    private boolean isIncluded(ObjectName sourceName, ObjectName sourcePattern, QueryExp sourceQuery) {
        try {
            if (sourcePattern != null && !sourcePattern.apply(sourceName)) {
                return false;
            }
            return this.wrapper.queryNames(sourceName, sourceQuery).size() == 1;
        }
        catch (Exception x) {
            this.unexpectedException("mustCascade", sourceName, x);
            return false;
        }
    }

    static final class State {
        public static final String STARTING = "Starting";
        public static final String STARTED = "Started";
        public static final String SHUTTING_DOWN = "ShuttingDown";
        public static final String STOPPED = "Stopped";

        State() {
        }
    }
}

