/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.security.sasl.plain;

import com.sun.jdmk.security.sasl.AuthenticateCallback;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthenticationException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

final class PlainServer
implements SaslServer {
    private boolean completed;
    private CallbackHandler cbh;
    private String authorizationID;
    private static final byte SEPARATOR = 0;

    public PlainServer(CallbackHandler cbh) {
        this.cbh = cbh;
    }

    @Override
    public String getMechanismName() {
        return "PLAIN";
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        String authorizationID;
        String password;
        String authenticationID;
        if (this.completed) {
            throw new IllegalStateException("PLAIN authentication already completed");
        }
        this.completed = true;
        int indexSeparator1 = -1;
        int indexSeparator2 = -1;
        for (int i = 0; i < response.length; ++i) {
            if (response[i] != 0) continue;
            if (indexSeparator1 == -1) {
                indexSeparator1 = i;
                continue;
            }
            if (indexSeparator2 != -1) continue;
            indexSeparator2 = i;
        }
        if (indexSeparator1 < 0 || indexSeparator2 < 0 || indexSeparator1 + 1 == indexSeparator2 || indexSeparator2 + 1 == response.length) {
            throw new IllegalStateException("PLAIN authentication error: Response format should be: [authorization_id]<US-ASCII NUL>authentication_id<US-ASCII NUL>password.");
        }
        int authzidSize = indexSeparator1;
        int authnidSize = indexSeparator2 - indexSeparator1 - 1;
        int passwdSize = response.length - indexSeparator2 - 1;
        byte[] authzid = new byte[authzidSize];
        byte[] authnid = new byte[authnidSize];
        byte[] passwd = new byte[passwdSize];
        System.arraycopy(response, 0, authzid, 0, authzidSize);
        System.arraycopy(response, indexSeparator1 + 1, authnid, 0, authnidSize);
        System.arraycopy(response, indexSeparator2 + 1, passwd, 0, passwdSize);
        try {
            authenticationID = new String(authnid, "UTF-8");
            password = new String(passwd, "UTF-8");
            for (int i = 0; i < passwd.length; ++i) {
                passwd[i] = 0;
            }
            passwd = null;
            authorizationID = authzid.length == 0 ? authenticationID : new String(authzid, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SaslException("PLAIN: Cannot get UTF-8 encoding of ids", e);
        }
        this.verifyAuthenticationCredentials(authenticationID, password);
        this.verifyAuthorizationID(authenticationID, authorizationID);
        return null;
    }

    @Override
    public String getAuthorizationID() {
        return this.authorizationID;
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new SaslException("PLAIN supports neither integrity nor privacy");
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new SaslException("PLAIN supports neither integrity nor privacy");
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (this.completed) {
            if (propName.equals("javax.security.sasl.qop")) {
                return "auth";
            }
            return null;
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    @Override
    public void dispose() throws SaslException {
    }

    private void verifyAuthenticationCredentials(String username, String password) throws SaslException {
        String msg = "PLAIN: Authentication credentials verification failed!";
        char[] passwd = password.toCharArray();
        AuthenticateCallback authnCb = new AuthenticateCallback(username, passwd);
        for (int i = 0; i < passwd.length; ++i) {
            passwd[i] = 32;
        }
        passwd = null;
        try {
            this.cbh.handle(new Callback[]{authnCb});
        }
        catch (IOException e) {
            throw new SaslException("PLAIN: Authentication credentials verification failed!", e);
        }
        catch (UnsupportedCallbackException e) {
            throw new SaslException("PLAIN: Authentication credentials verification failed!", e);
        }
        authnCb.clearPassword();
        if (!authnCb.isAuthenticated()) {
            throw new AuthenticationException("PLAIN: Authentication credentials verification failed!");
        }
    }

    private void verifyAuthorizationID(String authenticationID, String authorizationID) throws SaslException {
        String msg = "PLAIN: AuthorizationID verification failed!";
        AuthorizeCallback authzCb = new AuthorizeCallback(authenticationID, authorizationID);
        try {
            this.cbh.handle(new Callback[]{authzCb});
        }
        catch (IOException e) {
            throw new SaslException("PLAIN: AuthorizationID verification failed!", e);
        }
        catch (UnsupportedCallbackException e) {
            throw new SaslException("PLAIN: AuthorizationID verification failed!", e);
        }
        if (!authzCb.isAuthorized()) {
            throw new SaslException("PLAIN: " + authenticationID + " is not authorized to act as " + authorizationID);
        }
        this.authorizationID = authzCb.getAuthorizedID();
    }
}

