/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.core.propagation;

import com.codingapi.txlcn.common.exception.TransactionException;
import com.codingapi.txlcn.tc.annotation.DTXPropagation;
import com.codingapi.txlcn.tc.core.DTXLocalContext;
import com.codingapi.txlcn.tc.core.DTXPropagationState;
import com.codingapi.txlcn.tc.core.TxTransactionInfo;
import com.codingapi.txlcn.tc.core.propagation.DTXPropagationResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultDTXPropagationResolver
implements DTXPropagationResolver {
    private static final Logger log = LoggerFactory.getLogger(DefaultDTXPropagationResolver.class);

    @Override
    public DTXPropagationState resolvePropagationState(TxTransactionInfo txTransactionInfo) throws TransactionException {
        if (DTXLocalContext.cur().isInGroup()) {
            log.info("SILENT_JOIN group!");
            return DTXPropagationState.SILENT_JOIN;
        }
        if (txTransactionInfo.isTransactionStart()) {
            if (DTXPropagation.SUPPORTS.equals((Object)txTransactionInfo.getPropagation())) {
                return DTXPropagationState.NON;
            }
            return DTXPropagationState.CREATE;
        }
        return DTXPropagationState.JOIN;
    }
}

