/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.core.transaction.tcc.control;

import com.codingapi.txlcn.common.exception.TransactionException;
import com.codingapi.txlcn.common.util.function.Supplier;
import com.codingapi.txlcn.tc.annotation.TccTransaction;
import com.codingapi.txlcn.tc.core.DTXLocalContext;
import com.codingapi.txlcn.tc.core.DTXLocalControl;
import com.codingapi.txlcn.tc.core.TccTransactionInfo;
import com.codingapi.txlcn.tc.core.TxTransactionInfo;
import com.codingapi.txlcn.tc.core.context.TCGlobalContext;
import com.codingapi.txlcn.tc.core.template.TransactionControlTemplate;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="control_tcc_starting")
public class TccStartingTransaction
implements DTXLocalControl {
    private static final Logger log = LoggerFactory.getLogger(TccStartingTransaction.class);
    private final TransactionControlTemplate transactionControlTemplate;
    private final TCGlobalContext globalContext;

    @Autowired
    public TccStartingTransaction(TransactionControlTemplate transactionControlTemplate, TCGlobalContext globalContext) {
        this.transactionControlTemplate = transactionControlTemplate;
        this.globalContext = globalContext;
    }

    static TccTransactionInfo prepareTccInfo(TxTransactionInfo info) throws TransactionException {
        Method method = info.getPointMethod();
        TccTransaction tccTransaction = method.getAnnotation(TccTransaction.class);
        if (tccTransaction == null) {
            throw new TransactionException("TCC type need @TccTransaction in " + method.getName());
        }
        String cancelMethod = tccTransaction.cancelMethod();
        String confirmMethod = tccTransaction.confirmMethod();
        Class executeClass = tccTransaction.executeClass();
        if (StringUtils.isEmpty((Object)tccTransaction.cancelMethod())) {
            cancelMethod = "cancel" + StringUtils.capitalize((String)method.getName());
        }
        if (StringUtils.isEmpty((Object)tccTransaction.confirmMethod())) {
            confirmMethod = "confirm" + StringUtils.capitalize((String)method.getName());
        }
        if (Void.class.isAssignableFrom(executeClass)) {
            executeClass = info.getTransactionInfo().getTargetClazz();
        }
        TccTransactionInfo tccInfo = new TccTransactionInfo();
        tccInfo.setExecuteClass(executeClass);
        tccInfo.setCancelMethod(cancelMethod);
        tccInfo.setConfirmMethod(confirmMethod);
        tccInfo.setMethodParameter(info.getTransactionInfo().getArgumentValues());
        tccInfo.setMethodTypeParameter(info.getTransactionInfo().getParameterTypes());
        return tccInfo;
    }

    @Override
    public void preBusinessCode(TxTransactionInfo info) throws TransactionException {
        try {
            this.globalContext.tccTransactionInfo(info.getUnitId(), (Supplier<TccTransactionInfo, TransactionException>)((Supplier)() -> TccStartingTransaction.prepareTccInfo(info))).setMethodParameter(info.getTransactionInfo().getArgumentValues());
        }
        catch (Throwable throwable) {
            throw new TransactionException(throwable);
        }
        this.transactionControlTemplate.createGroup(info.getGroupId(), info.getUnitId(), info.getTransactionInfo(), info.getTransactionType());
    }

    @Override
    public void onBusinessCodeError(TxTransactionInfo info, Throwable throwable) {
        DTXLocalContext.cur().setSysTransactionState(0);
    }

    @Override
    public void onBusinessCodeSuccess(TxTransactionInfo info, Object result) {
        DTXLocalContext.cur().setSysTransactionState(1);
    }

    @Override
    public void postBusinessCode(TxTransactionInfo info) {
        this.transactionControlTemplate.notifyGroup(info.getGroupId(), info.getUnitId(), info.getTransactionType(), DTXLocalContext.transactionState(this.globalContext.dtxState(info.getGroupId())));
    }
}

