/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.core.transaction.txc.control;

import com.codingapi.txlcn.common.exception.TransactionClearException;
import com.codingapi.txlcn.common.exception.TransactionException;
import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.tc.core.DTXLocalContext;
import com.codingapi.txlcn.tc.core.DTXLocalControl;
import com.codingapi.txlcn.tc.core.TxTransactionInfo;
import com.codingapi.txlcn.tc.core.template.TransactionCleanTemplate;
import com.codingapi.txlcn.tc.core.template.TransactionControlTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="control_txc_running")
public class TxcRunningTransaction
implements DTXLocalControl {
    private static final Logger log = LoggerFactory.getLogger(TxcRunningTransaction.class);
    private final TransactionCleanTemplate transactionCleanTemplate;
    private final TransactionControlTemplate transactionControlTemplate;
    private static final TxLogger txLogger = TxLogger.newLogger(TxcRunningTransaction.class);

    @Autowired
    public TxcRunningTransaction(TransactionCleanTemplate transactionCleanTemplate, TransactionControlTemplate transactionControlTemplate) {
        this.transactionCleanTemplate = transactionCleanTemplate;
        this.transactionControlTemplate = transactionControlTemplate;
    }

    @Override
    public void preBusinessCode(TxTransactionInfo info) {
        DTXLocalContext.makeProxy();
    }

    @Override
    public void onBusinessCodeError(TxTransactionInfo info, Throwable throwable) {
        try {
            log.debug("txc > running > clean transaction.");
            this.transactionCleanTemplate.clean(info.getGroupId(), info.getUnitId(), info.getTransactionType(), 0);
        }
        catch (TransactionClearException e) {
            log.error("txc > Clean Transaction Error", (Throwable)e);
            txLogger.trace(info.getGroupId(), info.getUnitId(), "Transaction Error", "clean transaction error", new Object[0]);
        }
    }

    @Override
    public void onBusinessCodeSuccess(TxTransactionInfo info, Object result) throws TransactionException {
        this.transactionControlTemplate.joinGroup(info.getGroupId(), info.getUnitId(), info.getTransactionType(), info.getTransactionInfo());
    }
}

