/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.corelog.aspect;

import com.codingapi.txlcn.common.exception.SerializerException;
import com.codingapi.txlcn.common.util.serializer.SerializerContext;
import com.codingapi.txlcn.tc.aspect.TransactionInfo;
import com.codingapi.txlcn.tc.corelog.aspect.AspectLog;
import com.codingapi.txlcn.tc.corelog.aspect.AspectLogHelper;
import com.codingapi.txlcn.tc.corelog.aspect.AspectLogger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AsyncH2DBAspectLogger
implements AspectLogger {
    private static final Logger log = LoggerFactory.getLogger(AsyncH2DBAspectLogger.class);
    private static final ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private final AspectLogHelper txLogHelper;

    @Autowired
    public AsyncH2DBAspectLogger(AspectLogHelper txLogHelper) {
        this.txLogHelper = txLogHelper;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            executorService.shutdown();
            try {
                executorService.awaitTermination(6L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }));
    }

    @Override
    public void trace(String groupId, String unitId, TransactionInfo transactionInfo) {
        executorService.submit(() -> {
            byte[] bytes;
            long t1 = System.currentTimeMillis();
            try {
                bytes = SerializerContext.getInstance().serialize((Object)transactionInfo);
            }
            catch (SerializerException e) {
                e.printStackTrace();
                return;
            }
            AspectLog txLog = new AspectLog();
            txLog.setBytes(bytes);
            txLog.setGroupId(groupId);
            txLog.setUnitId(unitId);
            txLog.setMethodStr(transactionInfo.getMethodStr());
            txLog.setTime(System.currentTimeMillis());
            txLog.setUnitIdHash(groupId.hashCode());
            txLog.setUnitIdHash(unitId.hashCode());
            boolean res = this.txLogHelper.save(txLog);
            long t2 = System.currentTimeMillis();
            log.debug("async save aspect log. result: {} groupId: {}, used time: {}ms", new Object[]{res, groupId, t2 - t1});
        });
    }

    @Override
    public void clearLog(String groupId, String unitId) {
        executorService.submit(() -> {
            long t1 = System.currentTimeMillis();
            boolean res = this.txLogHelper.delete(groupId.hashCode(), unitId.hashCode());
            long t2 = System.currentTimeMillis();
            log.debug("async clear aspect log. result:{}, groupId: {}, used time: {}ms", new Object[]{res, groupId, t2 - t1});
        });
    }
}

