/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.support;

import com.codingapi.txlcn.tc.core.DTXLocalControl;
import com.codingapi.txlcn.tc.core.DTXPropagationState;
import com.codingapi.txlcn.tc.core.TransactionCleanService;
import com.codingapi.txlcn.tc.support.resouce.TransactionResourceProxy;
import com.codingapi.txlcn.tc.txmsg.RpcExecuteService;
import com.codingapi.txlcn.txmsg.LCNCmdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class TxLcnBeanHelper {
    private static final Logger log = LoggerFactory.getLogger(TxLcnBeanHelper.class);
    private static final String CONTROL_BEAN_NAME_FORMAT = "control_%s_%s";
    private static final String RPC_BEAN_NAME_FORMAT = "rpc_%s_%s";
    private static final String TRANSACTION_BEAN_NAME_FORMAT = "transaction_%s";
    private static final String TRANSACTION_CLEAN_SERVICE_NAME_FORMAT = "%sTransactionCleanService";
    private final ApplicationContext spring;

    @Autowired
    public TxLcnBeanHelper(ApplicationContext spring) {
        this.spring = spring;
    }

    private String getControlBeanName(String transactionType, DTXPropagationState lcnTransactionState) {
        return String.format(CONTROL_BEAN_NAME_FORMAT, transactionType, lcnTransactionState.getCode());
    }

    private String getRpcBeanName(String transactionType, LCNCmdType cmdType) {
        if (transactionType != null) {
            String name = String.format(RPC_BEAN_NAME_FORMAT, transactionType, cmdType.getCode());
            log.debug("getRpcBeanName->{}", (Object)name);
            return name;
        }
        String name = String.format(RPC_BEAN_NAME_FORMAT.replaceFirst("_%s", ""), cmdType.getCode());
        log.debug("getRpcBeanName->{}", (Object)name);
        return name;
    }

    public TransactionResourceProxy loadTransactionResourceProxy(String beanName) {
        String name = String.format(TRANSACTION_BEAN_NAME_FORMAT, beanName);
        return (TransactionResourceProxy)this.spring.getBean(name, TransactionResourceProxy.class);
    }

    private DTXLocalControl loadDTXLocalControl(String beanName) {
        return (DTXLocalControl)this.spring.getBean(beanName, DTXLocalControl.class);
    }

    public DTXLocalControl loadDTXLocalControl(String transactionType, DTXPropagationState lcnTransactionState) {
        return this.loadDTXLocalControl(this.getControlBeanName(transactionType, lcnTransactionState));
    }

    public RpcExecuteService loadRpcExecuteService(String transactionType, LCNCmdType cmdType) {
        return this.loadRpcExecuteService(this.getRpcBeanName(transactionType, cmdType));
    }

    private RpcExecuteService loadRpcExecuteService(String beanName) {
        return (RpcExecuteService)this.spring.getBean(beanName, RpcExecuteService.class);
    }

    public TransactionCleanService loadTransactionCleanService(String transactionType) {
        return (TransactionCleanService)this.spring.getBean(String.format(TRANSACTION_CLEAN_SERVICE_NAME_FORMAT, transactionType), TransactionCleanService.class);
    }
}

