/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.txmsg;

import com.codingapi.txlcn.common.exception.LcnBusinessException;
import com.codingapi.txlcn.tc.config.TxClientConfig;
import com.codingapi.txlcn.tc.txmsg.MessageCreator;
import com.codingapi.txlcn.tc.txmsg.ReliableMessenger;
import com.codingapi.txlcn.txmsg.RpcClient;
import com.codingapi.txlcn.txmsg.dto.MessageDto;
import com.codingapi.txlcn.txmsg.exception.RpcException;
import com.codingapi.txlcn.txmsg.params.JoinGroupParams;
import com.codingapi.txlcn.txmsg.params.NotifyGroupParams;
import com.codingapi.txlcn.txmsg.util.MessageUtils;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoopMessenger
implements ReliableMessenger {
    private static final Logger log = LoggerFactory.getLogger(LoopMessenger.class);
    private final RpcClient rpcClient;
    private final TxClientConfig clientConfig;

    @Autowired
    public LoopMessenger(RpcClient rpcClient, TxClientConfig clientConfig) {
        this.rpcClient = rpcClient;
        this.clientConfig = clientConfig;
    }

    @Override
    public boolean acquireLocks(String groupId, Set<String> lockIdSet, int type) throws RpcException {
        MessageDto messageDto = this.request(MessageCreator.acquireLocks(groupId, lockIdSet, type));
        return MessageUtils.statusOk((MessageDto)messageDto);
    }

    @Override
    public void releaseLocks(Set<String> lockIdList) throws RpcException {
        MessageDto messageDto = this.request(MessageCreator.releaseLocks(lockIdList));
        if (!MessageUtils.statusOk((MessageDto)messageDto)) {
            throw new RpcException("release locks fail.");
        }
    }

    @Override
    public int notifyGroup(String groupId, int transactionState) throws RpcException, LcnBusinessException {
        NotifyGroupParams notifyGroupParams = new NotifyGroupParams();
        notifyGroupParams.setGroupId(groupId);
        notifyGroupParams.setState(transactionState);
        MessageDto messageDto = this.request0(MessageCreator.notifyGroup(notifyGroupParams), this.clientConfig.getTmRpcTimeout() * (long)this.clientConfig.getChainLevel());
        if (!MessageUtils.statusOk((MessageDto)messageDto)) {
            throw new LcnBusinessException((Throwable)messageDto.loadBean(Throwable.class));
        }
        return (Integer)messageDto.loadBean(Integer.class);
    }

    @Override
    public void joinGroup(String groupId, String unitId, String unitType, int transactionState) throws RpcException, LcnBusinessException {
        JoinGroupParams joinGroupParams = new JoinGroupParams();
        joinGroupParams.setGroupId(groupId);
        joinGroupParams.setUnitId(unitId);
        joinGroupParams.setUnitType(unitType);
        joinGroupParams.setTransactionState(transactionState);
        MessageDto messageDto = this.request(MessageCreator.joinGroup(joinGroupParams));
        if (!MessageUtils.statusOk((MessageDto)messageDto)) {
            throw new LcnBusinessException((Throwable)messageDto.loadBean(Throwable.class));
        }
    }

    @Override
    public void createGroup(String groupId) throws RpcException, LcnBusinessException {
        MessageDto messageDto = this.request(MessageCreator.createGroup(groupId));
        if (!MessageUtils.statusOk((MessageDto)messageDto)) {
            throw new LcnBusinessException((Throwable)messageDto.loadBean(Throwable.class));
        }
    }

    @Override
    public int askTransactionState(String groupId, String unitId) throws RpcException {
        MessageDto messageDto = this.request(MessageCreator.askTransactionState(groupId, unitId));
        if (MessageUtils.statusOk((MessageDto)messageDto)) {
            return (Integer)messageDto.loadBean(Integer.class);
        }
        return -1;
    }

    @Override
    public void reportInvalidTM(HashSet<String> invalidTMSet) throws RpcException {
        MessageDto messageDto = new MessageDto();
        messageDto.setAction("citm");
        messageDto.setData(invalidTMSet);
        messageDto = this.request(messageDto);
        if (!MessageUtils.statusOk((MessageDto)messageDto)) {
            throw new RpcException((Throwable)messageDto.loadBean(Throwable.class));
        }
    }

    @Override
    public HashSet<String> queryTMCluster() throws RpcException {
        MessageDto messageDto = new MessageDto();
        messageDto.setAction("qtmc");
        messageDto = this.request(messageDto);
        if (MessageUtils.statusOk((MessageDto)messageDto)) {
            return (HashSet)messageDto.loadBean(HashSet.class);
        }
        throw new RpcException((Throwable)messageDto.loadBean(Throwable.class));
    }

    @Override
    public MessageDto request(MessageDto messageDto) throws RpcException {
        return this.request0(messageDto, -1L);
    }

    private MessageDto request0(MessageDto messageDto, long timeout) throws RpcException {
        return this.request(messageDto, timeout, "request fail");
    }

    @Override
    public int clusterSize() {
        return this.rpcClient.loadAllRemoteKey().size();
    }

    private MessageDto request(MessageDto messageDto, long timeout, String whenNonManagerMessage) throws RpcException {
        for (int i = 0; i < this.rpcClient.loadAllRemoteKey().size() + 1; ++i) {
            try {
                String remoteKey = this.rpcClient.loadRemoteKey();
                MessageDto result = this.rpcClient.request(remoteKey, messageDto, timeout);
                log.debug("request action: {}. TM[{}]", (Object)messageDto.getAction(), (Object)remoteKey);
                return result;
            }
            catch (RpcException e) {
                if (e.getCode() != 40010) continue;
                throw new RpcException(e.getCode(), whenNonManagerMessage + ". non tx-manager is alive.");
            }
        }
        throw new RpcException(40010, whenNonManagerMessage + ". non tx-manager is alive.");
    }
}

