/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tracing;

import com.codingapi.txlcn.common.util.Maps;
import com.codingapi.txlcn.tracing.TracingContext;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;
import org.springframework.util.StringUtils;

public class Tracings {
    private static final Logger log = LoggerFactory.getLogger(Tracings.class);

    private Tracings() {
    }

    public static void transmit(TracingSetter tracingSetter) {
        if (TracingContext.tracing().hasGroup()) {
            log.debug("tracing transmit group:{}", (Object)TracingContext.tracing().groupId());
            tracingSetter.set("X-Group-ID", TracingContext.tracing().groupId());
            tracingSetter.set("X-App-Map", Base64Utils.encodeToString((byte[])TracingContext.tracing().appMapString().getBytes(StandardCharsets.UTF_8)));
        }
    }

    public static void apply(TracingGetter tracingGetter) {
        String groupId = Optional.ofNullable(tracingGetter.get("X-Group-ID")).orElse("");
        String appList = Optional.ofNullable(tracingGetter.get("X-App-Map")).orElse("");
        TracingContext.init(Maps.newHashMap((Object)"groupId", (Object)groupId, (Object)"appMap", (Object)(StringUtils.isEmpty((Object)appList) ? appList : new String(Base64Utils.decodeFromString((String)appList), StandardCharsets.UTF_8))));
        if (TracingContext.tracing().hasGroup()) {
            log.debug("tracing apply group:{}, app map:{}", (Object)groupId, (Object)appList);
        }
    }

    public static interface TracingGetter {
        public String get(String var1);
    }

    public static interface TracingSetter {
        public void set(String var1, String var2);
    }
}

