/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.txmsg.netty.impl;

import com.codingapi.txlcn.txmsg.RpcServerInitializer;
import com.codingapi.txlcn.txmsg.dto.ManagerProperties;
import com.codingapi.txlcn.txmsg.netty.em.NettyType;
import com.codingapi.txlcn.txmsg.netty.handler.init.NettyRpcServerChannelInitializer;
import com.codingapi.txlcn.txmsg.netty.impl.NettyContext;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class NettyRpcServerInitializer
implements RpcServerInitializer,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(NettyRpcServerInitializer.class);
    private final NettyRpcServerChannelInitializer nettyRpcServerChannelInitializer;
    private EventLoopGroup workerGroup;
    private NioEventLoopGroup bossGroup;

    @Autowired
    public NettyRpcServerInitializer(NettyRpcServerChannelInitializer nettyRpcServerChannelInitializer) {
        this.nettyRpcServerChannelInitializer = nettyRpcServerChannelInitializer;
    }

    public void init(ManagerProperties managerProperties) {
        NettyContext.type = NettyType.server;
        NettyContext.params = managerProperties;
        this.nettyRpcServerChannelInitializer.setManagerProperties(managerProperties);
        int port = managerProperties.getRpcPort();
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)this.nettyRpcServerChannelInitializer);
            if (StringUtils.hasText((String)managerProperties.getRpcHost())) {
                b.bind(managerProperties.getRpcHost(), managerProperties.getRpcPort());
            } else {
                b.bind(port);
            }
            log.info("Socket started on {}:{} ", (Object)(StringUtils.hasText((String)managerProperties.getRpcHost()) ? managerProperties.getRpcHost() : "0.0.0.0"), (Object)port);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void destroy() throws Exception {
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
        }
        log.info("server was down.");
    }
}

