/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.protobuf.schemagen;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonAnyFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonBooleanFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNullFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.DataType;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.TypeElement;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.DefinedTypeElementBuilders;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.EnumElementVisitor;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.MessageElementVisitor;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.ProtobufSchemaHelper;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.TypeElementBuilder;
import java.util.LinkedHashSet;
import java.util.Set;

public class ProtoBufSchemaVisitor
extends JsonFormatVisitorWrapper.Base
implements TypeElementBuilder {
    protected final DefinedTypeElementBuilders _definedTypeElementBuilders;
    protected TypeElementBuilder _builder;
    protected DataType _simpleType;
    protected boolean _isNested;

    protected ProtoBufSchemaVisitor() {
        this(null, new DefinedTypeElementBuilders(), false);
    }

    public ProtoBufSchemaVisitor(SerializerProvider provider, DefinedTypeElementBuilders defBuilders, boolean isNested) {
        super(provider);
        this._definedTypeElementBuilders = defBuilders;
        this._isNested = isNested;
    }

    @Override
    public TypeElement build() {
        return this._builder.build();
    }

    public DataType getSimpleType() {
        return this._simpleType;
    }

    public Set<TypeElement> buildWithDependencies() {
        LinkedHashSet<TypeElement> allTypeElements = new LinkedHashSet<TypeElement>();
        allTypeElements.add(this.build());
        for (TypeElementBuilder builder : this._definedTypeElementBuilders.getDependencyBuilders()) {
            allTypeElements.add(builder.build());
        }
        return allTypeElements;
    }

    public JsonObjectFormatVisitor expectObjectFormat(JavaType type) {
        MessageElementVisitor visitor = new MessageElementVisitor(this._provider, type, this._definedTypeElementBuilders, this._isNested);
        this._builder = visitor;
        this._definedTypeElementBuilders.addTypeElement(type, visitor, this._isNested);
        return visitor;
    }

    public JsonMapFormatVisitor expectMapFormat(JavaType mapType) {
        return (JsonMapFormatVisitor)this._throwUnsupported("'Map' type not supported as type by protobuf module");
    }

    public JsonArrayFormatVisitor expectArrayFormat(JavaType type) {
        if (ProtobufSchemaHelper.isBinaryType(type)) {
            this._simpleType = DataType.ScalarType.BYTES;
            return null;
        }
        return (JsonArrayFormatVisitor)this._throwUnsupported("'Map' type not supported as type by protobuf module");
    }

    public JsonStringFormatVisitor expectStringFormat(JavaType type) {
        if (type.isEnumType()) {
            EnumElementVisitor visitor = new EnumElementVisitor(this._provider, type, this._definedTypeElementBuilders, this._isNested);
            this._builder = visitor;
            this._definedTypeElementBuilders.addTypeElement(type, visitor, this._isNested);
            return visitor;
        }
        this._simpleType = ProtobufSchemaHelper.isBinaryType(type) ? DataType.ScalarType.BYTES : DataType.ScalarType.STRING;
        return null;
    }

    public JsonNumberFormatVisitor expectNumberFormat(JavaType type) {
        this._simpleType = DataType.ScalarType.DOUBLE;
        return new JsonNumberFormatVisitor.Base(){

            public void numberType(JsonParser.NumberType nt) {
                switch (nt) {
                    case FLOAT: {
                        ProtoBufSchemaVisitor.this._simpleType = DataType.ScalarType.FLOAT;
                        break;
                    }
                    case BIG_DECIMAL: 
                    case DOUBLE: {
                        ProtoBufSchemaVisitor.this._simpleType = DataType.ScalarType.DOUBLE;
                        break;
                    }
                }
            }
        };
    }

    public JsonIntegerFormatVisitor expectIntegerFormat(JavaType type) {
        this._simpleType = DataType.ScalarType.INT64;
        return new JsonIntegerFormatVisitor.Base(){

            public void numberType(JsonParser.NumberType nt) {
                switch (nt) {
                    case INT: {
                        ProtoBufSchemaVisitor.this._simpleType = DataType.ScalarType.INT32;
                        break;
                    }
                    case LONG: 
                    case BIG_INTEGER: {
                        ProtoBufSchemaVisitor.this._simpleType = DataType.ScalarType.INT64;
                        break;
                    }
                }
            }
        };
    }

    public JsonBooleanFormatVisitor expectBooleanFormat(JavaType convertedType) {
        this._simpleType = DataType.ScalarType.BOOL;
        return null;
    }

    public JsonNullFormatVisitor expectNullFormat(JavaType convertedType) {
        return (JsonNullFormatVisitor)this._throwUnsupported("'Null type' not supported as a type by protobuf");
    }

    public JsonAnyFormatVisitor expectAnyFormat(JavaType convertedType) {
        return (JsonAnyFormatVisitor)this._throwUnsupported("'Any' type not supported as a type by protobuf");
    }

    protected <T> T _throwUnsupported() {
        return this._throwUnsupported("Format variation not supported");
    }

    protected <T> T _throwUnsupported(String msg) {
        throw new UnsupportedOperationException(msg);
    }
}

