/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.ser;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.dataformat.xml.XmlPrettyPrinter;
import com.fasterxml.jackson.dataformat.xml.util.DefaultXmlPrettyPrinter;
import com.fasterxml.jackson.dataformat.xml.util.StaxUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.ri.Stax2WriterAdapter;

public final class ToXmlGenerator
extends GeneratorBase {
    protected static final String DEFAULT_UNKNOWN_ELEMENT = "unknown";
    protected final XMLStreamWriter2 _xmlWriter;
    protected final XMLStreamWriter _originalXmlWriter;
    protected final boolean _stax2Emulation;
    protected final IOContext _ioContext;
    protected int _xmlFeatures;
    protected XmlPrettyPrinter _xmlPrettyPrinter;
    protected boolean _initialized;
    protected QName _nextName = null;
    protected boolean _nextIsAttribute = false;
    protected boolean _nextIsUnwrapped = false;
    protected LinkedList<QName> _elementNameStack = new LinkedList();

    public ToXmlGenerator(IOContext iOContext, int n, int n2, ObjectCodec objectCodec, XMLStreamWriter xMLStreamWriter) {
        super(n, objectCodec);
        this._xmlFeatures = n2;
        this._ioContext = iOContext;
        this._originalXmlWriter = xMLStreamWriter;
        this._xmlWriter = Stax2WriterAdapter.wrapIfNecessary((XMLStreamWriter)xMLStreamWriter);
        this._stax2Emulation = this._xmlWriter != xMLStreamWriter;
        this._xmlPrettyPrinter = this._cfgPrettyPrinter instanceof XmlPrettyPrinter ? (XmlPrettyPrinter)this._cfgPrettyPrinter : null;
    }

    public void initGenerator() throws IOException, JsonGenerationException {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
        try {
            if ((this._xmlFeatures & Feature.WRITE_XML_1_1.getMask()) != 0) {
                this._xmlWriter.writeStartDocument("UTF-8", "1.1");
            } else if ((this._xmlFeatures & Feature.WRITE_XML_DECLARATION.getMask()) != 0) {
                this._xmlWriter.writeStartDocument("UTF-8", "1.0");
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    public ToXmlGenerator enable(Feature feature) {
        this._xmlFeatures |= feature.getMask();
        return this;
    }

    public ToXmlGenerator disable(Feature feature) {
        this._xmlFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(Feature feature) {
        return (this._xmlFeatures & feature.getMask()) != 0;
    }

    public ToXmlGenerator configure(Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public XMLStreamWriter getStaxWriter() {
        return this._xmlWriter;
    }

    public void setNextIsAttribute(boolean bl) {
        this._nextIsAttribute = bl;
    }

    public void setNextIsUnwrapped(boolean bl) {
        this._nextIsUnwrapped = bl;
    }

    public final void setNextName(QName qName) {
        this._nextName = qName;
    }

    public final boolean setNextNameIfMissing(QName qName) {
        if (this._nextName == null) {
            this._nextName = qName;
            return true;
        }
        return false;
    }

    public void startWrappedValue(QName qName, QName qName2) throws IOException, JsonGenerationException {
        if (qName != null) {
            try {
                if (this._xmlPrettyPrinter != null) {
                    this._xmlPrettyPrinter.writeStartElement(this._xmlWriter, qName.getNamespaceURI(), qName.getLocalPart());
                } else {
                    this._xmlWriter.writeStartElement(qName.getNamespaceURI(), qName.getLocalPart());
                }
            }
            catch (XMLStreamException xMLStreamException) {
                StaxUtil.throwXmlAsIOException(xMLStreamException);
            }
        }
        this.setNextName(qName2);
    }

    public void finishWrappedValue(QName qName, QName qName2) throws IOException, JsonGenerationException {
        if (qName != null) {
            try {
                if (this._xmlPrettyPrinter != null) {
                    this._xmlPrettyPrinter.writeEndElement(this._xmlWriter, this._writeContext.getEntryCount());
                } else {
                    this._xmlWriter.writeEndElement();
                }
            }
            catch (XMLStreamException xMLStreamException) {
                StaxUtil.throwXmlAsIOException(xMLStreamException);
            }
        }
    }

    public final void writeFieldName(String string) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(string) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        String string2 = this._nextName == null ? "" : this._nextName.getNamespaceURI();
        this.setNextName(new QName(string2, string));
    }

    public final void writeStringField(String string, String string2) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeString(string2);
    }

    public final void writeStartArray() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray((JsonGenerator)this);
        }
    }

    public final void writeEndArray() throws IOException, JsonGenerationException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndArray((JsonGenerator)this, this._writeContext.getEntryCount());
        }
        this._writeContext = this._writeContext.getParent();
    }

    public final void writeStartObject() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject((JsonGenerator)this);
        } else {
            this._handleStartObject();
        }
    }

    public final void writeEndObject() throws IOException, JsonGenerationException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        if (this._cfgPrettyPrinter != null) {
            int n = this._nextIsAttribute ? 0 : this._writeContext.getEntryCount();
            this._cfgPrettyPrinter.writeEndObject((JsonGenerator)this, n);
        } else {
            this._handleEndObject();
        }
    }

    public final void _handleStartObject() throws IOException, JsonGenerationException {
        if (this._nextName == null) {
            this.handleMissingName();
        }
        this._elementNameStack.addLast(this._nextName);
        try {
            this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    public final void _handleEndObject() throws IOException, JsonGenerationException {
        if (this._elementNameStack.isEmpty()) {
            throw new JsonGenerationException("Can not write END_ELEMENT without open START_ELEMENT");
        }
        this._nextName = this._elementNameStack.removeLast();
        try {
            this._nextIsAttribute = false;
            this._xmlWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    public void writeFieldName(SerializableString serializableString) throws IOException, JsonGenerationException {
        this.writeFieldName(serializableString.getValue());
    }

    public void writeString(String string) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write String value");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeAttribute(this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), string);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeCharacters(string);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), string);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeCharacters(string);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    public void writeString(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write String value");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeAttribute(this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), new String(cArray, n, n2));
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeCharacters(cArray, n, n2);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), cArray, n, n2);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeCharacters(cArray, n, n2);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    public void writeString(SerializableString serializableString) throws IOException, JsonGenerationException {
        this.writeString(serializableString.getValue());
    }

    public void writeRawUTF8String(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeUTF8String(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(String string) throws IOException, JsonGenerationException {
        if (this._stax2Emulation) {
            this._reportUnimplementedStax2("writeRaw");
        }
        try {
            this._xmlWriter.writeRaw(string);
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    public void writeRaw(String string, int n, int n2) throws IOException, JsonGenerationException {
        if (this._stax2Emulation) {
            this._reportUnimplementedStax2("writeRaw");
        }
        try {
            this._xmlWriter.writeRaw(string, n, n2);
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    public void writeRaw(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        if (this._stax2Emulation) {
            this._reportUnimplementedStax2("writeRaw");
        }
        try {
            this._xmlWriter.writeRaw(cArray, n, n2);
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    public void writeRaw(char c) throws IOException, JsonGenerationException {
        this.writeRaw(String.valueOf(c));
    }

    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        if (byArray == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                byte[] byArray2 = this.toFullBuffer(byArray, n, n2);
                this._xmlWriter.writeBinaryAttribute("", this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), byArray2);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeBinary(byArray, n, n2);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), byArray, n, n2);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeBinary(byArray, n, n2);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    private byte[] toFullBuffer(byte[] byArray, int n, int n2) {
        if (n == 0 && n2 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        if (n2 > 0) {
            System.arraycopy(byArray, n, byArray2, 0, n2);
        }
        return byArray2;
    }

    public void writeBoolean(boolean bl) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write boolean value");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeBooleanAttribute(null, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), bl);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeBoolean(bl);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), bl);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeBoolean(bl);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    public void writeNull() throws IOException, JsonGenerationException {
        this._verifyValueWrite("write null value");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (!this._nextIsAttribute && !this.checkNextIsUnwrapped()) {
                if (this._xmlPrettyPrinter != null) {
                    this._xmlPrettyPrinter.writeLeafNullElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                } else {
                    this._xmlWriter.writeEmptyElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    public void writeNumber(int n) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeIntAttribute(null, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), n);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeInt(n);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), n);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeInt(n);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    public void writeNumber(long l) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeLongAttribute(null, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), l);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeLong(l);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), l);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeLong(l);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    public void writeNumber(double d) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeDoubleAttribute(null, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), d);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeDouble(d);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), d);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeDouble(d);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    public void writeNumber(float f) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeFloatAttribute(null, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), f);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeFloat(f);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), f);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeFloat(f);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    public void writeNumber(BigDecimal bigDecimal) throws IOException, JsonGenerationException {
        if (bigDecimal == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeDecimalAttribute(null, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), bigDecimal);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeDecimal(bigDecimal);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), bigDecimal);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeDecimal(bigDecimal);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    public void writeNumber(BigInteger bigInteger) throws IOException, JsonGenerationException {
        if (bigInteger == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        if (this._nextName == null) {
            this.handleMissingName();
        }
        try {
            if (this._nextIsAttribute) {
                this._xmlWriter.writeIntegerAttribute(null, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), bigInteger);
            } else if (this.checkNextIsUnwrapped()) {
                this._xmlWriter.writeInteger(bigInteger);
            } else if (this._xmlPrettyPrinter != null) {
                this._xmlPrettyPrinter.writeLeafElement(this._xmlWriter, this._nextName.getNamespaceURI(), this._nextName.getLocalPart(), bigInteger);
            } else {
                this._xmlWriter.writeStartElement(this._nextName.getNamespaceURI(), this._nextName.getLocalPart());
                this._xmlWriter.writeInteger(bigInteger);
                this._xmlWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    public void writeNumber(String string) throws IOException, JsonGenerationException, UnsupportedOperationException {
        this.writeString(string);
    }

    protected final void _verifyValueWrite(String string) throws IOException, JsonGenerationException {
        int n = this._writeContext.writeValue();
        if (n == 5) {
            this._reportError("Can not " + string + ", expecting field name");
        }
    }

    public final JsonGenerator useDefaultPrettyPrinter() {
        return this.setPrettyPrinter(new DefaultXmlPrettyPrinter());
    }

    public JsonGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        this._cfgPrettyPrinter = prettyPrinter;
        this._xmlPrettyPrinter = prettyPrinter instanceof XmlPrettyPrinter ? (XmlPrettyPrinter)prettyPrinter : null;
        return this;
    }

    public final void flush() throws IOException {
        if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
            try {
                this._xmlWriter.flush();
            }
            catch (XMLStreamException xMLStreamException) {
                StaxUtil.throwXmlAsIOException(xMLStreamException);
            }
        }
    }

    public void close() throws IOException {
        super.close();
        if (this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
            try {
                while (true) {
                    JsonWriteContext jsonWriteContext;
                    if ((jsonWriteContext = this.getOutputContext()).inArray()) {
                        this.writeEndArray();
                        continue;
                    }
                    if (jsonWriteContext.inObject()) {
                        this.writeEndObject();
                        continue;
                    }
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new JsonGenerationException((Throwable)arrayIndexOutOfBoundsException);
            }
        }
        try {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
                this._xmlWriter.closeCompletely();
            } else {
                this._xmlWriter.close();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    protected void _releaseBuffers() {
    }

    protected boolean checkNextIsUnwrapped() {
        if (this._nextIsUnwrapped) {
            this._nextIsUnwrapped = false;
            return true;
        }
        return false;
    }

    protected void handleMissingName() {
        throw new IllegalStateException("No element/attribute name specified when trying to output element");
    }

    protected void _reportUnimplementedStax2(String string) throws IOException {
        throw new JsonGenerationException("Underlying Stax XMLStreamWriter (of type " + this._originalXmlWriter.getClass().getName() + ") does not implement Stax2 API natively and is missing method '" + string + "': this breaks functionality such as indentation that relies on it. " + "You need to upgrade to using compliant Stax implementation like Woodstox or Aalto");
    }

    public static enum Feature {
        WRITE_XML_DECLARATION(false),
        WRITE_XML_1_1(false);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n |= feature.getMask();
            }
            return n;
        }

        private Feature(boolean bl) {
            this._defaultState = bl;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

