/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.util;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.type.ClassKey;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.fasterxml.jackson.dataformat.xml.XmlAnnotationIntrospector;
import java.io.Serializable;
import javax.xml.namespace.QName;

public class XmlRootNameLookup
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final LRUMap<ClassKey, QName> _rootNames = new LRUMap(40, 200);

    public QName findRootName(JavaType javaType, MapperConfig<?> mapperConfig) {
        return this.findRootName(javaType.getRawClass(), mapperConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QName findRootName(Class<?> clazz, MapperConfig<?> mapperConfig) {
        QName qName;
        ClassKey classKey = new ClassKey(clazz);
        LRUMap<ClassKey, QName> lRUMap = this._rootNames;
        synchronized (lRUMap) {
            qName = (QName)this._rootNames.get((Object)classKey);
            if (qName == null) {
                BeanDescription beanDescription = mapperConfig.introspectClassAnnotations(clazz);
                AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
                AnnotatedClass annotatedClass = beanDescription.getClassInfo();
                String string = null;
                String string2 = null;
                PropertyName propertyName = annotationIntrospector.findRootName(annotatedClass);
                if (propertyName != null) {
                    string = propertyName.getSimpleName();
                    string2 = propertyName.getNamespace();
                }
                if (string == null || string.length() == 0) {
                    string = clazz.getSimpleName();
                    qName = new QName("", string);
                } else if (string2 == null || string2.length() == 0) {
                    string2 = this.findNamespace(annotationIntrospector, annotatedClass);
                }
                if (string2 == null) {
                    string2 = "";
                }
                qName = new QName(string2, string);
                this._rootNames.put((Object)classKey, (Object)qName);
            }
        }
        return qName;
    }

    private String findNamespace(AnnotationIntrospector annotationIntrospector, AnnotatedClass annotatedClass) {
        for (AnnotationIntrospector annotationIntrospector2 : annotationIntrospector.allIntrospectors()) {
            String string;
            if (!(annotationIntrospector2 instanceof XmlAnnotationIntrospector) || (string = ((XmlAnnotationIntrospector)annotationIntrospector2).findNamespace((Annotated)annotatedClass)) == null) continue;
            return string;
        }
        return null;
    }
}

