/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.hibernate4;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.datatype.hibernate4.Hibernate4Module;
import java.io.IOException;
import javax.persistence.ElementCollection;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.hibernate.collection.spi.PersistentCollection;

public class PersistentCollectionSerializer
extends JsonSerializer<Object>
implements ContextualSerializer {
    protected final int _features;
    protected final JsonSerializer<Object> _serializer;

    public PersistentCollectionSerializer(JsonSerializer<?> serializer, int features) {
        this._serializer = serializer;
        this._features = features;
    }

    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer ser = provider.handlePrimaryContextualization(this._serializer, property);
        if (Hibernate4Module.Feature.FORCE_LAZY_LOADING.enabledIn(this._features) || !this.usesLazyLoading(property)) {
            return ser;
        }
        if (ser != this._serializer) {
            return new PersistentCollectionSerializer(ser, this._features);
        }
        return this;
    }

    public boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof PersistentCollection) {
            return this.findLazyValue((PersistentCollection)value) == null;
        }
        return false;
    }

    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (value instanceof PersistentCollection && (value = this.findLazyValue((PersistentCollection)value)) == null) {
            provider.defaultSerializeNull(jgen);
            return;
        }
        if (this._serializer == null) {
            throw new JsonMappingException("PersistentCollection does not have serializer set");
        }
        this._serializer.serialize(value, jgen, provider);
    }

    public void serializeWithType(Object value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        if (value instanceof PersistentCollection && (value = this.findLazyValue((PersistentCollection)value)) == null) {
            provider.defaultSerializeNull(jgen);
            return;
        }
        if (this._serializer == null) {
            throw new JsonMappingException("PersistentCollection does not have serializer set");
        }
        this._serializer.serializeWithType(value, jgen, provider, typeSer);
    }

    protected Object findLazyValue(PersistentCollection coll) {
        if (!Hibernate4Module.Feature.FORCE_LAZY_LOADING.enabledIn(this._features) && !coll.wasInitialized()) {
            return null;
        }
        return coll.getValue();
    }

    protected boolean usesLazyLoading(BeanProperty property) {
        if (property != null) {
            ElementCollection ec = (ElementCollection)property.getAnnotation(ElementCollection.class);
            if (ec != null) {
                return ec.fetch() == FetchType.LAZY;
            }
            OneToMany ann1 = (OneToMany)property.getAnnotation(OneToMany.class);
            if (ann1 != null) {
                return ann1.fetch() == FetchType.LAZY;
            }
            OneToOne ann2 = (OneToOne)property.getAnnotation(OneToOne.class);
            if (ann2 != null) {
                return ann2.fetch() == FetchType.LAZY;
            }
            ManyToOne ann3 = (ManyToOne)property.getAnnotation(ManyToOne.class);
            if (ann3 != null) {
                return ann3.fetch() == FetchType.LAZY;
            }
            ManyToMany ann4 = (ManyToMany)property.getAnnotation(ManyToMany.class);
            if (ann4 != null) {
                return ann4.fetch() == FetchType.LAZY;
            }
            return !Hibernate4Module.Feature.REQUIRE_EXPLICIT_LAZY_LOADING_MARKER.enabledIn(this._features);
        }
        return false;
    }
}

