/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.hppc;

import com.carrotsearch.hppc.ObjectContainer;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.type.TypeModifier;
import com.fasterxml.jackson.datatype.hppc.PackageVersion;
import com.fasterxml.jackson.datatype.hppc.deser.HppcDeserializers;
import com.fasterxml.jackson.datatype.hppc.ser.HppcSerializers;
import java.lang.reflect.Type;

public class HppcModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    public HppcModule() {
        super("HppcDatatypeModule", PackageVersion.VERSION);
    }

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        context.addTypeModifier((TypeModifier)new HppcTypeModifier());
        context.addDeserializers((Deserializers)new HppcDeserializers());
        context.addSerializers((Serializers)new HppcSerializers());
    }

    static class HppcTypeModifier
    extends TypeModifier {
        HppcTypeModifier() {
        }

        public JavaType modifyType(JavaType type, Type jdkType, TypeBindings bindings, TypeFactory typeFactory) {
            Class raw = type.getRawClass();
            if (ObjectContainer.class.isAssignableFrom(raw)) {
                JavaType[] params = typeFactory.findTypeParameters(type, ObjectContainer.class);
                return typeFactory.constructCollectionLikeType(raw, params[0]);
            }
            return type;
        }
    }
}

