/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.hppc.ser;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.ByteContainer;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.DoubleContainer;
import com.carrotsearch.hppc.DoubleIndexedContainer;
import com.carrotsearch.hppc.FloatContainer;
import com.carrotsearch.hppc.FloatIndexedContainer;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntIndexedContainer;
import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongIndexedContainer;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortIndexedContainer;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.datatype.hppc.ser.ContainerSerializerBase;
import com.fasterxml.jackson.datatype.hppc.ser.ExceptionHolder;
import java.io.IOException;
import java.lang.reflect.Type;

public class HppcContainerSerializers {
    public static final ContainerSerializerBase<?>[] _primitiveSerializers = new ContainerSerializerBase[]{new ByteContainerSerializer(), new ShortContainerSerializer(), new IntContainerSerializer(), new LongContainerSerializer(), new CharContainerSerializer(), new FloatContainerSerializer(), new DoubleContainerSerializer(), new BitSetSerializer()};

    public static JsonSerializer<?> getMatchingSerializer(SerializationConfig config, JavaType type) {
        for (ContainerSerializerBase<?> ser : _primitiveSerializers) {
            JsonSerializer<?> actual = ser.getSerializer(type);
            if (actual == null) continue;
            return actual;
        }
        return null;
    }

    static final class BitSetSerializer
    extends ContainerSerializerBase<BitSet> {
        private static final long serialVersionUID = 1L;

        BitSetSerializer() {
            super(BitSet.class, "boolean");
        }

        @Override
        public boolean isEmpty(SerializerProvider provider, BitSet value) {
            return value.isEmpty();
        }

        public boolean hasSingleElement(BitSet value) {
            return value.size() == 1L;
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            JsonArrayFormatVisitor v2;
            if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
                v2.itemsFormat(JsonFormatTypes.BOOLEAN);
            }
        }

        @Override
        protected void serializeContents(BitSet value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (!value.isEmpty()) {
                int len = (int)value.size();
                for (int i = 0; i < len; ++i) {
                    gen.writeBoolean(value.get(i));
                }
            }
        }
    }

    static final class DoubleContainerSerializer
    extends ContainerSerializerBase<DoubleContainer> {
        private static final long serialVersionUID = 1L;

        DoubleContainerSerializer() {
            super(DoubleContainer.class, "number");
        }

        @Override
        public boolean isEmpty(SerializerProvider provider, DoubleContainer value) {
            return value.isEmpty();
        }

        public boolean hasSingleElement(DoubleContainer value) {
            return value.size() == 1;
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            JsonArrayFormatVisitor v2;
            if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
                v2.itemsFormat(JsonFormatTypes.NUMBER);
            }
        }

        @Override
        protected void serializeContents(DoubleContainer value, final JsonGenerator gen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (value instanceof DoubleIndexedContainer) {
                DoubleIndexedContainer list = (DoubleIndexedContainer)value;
                int len = list.size();
                for (int i = 0; i < len; ++i) {
                    gen.writeNumber(list.get(i));
                }
                return;
            }
            final ExceptionHolder holder = new ExceptionHolder();
            value.forEach(new DoublePredicate(){

                public boolean apply(double v) {
                    try {
                        gen.writeNumber(v);
                    }
                    catch (IOException e) {
                        holder.assignException(e);
                        return false;
                    }
                    return true;
                }
            });
            holder.throwHeld();
        }
    }

    static final class FloatContainerSerializer
    extends ContainerSerializerBase<FloatContainer> {
        private static final long serialVersionUID = 1L;

        FloatContainerSerializer() {
            super(FloatContainer.class, "number");
        }

        @Override
        public boolean isEmpty(SerializerProvider provider, FloatContainer value) {
            return value.isEmpty();
        }

        public boolean hasSingleElement(FloatContainer value) {
            return value.size() == 1;
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            JsonArrayFormatVisitor v2;
            if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
                v2.itemsFormat(JsonFormatTypes.NUMBER);
            }
        }

        @Override
        protected void serializeContents(FloatContainer value, final JsonGenerator gen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (value instanceof FloatIndexedContainer) {
                FloatIndexedContainer list = (FloatIndexedContainer)value;
                int len = list.size();
                for (int i = 0; i < len; ++i) {
                    gen.writeNumber(list.get(i));
                }
                return;
            }
            final ExceptionHolder holder = new ExceptionHolder();
            value.forEach(new FloatPredicate(){

                public boolean apply(float v) {
                    try {
                        gen.writeNumber(v);
                    }
                    catch (IOException e) {
                        holder.assignException(e);
                        return false;
                    }
                    return true;
                }
            });
            holder.throwHeld();
        }
    }

    static final class CharContainerSerializer
    extends ContainerSerializerBase<CharContainer> {
        private static final long serialVersionUID = 1L;

        CharContainerSerializer() {
            super(CharContainer.class, "string");
        }

        @Override
        public boolean isEmpty(SerializerProvider provider, CharContainer value) {
            return value.isEmpty();
        }

        public boolean hasSingleElement(CharContainer value) {
            return value.size() == 1;
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            if (visitor != null) {
                visitor.expectStringFormat(typeHint);
            }
        }

        @Override
        public void serialize(CharContainer value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.assignCurrentValue((Object)value);
            this.serializeContents(value, gen, provider);
        }

        @Override
        public void serializeWithType(CharContainer value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
            gen.assignCurrentValue((Object)value);
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId((Object)value, JsonToken.VALUE_STRING));
            this.serializeContents(value, gen, provider);
            typeSer.writeTypeSuffix(gen, typeIdDef);
        }

        @Override
        protected void serializeContents(CharContainer value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            char[] ch = value.toArray();
            gen.writeString(ch, 0, ch.length);
        }
    }

    static final class LongContainerSerializer
    extends ContainerSerializerBase<LongContainer> {
        private static final long serialVersionUID = 1L;

        LongContainerSerializer() {
            super(LongContainer.class, "integer");
        }

        @Override
        public boolean isEmpty(SerializerProvider provider, LongContainer value) {
            return value.isEmpty();
        }

        public boolean hasSingleElement(LongContainer value) {
            return value.size() == 1;
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            JsonArrayFormatVisitor v2;
            if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
                v2.itemsFormat(JsonFormatTypes.INTEGER);
            }
        }

        @Override
        protected void serializeContents(LongContainer value, final JsonGenerator gen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (value instanceof LongIndexedContainer) {
                LongIndexedContainer list = (LongIndexedContainer)value;
                long[] array = value instanceof LongArrayList ? ((LongArrayList)value).buffer : list.toArray();
                int len = list.size();
                for (int i = 0; i < len; ++i) {
                    gen.writeNumber(array[i]);
                }
                return;
            }
            final ExceptionHolder holder = new ExceptionHolder();
            value.forEach(new LongPredicate(){

                public boolean apply(long v) {
                    try {
                        gen.writeNumber(v);
                    }
                    catch (IOException e) {
                        holder.assignException(e);
                        return false;
                    }
                    return true;
                }
            });
            holder.throwHeld();
        }
    }

    static class IntContainerSerializer
    extends ContainerSerializerBase<IntContainer> {
        private static final long serialVersionUID = 1L;

        IntContainerSerializer() {
            super(IntContainer.class, "integer");
        }

        @Override
        public JsonSerializer<?> getSerializer(JavaType type) {
            JsonSerializer<?> ser = super.getSerializer(type);
            if (ser != null && IntIndexedContainer.class.isAssignableFrom(type.getClass())) {
                return new Indexed();
            }
            return ser;
        }

        @Override
        public boolean isEmpty(SerializerProvider provider, IntContainer value) {
            return value.isEmpty();
        }

        public boolean hasSingleElement(IntContainer value) {
            return value.size() == 1;
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            JsonArrayFormatVisitor v2;
            if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
                v2.itemsFormat(JsonFormatTypes.INTEGER);
            }
        }

        @Override
        protected void serializeContents(IntContainer value, final JsonGenerator gen, SerializerProvider provider) throws IOException, JsonGenerationException {
            final ExceptionHolder holder = new ExceptionHolder();
            value.forEach(new IntPredicate(){

                public boolean apply(int v) {
                    try {
                        gen.writeNumber(v);
                    }
                    catch (IOException e) {
                        holder.assignException(e);
                        return false;
                    }
                    return true;
                }
            });
            holder.throwHeld();
        }

        static class Indexed
        extends ContainerSerializerBase<IntIndexedContainer> {
            private static final long serialVersionUID = 1L;

            Indexed() {
                super(IntIndexedContainer.class, "integer");
            }

            @Override
            public boolean isEmpty(SerializerProvider provider, IntIndexedContainer value) {
                return value.isEmpty();
            }

            public boolean hasSingleElement(IntIndexedContainer value) {
                return value.size() == 1;
            }

            @Override
            public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
                JsonArrayFormatVisitor v2;
                if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
                    v2.itemsFormat(JsonFormatTypes.INTEGER);
                }
            }

            @Override
            protected void serializeContents(IntIndexedContainer value, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonGenerationException {
                int[] array = value instanceof IntArrayList ? ((IntArrayList)value).buffer : value.toArray();
                int len = value.size();
                for (int i = 0; i < len; ++i) {
                    gen.writeNumber(array[i]);
                }
            }
        }
    }

    static final class ShortContainerSerializer
    extends ContainerSerializerBase<ShortContainer> {
        private static final long serialVersionUID = 1L;

        ShortContainerSerializer() {
            super(ShortContainer.class, "integer");
        }

        @Override
        public boolean isEmpty(SerializerProvider provider, ShortContainer value) {
            return value.isEmpty();
        }

        public boolean hasSingleElement(ShortContainer value) {
            return value.size() == 1;
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            JsonArrayFormatVisitor v2;
            if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
                v2.itemsFormat(JsonFormatTypes.INTEGER);
            }
        }

        @Override
        protected void serializeContents(ShortContainer value, final JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (value instanceof ShortIndexedContainer) {
                ShortIndexedContainer list = (ShortIndexedContainer)value;
                int len = list.size();
                for (int i = 0; i < len; ++i) {
                    gen.writeNumber(list.get(i));
                }
                return;
            }
            final ExceptionHolder holder = new ExceptionHolder();
            value.forEach(new ShortPredicate(){

                public boolean apply(short v) {
                    try {
                        gen.writeNumber(v);
                    }
                    catch (IOException e) {
                        holder.assignException(e);
                        return false;
                    }
                    return true;
                }
            });
            holder.throwHeld();
        }
    }

    static class ByteContainerSerializer
    extends ContainerSerializerBase<ByteContainer> {
        private static final long serialVersionUID = 1L;

        ByteContainerSerializer() {
            super(ByteContainer.class, "string");
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("string", true);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            if (visitor != null) {
                visitor.expectStringFormat(typeHint);
            }
        }

        @Override
        public boolean isEmpty(SerializerProvider provider, ByteContainer value) {
            return value.isEmpty();
        }

        public boolean hasSingleElement(ByteContainer value) {
            return value.size() == 1;
        }

        @Override
        public void serialize(ByteContainer value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.assignCurrentValue((Object)value);
            this.serializeContents(value, gen, provider);
        }

        @Override
        public void serializeWithType(ByteContainer value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
            gen.assignCurrentValue((Object)value);
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId((Object)value, JsonToken.VALUE_EMBEDDED_OBJECT));
            this.serializeContents(value, gen, provider);
            typeSer.writeTypeSuffix(gen, typeIdDef);
        }

        @Override
        protected void serializeContents(ByteContainer value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeBinary(value.toArray());
        }
    }
}

