/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.hppc.ser;

import com.carrotsearch.hppc.ObjectContainer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.ObjectArraySerializer;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.datatype.hppc.ser.ContainerSerializerBase;
import java.io.IOException;

public class ObjectContainerSerializer
extends ContainerSerializerBase<ObjectContainer<?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _contentType;
    protected final ObjectArraySerializer _delegate;

    public ObjectContainerSerializer(CollectionLikeType containerType, ObjectArraySerializer delegate) {
        super((JavaType)containerType, "any");
        this._contentType = containerType.getContentType();
        this._delegate = delegate;
    }

    protected ObjectContainerSerializer(ObjectContainerSerializer base, ObjectArraySerializer delegate) {
        super(base);
        this._contentType = base._contentType;
        this._delegate = delegate;
    }

    protected ObjectContainerSerializer withDelegate(ObjectArraySerializer newDelegate) {
        return newDelegate == this._delegate ? this : new ObjectContainerSerializer(this, newDelegate);
    }

    @Override
    protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        ObjectArraySerializer ser = (ObjectArraySerializer)this._delegate._withValueTypeSerializer(vts);
        if (ser == this._delegate) {
            return this;
        }
        return this.withDelegate(ser);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this._delegate.acceptJsonFormatVisitor(visitor, typeHint);
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._delegate.getContentSerializer();
    }

    public boolean hasSingleElement(ObjectContainer<?> value) {
        return value.size() == 1;
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, ObjectContainer<?> value) {
        return value.isEmpty();
    }

    @Override
    public JavaType getContentType() {
        return this._contentType;
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        return this.withDelegate((ObjectArraySerializer)this._delegate.createContextual(prov, property));
    }

    @Override
    public void serialize(ObjectContainer<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        this._delegate.serialize(value.toArray(), gen, provider);
    }

    @Override
    public void serializeWithType(ObjectContainer<?> value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this._delegate.serializeWithType((Object)value.toArray(), gen, provider, typeSer);
    }

    @Override
    protected void serializeContents(ObjectContainer<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        throw new IllegalStateException();
    }
}

