/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.hppc.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;

public abstract class ContainerDeserializerBase<T>
extends StdDeserializer<T> {
    protected final Constructor<T> _defaultCtor;

    protected ContainerDeserializerBase(JavaType type, DeserializationConfig config) {
        super(type);
        boolean fixAccess = config.isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS);
        this._defaultCtor = ClassUtil.findConstructor((Class)type.getRawClass(), (boolean)fixAccess);
    }

    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromArray(jp, ctxt);
    }

    public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (!jp.isExpectedStartArrayToken()) {
            return this.handleNonArray(jp, ctxt);
        }
        T container = this.createContainerInstance(ctxt);
        this.deserializeContents(jp, ctxt, container);
        return container;
    }

    protected T handleNonArray(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        T single;
        if (ctxt.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY) && (single = this.handleSingleAsArray(jp, ctxt, this.createContainerInstance(ctxt))) != null) {
            return single;
        }
        throw ctxt.mappingException(this._valueClass);
    }

    protected T createContainerInstance(DeserializationContext ctxt) throws IOException, JsonProcessingException {
        try {
            return this._defaultCtor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw ctxt.instantiationException(this.handledType(), (Throwable)e);
        }
    }

    protected T handleSingleAsArray(JsonParser jp, DeserializationContext ctxt, T container) throws IOException, JsonProcessingException {
        return null;
    }

    public abstract void deserializeContents(JsonParser var1, DeserializationContext var2, T var3) throws IOException, JsonProcessingException;
}

