/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import java.io.IOException;
import java.util.TimeZone;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;

public class IntervalDeserializer
extends JodaDateDeserializerBase<Interval> {
    private static final long serialVersionUID = 1L;

    public IntervalDeserializer() {
        this(FormatConfig.DEFAULT_DATETIME_FORMAT);
    }

    public IntervalDeserializer(JacksonJodaDateFormat format) {
        super(Interval.class, format);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new IntervalDeserializer(format);
    }

    public Interval deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        DateTimeZone tz;
        Interval result;
        boolean hasSlash;
        String v = jsonParser.getText().trim();
        int index = v.indexOf(47, 1);
        boolean bl = hasSlash = index > 0;
        if (!hasSlash) {
            index = v.indexOf(45, 1);
        }
        if (index < 0) {
            throw ctxt.weirdStringException(v, this.handledType(), "no slash or hyphen found to separate start, end");
        }
        String str = v.substring(0, index);
        try {
            if (hasSlash) {
                result = Interval.parse((String)v);
            } else {
                long start = Long.valueOf(str);
                str = v.substring(index + 1);
                long end = Long.valueOf(str);
                result = new Interval(start, end);
            }
        }
        catch (NumberFormatException e) {
            throw JsonMappingException.from((JsonParser)jsonParser, (String)("Failed to parse number from '" + str + "' (full source String '" + v + "') to construct " + this.handledType().getName()));
        }
        DateTimeZone dateTimeZone = tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : DateTimeZone.forTimeZone((TimeZone)ctxt.getTimeZone());
        if (tz != null && !tz.equals((Object)result.getStart().getZone())) {
            result = new Interval(result.getStartMillis(), result.getEndMillis(), tz);
        }
        return result;
    }
}

