/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.ser.JodaDateSerializerBase;
import java.io.IOException;
import org.joda.time.Instant;

public final class InstantSerializer
extends JodaDateSerializerBase<Instant> {
    private static final long serialVersionUID = 1L;

    public InstantSerializer() {
        this(FormatConfig.DEFAULT_TIMEONLY_FORMAT);
    }

    public InstantSerializer(JacksonJodaDateFormat format) {
        super(Instant.class, format, false, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    public InstantSerializer withFormat(JacksonJodaDateFormat formatter) {
        return this._format == formatter ? this : new InstantSerializer(formatter);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Instant value) {
        return value.getMillis() == 0L;
    }

    public void serialize(Instant value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._useTimestamp(provider)) {
            gen.writeNumber(value.getMillis());
        } else {
            gen.writeString(value.toString());
        }
    }
}

