/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class BlockingGetSubscriber<T>
extends CountDownLatch
implements Subscriber<T> {
    volatile boolean cancelled;
    Subscription upstream;
    T value;
    Throwable error;

    BlockingGetSubscriber() {
        super(1);
    }

    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
            this.upstream = s;
            if (this.cancelled) {
                s.cancel();
            } else {
                s.request(Long.MAX_VALUE);
            }
        }
    }

    public void onNext(T t) {
        this.value = t;
    }

    public void onError(Throwable t) {
        this.error = t;
        this.countDown();
    }

    public void onComplete() {
        this.countDown();
    }

    void dispose() {
        this.cancelled = true;
        Subscription a = this.upstream;
        if (a != null) {
            a.cancel();
        }
    }

    T blockingGet() {
        Throwable ex;
        if (this.getCount() != 0L) {
            try {
                this.await();
            }
            catch (InterruptedException ex2) {
                this.dispose();
                throw ExceptionHelper.wrapOrThrow((Throwable)ex2);
            }
        }
        if ((ex = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow((Throwable)ex);
        }
        return this.value;
    }

    T blockingGet(long timeout, TimeUnit unit) {
        Throwable ex;
        if (this.getCount() != 0L) {
            try {
                if (!this.await(timeout, unit)) {
                    this.dispose();
                    throw ExceptionHelper.wrapOrThrow((Throwable)new TimeoutException());
                }
            }
            catch (InterruptedException ex2) {
                this.dispose();
                throw ExceptionHelper.wrapOrThrow((Throwable)ex2);
            }
        }
        if ((ex = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow((Throwable)ex);
        }
        return this.value;
    }

    void blockingCall(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        Throwable ex;
        if (this.getCount() != 0L) {
            try {
                this.await();
            }
            catch (InterruptedException ex2) {
                this.dispose();
                try {
                    onError.accept((Object)ex2);
                }
                catch (Throwable exc) {
                    Exceptions.throwIfFatal((Throwable)exc);
                    RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{ex2, exc}));
                }
                return;
            }
        }
        if ((ex = this.error) != null) {
            try {
                onError.accept((Object)ex);
            }
            catch (Throwable exc) {
                Exceptions.throwIfFatal((Throwable)exc);
                RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{ex, exc}));
            }
            return;
        }
        T v = this.value;
        if (v != null) {
            try {
                onNext.accept(v);
            }
            catch (Throwable exc) {
                Exceptions.throwIfFatal((Throwable)exc);
                try {
                    onError.accept((Object)exc);
                }
                catch (Throwable excc) {
                    Exceptions.throwIfFatal((Throwable)excc);
                    RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{exc, excc}));
                }
                return;
            }
        }
        try {
            onComplete.run();
        }
        catch (Throwable exc) {
            Exceptions.throwIfFatal((Throwable)exc);
            RxJavaPlugins.onError((Throwable)exc);
        }
    }
}

