/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.BasicNonoIntQueueSubscription;
import hu.akarnokd.rxjava3.basetypes.Nono;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class NonoCache
extends Nono
implements Subscriber<Void> {
    static final CacheSubscription[] EMPTY = new CacheSubscription[0];
    static final CacheSubscription[] TERMINATED = new CacheSubscription[0];
    final Nono source;
    final AtomicBoolean once;
    final AtomicReference<CacheSubscription[]> subscribers;
    Throwable error;

    NonoCache(Nono source) {
        this.source = source;
        this.once = new AtomicBoolean();
        this.subscribers = new AtomicReference<CacheSubscription[]>(EMPTY);
    }

    @Override
    protected void subscribeActual(Subscriber<? super Void> s) {
        CacheSubscription inner = new CacheSubscription(s);
        s.onSubscribe((Subscription)inner);
        if (this.add(inner)) {
            if (inner.get() != 0) {
                this.remove(inner);
            }
            if (this.once.compareAndSet(false, true)) {
                this.source.subscribe(this);
            }
        } else if (inner.get() == 0) {
            Throwable ex = this.error;
            if (ex != null) {
                inner.downstream.onError(ex);
            } else {
                inner.downstream.onComplete();
            }
        }
    }

    boolean add(CacheSubscription inner) {
        CacheSubscription[] b;
        CacheSubscription[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new CacheSubscription[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = inner;
        } while (!this.subscribers.compareAndSet(a, b));
        return true;
    }

    void remove(CacheSubscription inner) {
        CacheSubscription[] a;
        int n;
        while ((n = (a = this.subscribers.get()).length) != 0) {
            CacheSubscription[] b;
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != inner) continue;
                j = i;
                break;
            }
            if (j < 0) break;
            if (n == 1) {
                b = EMPTY;
            } else {
                b = new CacheSubscription[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            }
            if (!this.subscribers.compareAndSet(a, b)) continue;
            break;
        }
    }

    public void onSubscribe(Subscription s) {
    }

    public void onNext(Void t) {
    }

    public void onError(Throwable t) {
        this.error = t;
        for (CacheSubscription inner : this.subscribers.getAndSet(TERMINATED)) {
            if (inner.get() != 0) continue;
            inner.downstream.onError(t);
        }
    }

    public void onComplete() {
        for (CacheSubscription inner : this.subscribers.getAndSet(TERMINATED)) {
            if (inner.get() != 0) continue;
            inner.downstream.onComplete();
        }
    }

    final class CacheSubscription
    extends BasicNonoIntQueueSubscription {
        private static final long serialVersionUID = -5746624477415417500L;
        final Subscriber<? super Void> downstream;

        CacheSubscription(Subscriber<? super Void> downstream) {
            this.downstream = downstream;
        }

        public void cancel() {
            if (this.compareAndSet(0, 1)) {
                NonoCache.this.remove(this);
            }
        }
    }
}

