/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.Nono;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.fuseable.QueueSubscription;
import io.reactivex.rxjava3.internal.fuseable.SimpleQueue;
import io.reactivex.rxjava3.internal.queue.SpscArrayQueue;
import io.reactivex.rxjava3.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.internal.util.HalfSerializer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class NonoConcat
extends Nono {
    final Publisher<? extends Nono> sources;
    final int prefetch;
    final ErrorMode errorMode;

    NonoConcat(Publisher<? extends Nono> sources, int prefetch, ErrorMode errorMode) {
        this.sources = sources;
        this.prefetch = prefetch;
        this.errorMode = errorMode;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Void> s) {
        if (this.errorMode == ErrorMode.IMMEDIATE) {
            this.sources.subscribe((Subscriber)new ConcatImmediateSubscriber(s, this.prefetch));
        } else {
            this.sources.subscribe((Subscriber)new ConcatDelayedSubscriber(s, this.prefetch, this.errorMode == ErrorMode.END));
        }
    }

    static final class ConcatDelayedSubscriber
    extends AbstractConcatSubscriber {
        private static final long serialVersionUID = -3402839602492103389L;
        final boolean tillTheEnd;

        ConcatDelayedSubscriber(Subscriber<? super Void> downstream, int prefetch, boolean tillTheEnd) {
            super(downstream, prefetch);
            this.tillTheEnd = tillTheEnd;
        }

        public void onError(Throwable t) {
            if (this.errors.tryAddThrowableOrReport(t)) {
                this.done = true;
                this.drain();
            }
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            this.inner.dispose();
            this.errors.tryTerminateAndReport();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            do {
                boolean empty;
                Nono np;
                if (this.cancelled) {
                    this.queue.clear();
                    return;
                }
                if (this.active) continue;
                if (!this.tillTheEnd && this.errors.get() != null) {
                    this.queue.clear();
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                boolean d = this.done;
                try {
                    np = (Nono)this.queue.poll();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.upstream.cancel();
                    this.queue.clear();
                    this.errors.tryAddThrowableOrReport(ex);
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                boolean bl = empty = np == null;
                if (d && empty) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                if (empty) continue;
                this.requestOne();
                this.active = true;
                np.subscribe(this.inner);
            } while (this.decrementAndGet() != 0);
        }

        @Override
        void innerError(Throwable t) {
            if (this.errors.tryAddThrowableOrReport(t)) {
                if (!this.tillTheEnd) {
                    this.upstream.cancel();
                }
                this.active = false;
                this.drain();
            }
        }
    }

    static final class ConcatImmediateSubscriber
    extends AbstractConcatSubscriber {
        private static final long serialVersionUID = 6000895759062406410L;
        final AtomicInteger wip = new AtomicInteger();

        ConcatImmediateSubscriber(Subscriber<? super Void> downstream, int prefetch) {
            super(downstream, prefetch);
        }

        public void onError(Throwable t) {
            this.cancelIf(true);
            HalfSerializer.onError((Subscriber)this.downstream, (Throwable)t, (AtomicInteger)((Object)this), (AtomicThrowable)this.errors);
        }

        @Override
        public void innerError(Throwable t) {
            this.cancelIf(true);
            HalfSerializer.onError((Subscriber)this.downstream, (Throwable)t, (AtomicInteger)((Object)this), (AtomicThrowable)this.errors);
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void cancel() {
            this.cancelIf(false);
        }

        void cancelIf(boolean error) {
            this.cancelled = true;
            this.upstream.cancel();
            this.inner.dispose();
            if (!error) {
                this.errors.tryTerminateAndReport();
            }
            if (this.wip.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        @Override
        public void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            do {
                boolean empty;
                Nono np;
                if (this.cancelled) {
                    this.queue.clear();
                    return;
                }
                if (this.active) continue;
                boolean d = this.done;
                try {
                    np = (Nono)this.queue.poll();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.upstream.cancel();
                    this.queue.clear();
                    HalfSerializer.onError((Subscriber)this.downstream, (Throwable)ex, (AtomicInteger)((Object)this), (AtomicThrowable)this.errors);
                    return;
                }
                boolean bl = empty = np == null;
                if (d && empty) {
                    HalfSerializer.onComplete((Subscriber)this.downstream, (AtomicInteger)((Object)this), (AtomicThrowable)this.errors);
                    return;
                }
                if (empty) continue;
                this.requestOne();
                this.active = true;
                np.subscribe(this.inner);
            } while (this.wip.decrementAndGet() != 0);
        }
    }

    static abstract class AbstractConcatSubscriber
    extends BasicIntQueueSubscription<Void>
    implements Subscriber<Nono> {
        private static final long serialVersionUID = -2273338080908719181L;
        final Subscriber<? super Void> downstream;
        final int prefetch;
        final int limit;
        final AtomicThrowable errors;
        final InnerSubscriber inner;
        Subscription upstream;
        SimpleQueue<Nono> queue;
        int sourceMode;
        int consumed;
        volatile boolean active;
        volatile boolean done;
        volatile boolean cancelled;

        AbstractConcatSubscriber(Subscriber<? super Void> downstream, int prefetch) {
            this.downstream = downstream;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.errors = new AtomicThrowable();
            this.inner = new InnerSubscriber();
        }

        public final void request(long n) {
        }

        public final int requestFusion(int mode) {
            return mode & 2;
        }

        public final void clear() {
        }

        public final Void poll() throws Exception {
            return null;
        }

        public final boolean isEmpty() {
            return true;
        }

        public final void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                if (s instanceof QueueSubscription) {
                    QueueSubscription qs = (QueueSubscription)s;
                    int m = qs.requestFusion(3);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.done = true;
                        this.downstream.onSubscribe((Subscription)this);
                        this.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.downstream.onSubscribe((Subscription)this);
                        s.request(this.prefetch == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)this.prefetch);
                        return;
                    }
                }
                if (this.prefetch == Integer.MAX_VALUE) {
                    this.queue = new SpscLinkedArrayQueue(Nono.bufferSize());
                    this.downstream.onSubscribe((Subscription)this);
                    s.request(Long.MAX_VALUE);
                } else {
                    this.queue = new SpscArrayQueue(this.prefetch);
                    this.downstream.onSubscribe((Subscription)this);
                    s.request((long)this.prefetch);
                }
            }
        }

        final void requestOne() {
            if (this.sourceMode != 1 && this.prefetch != Integer.MAX_VALUE) {
                int c = this.consumed + 1;
                if (c == this.limit) {
                    this.consumed = 0;
                    this.upstream.request((long)c);
                } else {
                    this.consumed = c;
                }
            }
        }

        public final void onNext(Nono t) {
            if (this.sourceMode == 0 && !this.queue.offer((Object)t)) {
                this.upstream.cancel();
                this.onError((Throwable)new MissingBackpressureException());
                return;
            }
            this.drain();
        }

        final void innerComplete() {
            this.active = false;
            this.drain();
        }

        abstract void drain();

        abstract void innerError(Throwable var1);

        final class InnerSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<Void> {
            private static final long serialVersionUID = -1235060320533681511L;

            InnerSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                SubscriptionHelper.replace((AtomicReference)this, (Subscription)s);
            }

            public void onNext(Void t) {
            }

            public void onError(Throwable t) {
                AbstractConcatSubscriber.this.innerError(t);
            }

            public void onComplete() {
                AbstractConcatSubscriber.this.active = false;
                AbstractConcatSubscriber.this.drain();
            }

            void dispose() {
                SubscriptionHelper.cancel((AtomicReference)this);
            }
        }
    }
}

