/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.BasicRefQueueSubscription;
import hu.akarnokd.rxjava3.basetypes.Nono;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class NonoConcatIterable
extends Nono {
    final Iterable<? extends Nono> sources;
    final boolean delayError;

    NonoConcatIterable(Iterable<? extends Nono> sources, boolean delayError) {
        this.sources = sources;
        this.delayError = delayError;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Void> s) {
        Iterator<? extends Nono> it;
        try {
            it = Objects.requireNonNull(this.sources.iterator(), "The sources Iterable returned a null Iterator");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            EmptySubscription.error((Throwable)ex, s);
            return;
        }
        ConcatSubscriber parent = new ConcatSubscriber(s, it, this.delayError);
        s.onSubscribe((Subscription)parent);
        parent.drain();
    }

    static final class ConcatSubscriber
    extends BasicRefQueueSubscription<Void, Subscription>
    implements Subscriber<Void> {
        private static final long serialVersionUID = -4926738846855955051L;
        final Subscriber<? super Void> downstream;
        final AtomicThrowable errors;
        final Iterator<? extends Nono> iterator;
        final AtomicInteger wip;
        volatile boolean active;

        ConcatSubscriber(Subscriber<? super Void> downstream, Iterator<? extends Nono> iterator, boolean delayError) {
            this.downstream = downstream;
            this.iterator = iterator;
            this.errors = delayError ? new AtomicThrowable() : null;
            this.wip = new AtomicInteger();
        }

        public void cancel() {
            SubscriptionHelper.cancel((AtomicReference)this);
            if (this.errors != null) {
                this.errors.tryTerminateAndReport();
            }
        }

        public void onSubscribe(Subscription s) {
            SubscriptionHelper.replace((AtomicReference)this, (Subscription)s);
        }

        public void onNext(Void t) {
        }

        public void onError(Throwable t) {
            AtomicThrowable err = this.errors;
            if (err != null) {
                if (err.tryAddThrowableOrReport(t)) {
                    this.active = false;
                    this.drain();
                }
            } else {
                this.downstream.onError(t);
            }
        }

        public void onComplete() {
            this.active = false;
            this.drain();
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            do {
                boolean b;
                if (SubscriptionHelper.CANCELLED == this.get()) {
                    return;
                }
                if (this.active) continue;
                Nono np = null;
                try {
                    b = this.iterator.hasNext();
                    if (b) {
                        np = Objects.requireNonNull(this.iterator.next(), "The iterator returned a null Nono");
                    }
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    if (this.errors != null) {
                        this.errors.tryAddThrowableOrReport(ex);
                        this.errors.tryTerminateConsumer(this.downstream);
                    } else {
                        this.downstream.onError(ex);
                    }
                    return;
                }
                if (!b) {
                    if (this.errors != null) {
                        this.errors.tryTerminateConsumer(this.downstream);
                    } else {
                        this.downstream.onComplete();
                    }
                    return;
                }
                this.active = true;
                np.subscribe(this);
            } while (this.wip.decrementAndGet() != 0);
        }
    }
}

