/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.BasicRefQueueSubscription;
import hu.akarnokd.rxjava3.basetypes.Nono;
import io.reactivex.rxjava3.core.CompletableEmitter;
import io.reactivex.rxjava3.core.CompletableOnSubscribe;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Cancellable;
import io.reactivex.rxjava3.internal.disposables.CancellableDisposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class NonoCreate
extends Nono {
    final CompletableOnSubscribe onCreate;

    NonoCreate(CompletableOnSubscribe onCreate) {
        this.onCreate = onCreate;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Void> s) {
        NonoEmitter parent = new NonoEmitter(s);
        s.onSubscribe((Subscription)parent);
        try {
            this.onCreate.subscribe((CompletableEmitter)parent);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            parent.onError(ex);
        }
    }

    static final class NonoEmitter
    extends BasicRefQueueSubscription<Void, Disposable>
    implements CompletableEmitter {
        private static final long serialVersionUID = -7351447810798891941L;
        final Subscriber<? super Void> downstream;

        NonoEmitter(Subscriber<? super Void> downstream) {
            this.downstream = downstream;
        }

        public void cancel() {
            DisposableHelper.dispose((AtomicReference)this);
        }

        public void onComplete() {
            Disposable d = (Disposable)this.getAndSet(DisposableHelper.DISPOSED);
            if (d != DisposableHelper.DISPOSED) {
                this.downstream.onComplete();
                if (d != null) {
                    d.dispose();
                }
            }
        }

        public void onError(Throwable t) {
            if (!this.tryOnError(t)) {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public boolean tryOnError(Throwable t) {
            Disposable d = (Disposable)this.getAndSet(DisposableHelper.DISPOSED);
            if (d != DisposableHelper.DISPOSED) {
                this.downstream.onError(t);
                if (d != null) {
                    d.dispose();
                }
                return true;
            }
            return false;
        }

        public void setDisposable(Disposable d) {
            DisposableHelper.set((AtomicReference)this, (Disposable)d);
        }

        public void setCancellable(Cancellable c) {
            this.setDisposable((Disposable)new CancellableDisposable(c));
        }

        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)((Disposable)this.get()));
        }
    }
}

