/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.BasicRefQueueSubscription;
import hu.akarnokd.rxjava3.basetypes.Nono;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class NonoDelaySubscription
extends Nono {
    final Nono source;
    final Publisher<?> other;

    NonoDelaySubscription(Nono source, Publisher<?> other) {
        this.source = source;
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Void> s) {
        this.other.subscribe((Subscriber)new DelaySubscriptionSubscriber(s, this.source));
    }

    static final class DelaySubscriptionSubscriber
    extends BasicRefQueueSubscription<Object, Subscription>
    implements Subscriber<Object> {
        private static final long serialVersionUID = 7914910659996431449L;
        final Subscriber<? super Void> downstream;
        final Nono source;
        boolean done;

        DelaySubscriptionSubscriber(Subscriber<? super Void> downstream, Nono source) {
            this.downstream = downstream;
            this.source = source;
        }

        public void cancel() {
            SubscriptionHelper.cancel((AtomicReference)this);
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                this.downstream.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(Object t) {
            if (!this.done) {
                ((Subscription)this.get()).cancel();
                this.onComplete();
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)t);
            } else {
                this.downstream.onError(t);
            }
        }

        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.source.subscribe(new MainSubscriber());
            }
        }

        void innerSubscribe(Subscription s) {
            SubscriptionHelper.replace((AtomicReference)this, (Subscription)s);
        }

        final class MainSubscriber
        implements Subscriber<Void> {
            MainSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                DelaySubscriptionSubscriber.this.innerSubscribe(s);
            }

            public void onNext(Void t) {
            }

            public void onError(Throwable t) {
                DelaySubscriptionSubscriber.this.downstream.onError(t);
            }

            public void onComplete() {
                DelaySubscriptionSubscriber.this.downstream.onComplete();
            }
        }
    }
}

