/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class NonoLambdaSubscriber
extends AtomicReference<Subscription>
implements Subscriber<Void>,
Disposable {
    private static final long serialVersionUID = 2347769328526232927L;
    final Action onComplete;
    final Consumer<? super Throwable> onError;

    NonoLambdaSubscriber(Action onComplete, Consumer<? super Throwable> onError) {
        this.onComplete = onComplete;
        this.onError = onError;
    }

    public void onSubscribe(Subscription s) {
        SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s);
    }

    public void onNext(Void t) {
    }

    public void onError(Throwable t) {
        try {
            this.onError.accept((Object)t);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{t, ex}));
        }
    }

    public void onComplete() {
        try {
            this.onComplete.run();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            RxJavaPlugins.onError((Throwable)ex);
        }
    }

    public boolean isDisposed() {
        return SubscriptionHelper.CANCELLED == this.get();
    }

    public void dispose() {
        SubscriptionHelper.cancel((AtomicReference)this);
    }
}

